/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MultiReaderBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.UnsortedBag;
import org.eclipse.collections.api.bag.primitive.BooleanBag;
import org.eclipse.collections.api.bag.primitive.ByteBag;
import org.eclipse.collections.api.bag.primitive.CharBag;
import org.eclipse.collections.api.bag.primitive.DoubleBag;
import org.eclipse.collections.api.bag.primitive.FloatBag;
import org.eclipse.collections.api.bag.primitive.IntBag;
import org.eclipse.collections.api.bag.primitive.LongBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.primitive.ShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.primitive.ObjectLongMaps;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.multimap.bag.UnsortedBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionBag;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.partition.bag.PartitionUnsortedBag;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.UnsortedSetIterable;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;
import org.eclipse.collections.impl.bag.mutable.HashBag;
import org.eclipse.collections.impl.bag.mutable.SynchronizedBag;
import org.eclipse.collections.impl.bag.mutable.UnmodifiableBag;
import org.eclipse.collections.impl.collection.mutable.AbstractMultiReaderMutableCollection;
import org.eclipse.collections.impl.factory.Iterables;

public final class MultiReaderHashBag<T>
extends AbstractMultiReaderMutableCollection<T>
implements Externalizable,
MultiReaderBag<T> {
    private static final long serialVersionUID = 1L;
    private MutableBag<T> delegate;

    @Deprecated
    public MultiReaderHashBag() {
    }

    private MultiReaderHashBag(MutableBag<T> newDelegate) {
        this(newDelegate, new ReentrantReadWriteLock());
    }

    private MultiReaderHashBag(MutableBag<T> newDelegate, ReadWriteLock newLock) {
        this.lock = newLock;
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(newLock);
        this.delegate = newDelegate;
    }

    public static <T> MultiReaderHashBag<T> newBag() {
        return new MultiReaderHashBag(HashBag.newBag());
    }

    public static <T> MultiReaderHashBag<T> newBag(int capacity) {
        return new MultiReaderHashBag(HashBag.newBag(capacity));
    }

    public static <T> MultiReaderHashBag<T> newBag(Iterable<T> iterable) {
        return new MultiReaderHashBag<T>(HashBag.newBag(iterable));
    }

    public static <T> MultiReaderHashBag<T> newBagWith(T ... elements) {
        return new MultiReaderHashBag<T>(HashBag.newBagWith(elements));
    }

    @Override
    protected MutableBag<T> getDelegate() {
        return this.delegate;
    }

    UntouchableMutableBag<T> asReadUntouchable() {
        return new UntouchableMutableBag((MutableBag)this.delegate.asUnmodifiable());
    }

    UntouchableMutableBag<T> asWriteUntouchable() {
        return new UntouchableMutableBag(this.delegate);
    }

    @Override
    public void withReadLockAndDelegate(Procedure<? super MutableBag<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UntouchableMutableBag<T> bag = this.asReadUntouchable();
            procedure.value(bag);
            bag.becomeUseless();
        }
    }

    @Override
    public void withWriteLockAndDelegate(Procedure<? super MutableBag<T>> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            UntouchableMutableBag<T> bag = this.asWriteUntouchable();
            procedure.value(bag);
            bag.becomeUseless();
        }
    }

    @Override
    public MutableBag<T> asSynchronized() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            SynchronizedBag synchronizedBag = SynchronizedBag.of(this);
            return synchronizedBag;
        }
    }

    @Override
    public MutableBag<T> asUnmodifiable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnmodifiableBag unmodifiableBag = UnmodifiableBag.of(this);
            return unmodifiableBag;
        }
    }

    @Override
    public ImmutableBag<T> toImmutable() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ImmutableBag<T> immutableBag = Bags.immutable.withAll(this.delegate);
            return immutableBag;
        }
    }

    @Override
    public int addOccurrences(T item, int occurrences) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            int n = this.delegate.addOccurrences(item, occurrences);
            return n;
        }
    }

    @Override
    public boolean removeOccurrences(Object item, int occurrences) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.delegate.removeOccurrences(item, occurrences);
            return bl;
        }
    }

    @Override
    public boolean setOccurrences(T item, int occurrences) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireWriteLock();){
            boolean bl = this.delegate.setOccurrences(item, occurrences);
            return bl;
        }
    }

    @Override
    public int occurrencesOf(Object item) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.occurrencesOf(item);
            return n;
        }
    }

    @Override
    public int sizeDistinct() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.sizeDistinct();
            return n;
        }
    }

    @Override
    public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.collect((Function)function);
            return unsortedBag;
        }
    }

    @Override
    public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            BooleanBag booleanBag = this.delegate.collectBoolean((BooleanFunction)booleanFunction);
            return booleanBag;
        }
    }

    @Override
    public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ByteBag byteBag = this.delegate.collectByte((ByteFunction)byteFunction);
            return byteBag;
        }
    }

    @Override
    public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            CharBag charBag = this.delegate.collectChar((CharFunction)charFunction);
            return charBag;
        }
    }

    @Override
    public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            DoubleBag doubleBag = this.delegate.collectDouble((DoubleFunction)doubleFunction);
            return doubleBag;
        }
    }

    @Override
    public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            FloatBag floatBag = this.delegate.collectFloat((FloatFunction)floatFunction);
            return floatBag;
        }
    }

    @Override
    public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            IntBag intBag = this.delegate.collectInt((IntFunction)intFunction);
            return intBag;
        }
    }

    @Override
    public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            LongBag longBag = this.delegate.collectLong((LongFunction)longFunction);
            return longBag;
        }
    }

    @Override
    public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ShortBag shortBag = this.delegate.collectShort((ShortFunction)shortFunction);
            return shortBag;
        }
    }

    @Override
    public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.flatCollect(function);
            return unsortedBag;
        }
    }

    @Override
    public MutableList<ObjectIntPair<T>> topOccurrences(int count2) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.topOccurrences(count2);
            return listIterable;
        }
    }

    @Override
    public MutableList<ObjectIntPair<T>> bottomOccurrences(int count2) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            ListIterable listIterable = this.delegate.bottomOccurrences(count2);
            return listIterable;
        }
    }

    @Override
    public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.collectIf((Predicate)predicate, (Function)function);
            return unsortedBag;
        }
    }

    @Override
    public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MutableBag mutableBag = this.collectWithOccurrences(function, Bags.mutable.empty());
            return mutableBag;
        }
    }

    @Override
    public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.forEachWithOccurrences((each2, occurrences) -> target.add(function.valueOf(each2, occurrences)));
            Collection r = target;
            return r;
        }
    }

    @Override
    public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.collectWith(function, (Object)parameter);
            return unsortedBag;
        }
    }

    @Override
    public MutableBag<T> newEmpty() {
        return MultiReaderHashBag.newBag();
    }

    @Override
    public MutableBag<T> reject(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.reject((Predicate)predicate);
            return unsortedBag;
        }
    }

    @Override
    public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.rejectWith(predicate, (Object)parameter);
            return unsortedBag;
        }
    }

    @Override
    public MutableBag<T> tap(Procedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.forEach(procedure);
            MultiReaderHashBag multiReaderHashBag = this;
            return multiReaderHashBag;
        }
    }

    @Override
    public MutableBag<T> select(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.select((Predicate)predicate);
            return unsortedBag;
        }
    }

    @Override
    public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.selectWith(predicate, (Object)parameter);
            return unsortedBag;
        }
    }

    @Override
    public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.selectByOccurrences(predicate);
            return unsortedBag;
        }
    }

    @Override
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.selectInstancesOf((Class)clazz);
            return unsortedBag;
        }
    }

    @Override
    public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionUnsortedBag partitionUnsortedBag = this.delegate.partition((Predicate)predicate);
            return partitionUnsortedBag;
        }
    }

    @Override
    public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            PartitionBag partitionBag = this.delegate.partitionWith(predicate, (Object)parameter);
            return partitionBag;
        }
    }

    @Override
    public MutableMap<T, Integer> toMapOfItemToCount() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MapIterable mapIterable = this.delegate.toMapOfItemToCount();
            return mapIterable;
        }
    }

    @Override
    public String toStringOfItemToCount() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            String string = this.delegate.toStringOfItemToCount();
            return string;
        }
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBagMultimap unsortedBagMultimap = this.delegate.groupBy((Function)function);
            return unsortedBagMultimap;
        }
    }

    @Override
    public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBagMultimap unsortedBagMultimap = this.delegate.groupByEach(function);
            return unsortedBagMultimap;
        }
    }

    @Override
    public <V> MutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            MapIterable mapIterable = this.delegate.groupByUniqueKey((Function)function);
            return mapIterable;
        }
    }

    @Override
    @Deprecated
    public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedBag unsortedBag = this.delegate.zip((Iterable)that);
            return unsortedBag;
        }
    }

    @Override
    @Deprecated
    public MutableSet<Pair<T, Integer>> zipWithIndex() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.delegate.zipWithIndex();
            return unsortedSetIterable;
        }
    }

    @Override
    public RichIterable<RichIterable<T>> chunk(int size2) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            RichIterable richIterable = this.delegate.chunk(size2);
            return richIterable;
        }
    }

    @Override
    public boolean anySatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.anySatisfyWithOccurrences(predicate);
            return bl;
        }
    }

    @Override
    public boolean allSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.allSatisfyWithOccurrences(predicate);
            return bl;
        }
    }

    @Override
    public boolean noneSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.noneSatisfyWithOccurrences(predicate);
            return bl;
        }
    }

    @Override
    public T detectWithOccurrences(ObjectIntPredicate<? super T> predicate) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            T t = this.delegate.detectWithOccurrences(predicate);
            return t;
        }
    }

    @Override
    public <V> MutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        this.forEachWithOccurrences((each2, occurrences) -> result.addToValue(groupBy.valueOf(each2), (long)function.intValueOf(each2) * (long)occurrences));
        return result;
    }

    @Override
    public <V> MutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        MutableObjectLongMap result = ObjectLongMaps.mutable.empty();
        this.forEachWithOccurrences((each2, occurrences) -> result.addToValue(groupBy.valueOf(each2), function.longValueOf(each2) * (long)occurrences));
        return result;
    }

    @Override
    public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            this.delegate.forEachWithOccurrences(procedure);
        }
    }

    @Override
    public boolean equals(Object o) {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            boolean bl = this.delegate.equals(o);
            return bl;
        }
    }

    @Override
    public int hashCode() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            int n = this.delegate.hashCode();
            return n;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.delegate);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.delegate = (MutableBag)in.readObject();
        this.lock = new ReentrantReadWriteLock();
        this.lockWrapper = new AbstractMultiReaderMutableCollection.ReadWriteLockWrapper(this.lock);
    }

    @Override
    public MutableSet<T> selectUnique() {
        try (AbstractMultiReaderMutableCollection.LockWrapper wrapper = this.lockWrapper.acquireReadLock();){
            UnsortedSetIterable unsortedSetIterable = this.getDelegate().selectUnique();
            return unsortedSetIterable;
        }
    }

    @Override
    public RichIterable<T> distinctView() {
        throw new UnsupportedOperationException("distinctView is not supported directly on MultiReader collections.  If you would like to use such as view, you must either use withReadLockAndDelegate() or withWriteLockAndDelegate().");
    }

    private static final class UntouchableIterator<T>
    implements Iterator<T> {
        private Iterator<T> delegate;

        private UntouchableIterator(Iterator<T> newDelegate) {
            this.delegate = newDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        public void becomeUseless() {
            this.delegate = null;
        }
    }

    static final class UntouchableMutableBag<T>
    extends AbstractMultiReaderMutableCollection.UntouchableMutableCollection<T>
    implements MutableBag<T> {
        private final MutableList<UntouchableIterator<T>> requestedIterators = Iterables.mList();

        private UntouchableMutableBag(MutableBag<T> newDelegate) {
            super(newDelegate);
        }

        @Override
        protected MutableBag<T> getDelegate() {
            return (MutableBag)this.delegate;
        }

        public void becomeUseless() {
            this.delegate = null;
            this.requestedIterators.each(UntouchableIterator::becomeUseless);
        }

        @Override
        public MutableBag<T> with(T element) {
            this.add(element);
            return this;
        }

        @Override
        public MutableBag<T> without(T element) {
            this.remove(element);
            return this;
        }

        @Override
        public MutableBag<T> withAll(Iterable<? extends T> elements) {
            this.addAllIterable(elements);
            return this;
        }

        @Override
        public MutableBag<T> withoutAll(Iterable<? extends T> elements) {
            this.removeAllIterable(elements);
            return this;
        }

        @Override
        public MutableBag<T> asSynchronized() {
            throw new UnsupportedOperationException("cannot wrap an UntouchableMutableBag");
        }

        @Override
        public MutableBag<T> asUnmodifiable() {
            throw new UnsupportedOperationException("cannot wrap an UntouchableMutableBag");
        }

        @Override
        public RichIterable<T> distinctView() {
            throw new UnsupportedOperationException("cannot wrap an UntouchableMutableBag");
        }

        @Override
        public ImmutableBag<T> toImmutable() {
            return Bags.immutable.withAll(this.getDelegate());
        }

        @Override
        public Iterator<T> iterator() {
            UntouchableIterator iterator2 = new UntouchableIterator(this.delegate.iterator());
            this.requestedIterators.add(iterator2);
            return iterator2;
        }

        @Override
        public int addOccurrences(T item, int occurrences) {
            return this.getDelegate().addOccurrences(item, occurrences);
        }

        @Override
        public boolean removeOccurrences(Object item, int occurrences) {
            return this.getDelegate().removeOccurrences(item, occurrences);
        }

        @Override
        public boolean setOccurrences(T item, int occurrences) {
            return this.getDelegate().setOccurrences(item, occurrences);
        }

        @Override
        public int occurrencesOf(Object item) {
            return this.getDelegate().occurrencesOf(item);
        }

        @Override
        public int sizeDistinct() {
            return this.getDelegate().sizeDistinct();
        }

        @Override
        public <V> MutableBag<V> collect(Function<? super T, ? extends V> function) {
            return this.getDelegate().collect((Function)function);
        }

        @Override
        public MutableBooleanBag collectBoolean(BooleanFunction<? super T> booleanFunction) {
            return this.getDelegate().collectBoolean((BooleanFunction)booleanFunction);
        }

        @Override
        public boolean anySatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
            return this.getDelegate().anySatisfyWithOccurrences(predicate);
        }

        @Override
        public boolean allSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
            return this.getDelegate().allSatisfyWithOccurrences(predicate);
        }

        @Override
        public boolean noneSatisfyWithOccurrences(ObjectIntPredicate<? super T> predicate) {
            return this.getDelegate().noneSatisfyWithOccurrences(predicate);
        }

        @Override
        public T detectWithOccurrences(ObjectIntPredicate<? super T> predicate) {
            return this.getDelegate().detectWithOccurrences(predicate);
        }

        @Override
        public MutableByteBag collectByte(ByteFunction<? super T> byteFunction) {
            return this.getDelegate().collectByte((ByteFunction)byteFunction);
        }

        @Override
        public MutableCharBag collectChar(CharFunction<? super T> charFunction) {
            return this.getDelegate().collectChar((CharFunction)charFunction);
        }

        @Override
        public MutableDoubleBag collectDouble(DoubleFunction<? super T> doubleFunction) {
            return this.getDelegate().collectDouble((DoubleFunction)doubleFunction);
        }

        @Override
        public MutableFloatBag collectFloat(FloatFunction<? super T> floatFunction) {
            return this.getDelegate().collectFloat((FloatFunction)floatFunction);
        }

        @Override
        public MutableIntBag collectInt(IntFunction<? super T> intFunction) {
            return this.getDelegate().collectInt((IntFunction)intFunction);
        }

        @Override
        public MutableLongBag collectLong(LongFunction<? super T> longFunction) {
            return this.getDelegate().collectLong((LongFunction)longFunction);
        }

        @Override
        public MutableShortBag collectShort(ShortFunction<? super T> shortFunction) {
            return this.getDelegate().collectShort((ShortFunction)shortFunction);
        }

        @Override
        public <V> MutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().flatCollect((Function)function);
        }

        @Override
        public MutableList<ObjectIntPair<T>> topOccurrences(int count2) {
            return this.getDelegate().topOccurrences(count2);
        }

        @Override
        public MutableList<ObjectIntPair<T>> bottomOccurrences(int count2) {
            return this.getDelegate().bottomOccurrences(count2);
        }

        @Override
        public <V> MutableBag<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
            return this.getDelegate().collectIf((Predicate)predicate, (Function)function);
        }

        @Override
        public <V> MutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function) {
            return this.getDelegate().collectWithOccurrences(function);
        }

        @Override
        public <V, R extends Collection<V>> R collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> function, R target) {
            return this.getDelegate().collectWithOccurrences(function, target);
        }

        @Override
        public <P, V> MutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
            return this.getDelegate().collectWith((Function2)function, (Object)parameter);
        }

        @Override
        public <V> MutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
            return this.getDelegate().groupBy((Function)function);
        }

        @Override
        public <V> MutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
            return this.getDelegate().groupByEach((Function)function);
        }

        @Override
        public MutableBag<T> newEmpty() {
            return this.getDelegate().newEmpty();
        }

        @Override
        public MutableBag<T> reject(Predicate<? super T> predicate) {
            return this.getDelegate().reject((Predicate)predicate);
        }

        @Override
        public <P> MutableBag<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().rejectWith((Predicate2)predicate, (Object)parameter);
        }

        @Override
        public MutableBag<T> tap(Procedure<? super T> procedure) {
            this.forEach(procedure);
            return this;
        }

        @Override
        public MutableBag<T> select(Predicate<? super T> predicate) {
            return this.getDelegate().select((Predicate)predicate);
        }

        @Override
        public <P> MutableBag<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().selectWith((Predicate2)predicate, (Object)parameter);
        }

        @Override
        public MutableBag<T> selectByOccurrences(IntPredicate predicate) {
            return this.getDelegate().selectByOccurrences(predicate);
        }

        @Override
        public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
            return this.getDelegate().selectInstancesOf((Class)clazz);
        }

        @Override
        public void forEachWithOccurrences(ObjectIntProcedure<? super T> procedure) {
            this.getDelegate().forEachWithOccurrences(procedure);
        }

        @Override
        public PartitionMutableBag<T> partition(Predicate<? super T> predicate) {
            return this.getDelegate().partition((Predicate)predicate);
        }

        @Override
        public <P> PartitionMutableBag<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
            return this.getDelegate().partitionWith((Predicate2)predicate, (Object)parameter);
        }

        @Override
        @Deprecated
        public <S> MutableBag<Pair<T, S>> zip(Iterable<S> that) {
            return this.getDelegate().zip((Iterable)that);
        }

        @Override
        @Deprecated
        public MutableSet<Pair<T, Integer>> zipWithIndex() {
            return this.getDelegate().zipWithIndex();
        }

        @Override
        public MutableMap<T, Integer> toMapOfItemToCount() {
            return this.getDelegate().toMapOfItemToCount();
        }

        @Override
        public String toStringOfItemToCount() {
            return this.getDelegate().toStringOfItemToCount();
        }

        @Override
        public MutableSet<T> selectUnique() {
            return this.getDelegate().selectUnique();
        }
    }
}

