/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.multimap;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.tuple.Pair;

public interface MutableMultimap<K, V>
extends Multimap<K, V> {
    @Override
    public MutableMultimap<K, V> newEmpty();

    @Override
    public MutableCollection<V> get(K var1);

    public boolean put(K var1, V var2);

    default public MutableMultimap<K, V> withKeyValue(K key, V value) {
        this.put(key, value);
        return this;
    }

    default public MutableMultimap<K, V> withKeyMultiValues(K key, V ... values2) {
        Objects.requireNonNull(values2);
        this.putAll(key, Arrays.asList(values2));
        return this;
    }

    default public boolean add(Pair<? extends K, ? extends V> keyValuePair) {
        return this.put(keyValuePair.getOne(), keyValuePair.getTwo());
    }

    public boolean remove(Object var1, Object var2);

    default public boolean putAllPairs(Pair<? extends K, ? extends V> ... pairs) {
        boolean changed = false;
        for (Pair<K, V> pair : pairs) {
            changed |= this.put(pair.getOne(), pair.getTwo());
        }
        return changed;
    }

    default public boolean putAllPairs(Iterable<? extends Pair<? extends K, ? extends V>> pairs) {
        boolean changed = false;
        for (Pair<K, V> pair : pairs) {
            changed |= this.put(pair.getOne(), pair.getTwo());
        }
        return changed;
    }

    public boolean putAll(K var1, Iterable<? extends V> var2);

    public <KK extends K, VV extends V> boolean putAll(Multimap<KK, VV> var1);

    public RichIterable<V> replaceValues(K var1, Iterable<? extends V> var2);

    public RichIterable<V> removeAll(Object var1);

    public MutableCollection<V> getIfAbsentPutAll(K var1, Iterable<? extends V> var2);

    public void clear();

    @Override
    public MutableMultimap<V, K> flip();

    @Override
    public MutableMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> var1);

    @Override
    public MutableMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> var1);

    @Override
    public MutableMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> var1);

    @Override
    public MutableMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super RichIterable<V>> var1);

    @Override
    public <K2, V2> MutableMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> var1);

    @Override
    public <V2> MutableMultimap<K, V2> collectValues(Function<? super V, ? extends V2> var1);

    @Override
    public <K2, V2> MutableMultimap<K2, V2> collectKeyMultiValues(Function<? super K, ? extends K2> var1, Function<? super V, ? extends V2> var2);

    public MutableMultimap<K, V> asSynchronized();
}

