/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map;

import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMapIterable;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.tuple.Pair;

public interface MapIterable<K, V>
extends RichIterable<V> {
    public V get(Object var1);

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public void forEachValue(Procedure<? super V> var1);

    public MapIterable<K, V> tap(Procedure<? super V> var1);

    public void forEachKey(Procedure<? super K> var1);

    public void forEachKeyValue(Procedure2<? super K, ? super V> var1);

    default public <IV> IV injectIntoKeyValue(IV injectedValue, Function3<? super IV, ? super K, ? super V, ? extends IV> function) {
        Object[] result = new Object[]{injectedValue};
        this.forEachKeyValue((key, value) -> {
            result[0] = function.value((Object)result[0], (Object)key, (Object)value);
        });
        return (IV)result[0];
    }

    public MapIterable<V, K> flipUniqueValues();

    default public V getOrDefault(Object key, V defaultValue) {
        return this.getIfAbsentValue(key, defaultValue);
    }

    public V getIfAbsent(K var1, Function0<? extends V> var2);

    public V getIfAbsentValue(K var1, V var2);

    public <P> V getIfAbsentWith(K var1, Function<? super P, ? extends V> var2, P var3);

    public <A> A ifPresentApply(K var1, Function<? super V, ? extends A> var2);

    public RichIterable<K> keysView();

    public RichIterable<V> valuesView();

    public RichIterable<Pair<K, V>> keyValuesView();

    public Multimap<V, K> flip();

    public MapIterable<K, V> select(Predicate2<? super K, ? super V> var1);

    public MapIterable<K, V> reject(Predicate2<? super K, ? super V> var1);

    public <K2, V2> MapIterable<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> var1);

    public <R> MapIterable<K, R> collectValues(Function2<? super K, ? super V, ? extends R> var1);

    public Pair<K, V> detect(Predicate2<? super K, ? super V> var1);

    public Optional<Pair<K, V>> detectOptional(Predicate2<? super K, ? super V> var1);

    public boolean equals(Object var1);

    public int hashCode();

    @Override
    public String toString();

    public ImmutableMapIterable<K, V> toImmutable();

    default public Stream<V> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<V> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @Override
    default public Spliterator<V> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
    }

    default public <K1, V1, V2> MapIterable<K1, V2> aggregateBy(Function<? super K, ? extends K1> keyFunction, Function<? super V, ? extends V1> valueFunction, Function0<? extends V2> zeroValueFactory, Function2<? super V2, ? super V1, ? extends V2> nonMutatingAggregator) {
        MutableMap map2 = Maps.mutable.empty();
        this.forEachKeyValue((key, value) -> map2.updateValueWith(keyFunction.valueOf((Object)key), zeroValueFactory, nonMutatingAggregator, valueFunction.valueOf((Object)value)));
        return map2;
    }
}

