/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.ordered.primitive.ReversibleIntIterable;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.api.tuple.primitive.IntObjectPair;

public interface IntList
extends ReversibleIntIterable {
    public int get(int var1);

    public long dotProduct(IntList var1);

    public int binarySearch(int var1);

    public int lastIndexOf(int var1);

    @Override
    public IntList select(IntPredicate var1);

    @Override
    public IntList reject(IntPredicate var1);

    @Override
    default public IntList tap(IntProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    default public void forEachInBoth(IntList other, IntIntProcedure procedure) {
        Objects.requireNonNull(other);
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("Attempt to call forEachInBoth with two IntList instances of different sizes :" + this.size() + ':' + other.size());
        }
        this.forEachWithIndex((each2, index) -> procedure.value(each2, other.get(index)));
    }

    @Override
    default public IntList selectWithIndex(IntIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each2 -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each2, n);
        });
    }

    @Override
    default public IntList rejectWithIndex(IntIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each2 -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each2, n);
        });
    }

    public <V> ListIterable<V> collect(IntToObjectFunction<? extends V> var1);

    default public <V> ListIterable<V> collectWithIndex(IntIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((int each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each2, n);
        });
    }

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableIntList toImmutable();

    @Override
    public IntList distinct();

    @Override
    public IntList toReversed();

    public IntList subList(int var1, int var2);

    default public ListIterable<IntIntPair> zipInt(IntIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> ListIterable<IntObjectPair<T>> zip(Iterable<T> iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public Spliterator.OfInt spliterator();

    default public IntStream primitiveStream() {
        return StreamSupport.intStream(this.spliterator(), false);
    }

    default public IntStream primitiveParallelStream() {
        return StreamSupport.intStream(this.spliterator(), true);
    }
}

