/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Objects;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatFloatProcedure;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.ordered.primitive.ReversibleFloatIterable;
import org.eclipse.collections.api.tuple.primitive.FloatFloatPair;
import org.eclipse.collections.api.tuple.primitive.FloatObjectPair;

public interface FloatList
extends ReversibleFloatIterable {
    public float get(int var1);

    public double dotProduct(FloatList var1);

    public int binarySearch(float var1);

    public int lastIndexOf(float var1);

    @Override
    public FloatList select(FloatPredicate var1);

    @Override
    public FloatList reject(FloatPredicate var1);

    @Override
    default public FloatList tap(FloatProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    default public void forEachInBoth(FloatList other, FloatFloatProcedure procedure) {
        Objects.requireNonNull(other);
        if (this.size() != other.size()) {
            throw new IllegalArgumentException("Attempt to call forEachInBoth with two FloatList instances of different sizes :" + this.size() + ':' + other.size());
        }
        this.forEachWithIndex((each2, index) -> procedure.value(each2, other.get(index)));
    }

    @Override
    default public FloatList selectWithIndex(FloatIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.select(each2 -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each2, n);
        });
    }

    @Override
    default public FloatList rejectWithIndex(FloatIntPredicate predicate) {
        int[] index = new int[]{0};
        return this.reject(each2 -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each2, n);
        });
    }

    public <V> ListIterable<V> collect(FloatToObjectFunction<? extends V> var1);

    default public <V> ListIterable<V> collectWithIndex(FloatIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((float each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each2, n);
        });
    }

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableFloatList toImmutable();

    @Override
    public FloatList distinct();

    @Override
    public FloatList toReversed();

    public FloatList subList(int var1, int var2);

    default public ListIterable<FloatFloatPair> zipFloat(FloatIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> ListIterable<FloatObjectPair<T>> zip(Iterable<T> iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }
}

