/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list;

import java.util.List;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.ObjectIntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.primitive.ImmutableBooleanList;
import org.eclipse.collections.api.list.primitive.ImmutableByteList;
import org.eclipse.collections.api.list.primitive.ImmutableCharList;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.list.primitive.ImmutableFloatList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.eclipse.collections.api.list.primitive.ImmutableLongList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.partition.list.PartitionImmutableList;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutableList<T>
extends ImmutableCollection<T>,
ListIterable<T> {
    @Override
    public ImmutableList<T> newWith(T var1);

    @Override
    public ImmutableList<T> newWithout(T var1);

    @Override
    public ImmutableList<T> newWithAll(Iterable<? extends T> var1);

    @Override
    public ImmutableList<T> newWithoutAll(Iterable<? extends T> var1);

    @Override
    public ImmutableList<T> tap(Procedure<? super T> var1);

    @Override
    public ImmutableList<T> select(Predicate<? super T> var1);

    @Override
    public <P> ImmutableList<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public ImmutableList<T> reject(Predicate<? super T> var1);

    @Override
    public <P> ImmutableList<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionImmutableList<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionImmutableList<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> ImmutableList<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> ImmutableList<V> collect(Function<? super T, ? extends V> var1);

    @Override
    default public <V> ImmutableList<V> collectWithIndex(ObjectIntToObjectFunction<? super T, ? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((T each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.valueOf(each2, n);
        });
    }

    @Override
    default public ImmutableList<T> selectWithIndex(ObjectIntPredicate<? super T> predicate) {
        int[] index = new int[]{0};
        return this.select((T each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each2, n);
        });
    }

    @Override
    default public ImmutableList<T> rejectWithIndex(ObjectIntPredicate<? super T> predicate) {
        int[] index = new int[]{0};
        return this.reject((T each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return predicate.accept(each2, n);
        });
    }

    @Override
    public ImmutableBooleanList collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public ImmutableByteList collectByte(ByteFunction<? super T> var1);

    @Override
    public ImmutableCharList collectChar(CharFunction<? super T> var1);

    @Override
    public ImmutableDoubleList collectDouble(DoubleFunction<? super T> var1);

    @Override
    public ImmutableFloatList collectFloat(FloatFunction<? super T> var1);

    @Override
    public ImmutableIntList collectInt(IntFunction<? super T> var1);

    @Override
    public ImmutableLongList collectLong(LongFunction<? super T> var1);

    @Override
    public ImmutableShortList collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> ImmutableList<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> ImmutableList<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> ImmutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> ImmutableList<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each2) -> (Iterable)function.apply((Object)each2, (Object)parameter));
    }

    @Override
    public <V> ImmutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> ImmutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    public ImmutableList<T> distinct();

    @Override
    public ImmutableList<T> distinct(HashingStrategy<? super T> var1);

    @Override
    public <V> ImmutableList<T> distinctBy(Function<? super T, ? extends V> var1);

    @Override
    public <S> ImmutableList<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public ImmutableList<Pair<T, Integer>> zipWithIndex();

    @Override
    public ImmutableList<T> take(int var1);

    @Override
    public ImmutableList<T> takeWhile(Predicate<? super T> var1);

    @Override
    public ImmutableList<T> drop(int var1);

    @Override
    public ImmutableList<T> dropWhile(Predicate<? super T> var1);

    @Override
    public PartitionImmutableList<T> partitionWhile(Predicate<? super T> var1);

    public List<T> castToList();

    @Override
    public ImmutableList<T> subList(int var1, int var2);

    @Override
    public ImmutableList<T> toReversed();

    @Override
    default public ImmutableList<T> toImmutableList() {
        return this;
    }
}

