/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.bag;

import org.eclipse.collections.api.bag.ImmutableBagIterable;
import org.eclipse.collections.api.bag.UnsortedBag;
import org.eclipse.collections.api.bag.primitive.ImmutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.ImmutableByteBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.ImmutableFloatBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.ImmutableLongBag;
import org.eclipse.collections.api.bag.primitive.ImmutableShortBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.multimap.bag.ImmutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionImmutableBag;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.ObjectIntPair;

public interface ImmutableBag<T>
extends UnsortedBag<T>,
ImmutableBagIterable<T> {
    @Override
    public ImmutableBag<T> newWith(T var1);

    @Override
    public ImmutableBag<T> newWithout(T var1);

    @Override
    public ImmutableBag<T> newWithAll(Iterable<? extends T> var1);

    @Override
    public ImmutableBag<T> newWithoutAll(Iterable<? extends T> var1);

    @Override
    public ImmutableBag<T> selectByOccurrences(IntPredicate var1);

    @Override
    default public ImmutableBag<T> selectDuplicates() {
        return this.selectByOccurrences(occurrences -> occurrences > 1);
    }

    @Override
    default public ImmutableSet<T> selectUnique() {
        MutableSet result = Sets.mutable.empty();
        this.forEachWithOccurrences((each2, occurrences) -> {
            if (occurrences == 1) {
                result.add(each2);
            }
        });
        return result.toImmutable();
    }

    @Override
    public ImmutableBag<T> tap(Procedure<? super T> var1);

    @Override
    public ImmutableBag<T> select(Predicate<? super T> var1);

    @Override
    public <P> ImmutableBag<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public ImmutableBag<T> reject(Predicate<? super T> var1);

    @Override
    public <P> ImmutableBag<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public PartitionImmutableBag<T> partition(Predicate<? super T> var1);

    @Override
    public <P> PartitionImmutableBag<T> partitionWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> ImmutableBag<S> selectInstancesOf(Class<S> var1);

    @Override
    public <V> ImmutableBag<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public ImmutableBooleanBag collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public ImmutableByteBag collectByte(ByteFunction<? super T> var1);

    @Override
    public ImmutableCharBag collectChar(CharFunction<? super T> var1);

    @Override
    public ImmutableDoubleBag collectDouble(DoubleFunction<? super T> var1);

    @Override
    public ImmutableFloatBag collectFloat(FloatFunction<? super T> var1);

    @Override
    public ImmutableIntBag collectInt(IntFunction<? super T> var1);

    @Override
    public ImmutableLongBag collectLong(LongFunction<? super T> var1);

    @Override
    public ImmutableShortBag collectShort(ShortFunction<? super T> var1);

    @Override
    public <P, V> ImmutableBag<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> ImmutableBag<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    @Override
    public <V> ImmutableBag<V> collectWithOccurrences(ObjectIntToObjectFunction<? super T, ? extends V> var1);

    @Override
    public <V> ImmutableBag<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> ImmutableBag<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each2) -> (Iterable)function.apply((Object)each2, (Object)parameter));
    }

    @Override
    default public <V> ImmutableBag<V> countBy(Function<? super T, ? extends V> function) {
        return this.collect((Function)function);
    }

    @Override
    default public <V, P> ImmutableBag<V> countByWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return this.collectWith((Function2)function, (Object)parameter);
    }

    @Override
    default public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.flatCollect((Function)function);
    }

    @Override
    public <V> ImmutableBagMultimap<V, T> groupBy(Function<? super T, ? extends V> var1);

    @Override
    public <V> ImmutableBagMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    @Deprecated
    public <S> ImmutableBag<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    @Deprecated
    public ImmutableSet<Pair<T, Integer>> zipWithIndex();

    @Override
    public ImmutableList<ObjectIntPair<T>> topOccurrences(int var1);

    @Override
    public ImmutableList<ObjectIntPair<T>> bottomOccurrences(int var1);

    @Override
    default public ImmutableBag<T> toImmutableBag() {
        return this;
    }
}

