/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.Comparator;
import java.util.DoubleSummaryStatistics;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.block.comparator.primitive.FloatComparator;
import org.eclipse.collections.api.block.function.primitive.BooleanFloatToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFloatToByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFloatToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFloatToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToByteFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToCharFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToIntFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToLongFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToShortFunction;
import org.eclipse.collections.api.block.function.primitive.IntFloatToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFloatToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFloatToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.set.primitive.FloatSet;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;

public interface FloatIterable
extends PrimitiveIterable {
    public FloatIterator floatIterator();

    public float[] toArray();

    default public float[] toArray(float[] target) {
        return this.toList().toArray(target);
    }

    public boolean contains(float var1);

    default public boolean containsAll(float ... source) {
        if (this.size() <= 32 || source.length < 4) {
            for (float item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
        FloatSet set = this instanceof FloatSet ? (FloatSet)this : this.toSet();
        for (float item : source) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(FloatIterable source) {
        if (this.size() <= 32 || source.size() < 4) {
            return source.allSatisfy(this::contains);
        }
        FloatSet set = this instanceof FloatSet ? (FloatSet)this : this.toSet();
        return source.allSatisfy(set::contains);
    }

    default public boolean containsAny(float ... source) {
        FloatIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof FloatSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(FloatIterable source) {
        FloatIterable outside = this;
        FloatIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof FloatSet) {
            FloatIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof FloatSet)) {
            inside = inside.toSet();
        }
        return outside.anySatisfy(inside::contains);
    }

    default public boolean containsNone(float ... source) {
        FloatIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof FloatSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsNone(FloatIterable source) {
        FloatIterable outside = this;
        FloatIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof FloatSet) {
            FloatIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof FloatSet)) {
            inside = inside.toSet();
        }
        return outside.noneSatisfy(inside::contains);
    }

    default public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    public void each(FloatProcedure var1);

    default public FloatIterable tap(FloatProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public FloatIterable select(FloatPredicate var1);

    public FloatIterable reject(FloatPredicate var1);

    default public <R extends MutableFloatCollection> R select(FloatPredicate predicate, R target) {
        this.each(each2 -> {
            if (predicate.accept(each2)) {
                target.add(each2);
            }
        });
        return target;
    }

    default public <R extends MutableFloatCollection> R reject(FloatPredicate predicate, R target) {
        this.each(each2 -> {
            if (!predicate.accept(each2)) {
                target.add(each2);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(FloatToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(FloatToObjectFunction<? extends V> function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(FloatToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each2 -> {
            Iterable iterable = (Iterable)function.valueOf(each2);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(FloatToBooleanFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(FloatToByteFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(FloatToCharFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(FloatToShortFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(FloatToIntFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(FloatToFloatFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(FloatToLongFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(FloatToDoubleFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    public float detectIfNone(FloatPredicate var1, float var2);

    public int count(FloatPredicate var1);

    public boolean anySatisfy(FloatPredicate var1);

    public boolean allSatisfy(FloatPredicate var1);

    default public boolean noneSatisfy(FloatPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public MutableFloatList toList();

    public MutableFloatSet toSet();

    public MutableFloatBag toBag();

    public LazyFloatIterable asLazy();

    public <T> T injectInto(T var1, ObjectFloatToObjectFunction<? super T, ? extends T> var2);

    default public boolean injectIntoBoolean(boolean injectedValue, BooleanFloatToBooleanFunction function) {
        boolean[] result = new boolean[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public byte injectIntoByte(byte injectedValue, ByteFloatToByteFunction function) {
        byte[] result = new byte[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public char injectIntoChar(char injectedValue, CharFloatToCharFunction function) {
        char[] result = new char[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public short injectIntoShort(short injectedValue, ShortFloatToShortFunction function) {
        short[] result = new short[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public int injectIntoInt(int injectedValue, IntFloatToIntFunction function) {
        int[] result = new int[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public float injectIntoFloat(float injectedValue, FloatFloatToFloatFunction function) {
        float[] result = new float[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public long injectIntoLong(long injectedValue, LongFloatToLongFunction function) {
        long[] result = new long[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public double injectIntoDouble(double injectedValue, DoubleFloatToDoubleFunction function) {
        double[] result = new double[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public double reduceIfEmpty(DoubleFloatToDoubleFunction accumulator, double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public double reduce(DoubleFloatToDoubleFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        double[] result = new double[1];
        this.each(each2 -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each2);
            } else {
                seenOne[0] = true;
                result[0] = each2;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<FloatIterable> chunk(int size2) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public double sum();

    default public DoubleSummaryStatistics summaryStatistics() {
        DoubleSummaryStatistics stats = new DoubleSummaryStatistics();
        this.forEach(stats::accept);
        return stats;
    }

    public float max();

    public float maxIfEmpty(float var1);

    public float min();

    public float minIfEmpty(float var1);

    public double average();

    default public double averageIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.average();
    }

    public double median();

    default public double medianIfEmpty(double defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.median();
    }

    public float[] toSortedArray();

    public MutableFloatList toSortedList();

    default public MutableFloatList toSortedList(FloatComparator comparator) {
        return this.toList().sortThis(comparator);
    }

    default public <T> MutableFloatList toSortedListBy(FloatToObjectFunction<T> function) {
        return this.toList().sortThisBy(function);
    }

    default public <T> MutableFloatList toSortedListBy(FloatToObjectFunction<T> function, Comparator<? super T> comparator) {
        return this.toList().sortThisBy(function, comparator);
    }
}

