/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.BooleanBooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToBooleanFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToByteFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToCharFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToIntFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToLongFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.BooleanToShortFunction;
import org.eclipse.collections.api.block.function.primitive.ByteBooleanToByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharBooleanToCharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleBooleanToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatBooleanToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntBooleanToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongBooleanToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortBooleanToShortFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.BooleanSet;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;

public interface BooleanIterable
extends PrimitiveIterable {
    public BooleanIterator booleanIterator();

    public boolean[] toArray();

    default public boolean[] toArray(boolean[] target) {
        return this.toList().toArray(target);
    }

    public boolean contains(boolean var1);

    default public boolean containsAll(boolean ... source) {
        if (this.size() <= 32 || source.length < 4) {
            for (boolean item : source) {
                if (this.contains(item)) continue;
                return false;
            }
            return true;
        }
        BooleanSet set = this instanceof BooleanSet ? (BooleanSet)this : this.toSet();
        for (boolean item : source) {
            if (set.contains(item)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsAll(BooleanIterable source) {
        if (this.size() <= 32 || source.size() < 4) {
            return source.allSatisfy(this::contains);
        }
        BooleanSet set = this instanceof BooleanSet ? (BooleanSet)this : this.toSet();
        return source.allSatisfy(set::contains);
    }

    default public boolean containsAny(boolean ... source) {
        BooleanIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof BooleanSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAny(BooleanIterable source) {
        BooleanIterable outside = this;
        BooleanIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof BooleanSet) {
            BooleanIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof BooleanSet)) {
            inside = inside.toSet();
        }
        return outside.anySatisfy(inside::contains);
    }

    default public boolean containsNone(boolean ... source) {
        BooleanIterable inside = this;
        if (this.size() > 32 && source.length > 32 && !(this instanceof BooleanSet)) {
            inside = this.toSet();
        }
        for (int i = 0; i < source.length; ++i) {
            if (!inside.contains(source[i])) continue;
            return false;
        }
        return true;
    }

    default public boolean containsNone(BooleanIterable source) {
        BooleanIterable outside = this;
        BooleanIterable inside = source;
        if (this.size() < source.size()) {
            outside = source;
            inside = this;
        }
        if (outside instanceof BooleanSet) {
            BooleanIterable temp = outside;
            outside = inside;
            inside = temp;
        } else if (inside.size() > 32 && !(inside instanceof BooleanSet)) {
            inside = inside.toSet();
        }
        return outside.noneSatisfy(inside::contains);
    }

    default public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    public void each(BooleanProcedure var1);

    default public BooleanIterable tap(BooleanProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public BooleanIterable select(BooleanPredicate var1);

    public BooleanIterable reject(BooleanPredicate var1);

    default public <R extends MutableBooleanCollection> R select(BooleanPredicate predicate, R target) {
        this.each(each2 -> {
            if (predicate.accept(each2)) {
                target.add(each2);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R reject(BooleanPredicate predicate, R target) {
        this.each(each2 -> {
            if (!predicate.accept(each2)) {
                target.add(each2);
            }
        });
        return target;
    }

    public <V> RichIterable<V> collect(BooleanToObjectFunction<? extends V> var1);

    default public <V, R extends Collection<V>> R collect(BooleanToObjectFunction<? extends V> function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <V, R extends Collection<V>> R flatCollect(BooleanToObjectFunction<? extends Iterable<V>> function, R target) {
        this.each(each2 -> {
            Iterable iterable = (Iterable)function.valueOf(each2);
            if (iterable instanceof Collection) {
                target.addAll((Collection)iterable);
            } else {
                iterable.forEach(target::add);
            }
        });
        return target;
    }

    default public <R extends MutableBooleanCollection> R collectBoolean(BooleanToBooleanFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableByteCollection> R collectByte(BooleanToByteFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableCharCollection> R collectChar(BooleanToCharFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableShortCollection> R collectShort(BooleanToShortFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableIntCollection> R collectInt(BooleanToIntFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableFloatCollection> R collectFloat(BooleanToFloatFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableLongCollection> R collectLong(BooleanToLongFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    default public <R extends MutableDoubleCollection> R collectDouble(BooleanToDoubleFunction function, R target) {
        this.each(each2 -> target.add(function.valueOf(each2)));
        return target;
    }

    public boolean detectIfNone(BooleanPredicate var1, boolean var2);

    public int count(BooleanPredicate var1);

    public boolean anySatisfy(BooleanPredicate var1);

    public boolean allSatisfy(BooleanPredicate var1);

    default public boolean noneSatisfy(BooleanPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public MutableBooleanList toList();

    public MutableBooleanSet toSet();

    public MutableBooleanBag toBag();

    public LazyBooleanIterable asLazy();

    public <T> T injectInto(T var1, ObjectBooleanToObjectFunction<? super T, ? extends T> var2);

    default public boolean injectIntoBoolean(boolean injectedValue, BooleanBooleanToBooleanFunction function) {
        boolean[] result = new boolean[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public byte injectIntoByte(byte injectedValue, ByteBooleanToByteFunction function) {
        byte[] result = new byte[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public char injectIntoChar(char injectedValue, CharBooleanToCharFunction function) {
        char[] result = new char[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public short injectIntoShort(short injectedValue, ShortBooleanToShortFunction function) {
        short[] result = new short[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public int injectIntoInt(int injectedValue, IntBooleanToIntFunction function) {
        int[] result = new int[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public float injectIntoFloat(float injectedValue, FloatBooleanToFloatFunction function) {
        float[] result = new float[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public long injectIntoLong(long injectedValue, LongBooleanToLongFunction function) {
        long[] result = new long[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public double injectIntoDouble(double injectedValue, DoubleBooleanToDoubleFunction function) {
        double[] result = new double[]{injectedValue};
        this.each(each2 -> {
            result[0] = function.valueOf(result[0], each2);
        });
        return result[0];
    }

    default public boolean reduceIfEmpty(BooleanBooleanToBooleanFunction accumulator, boolean defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.reduce(accumulator);
    }

    default public boolean reduce(BooleanBooleanToBooleanFunction accumulator) {
        boolean[] seenOne = new boolean[1];
        boolean[] result = new boolean[1];
        this.each(each2 -> {
            if (seenOne[0]) {
                result[0] = accumulator.valueOf(result[0], each2);
            } else {
                seenOne[0] = true;
                result[0] = each2;
            }
        });
        if (!seenOne[0]) {
            throw new NoSuchElementException();
        }
        return result[0];
    }

    default public RichIterable<BooleanIterable> chunk(int size2) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }
}

