/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.vcard.property;

import java.text.ParseException;
import java.util.List;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Escapable;
import net.fortuna.ical4j.util.Strings;
import net.fortuna.ical4j.validate.ValidationException;
import net.fortuna.ical4j.vcard.AbstractFactory;
import net.fortuna.ical4j.vcard.Group;
import net.fortuna.ical4j.vcard.Parameter;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.PropertyFactory;
import net.fortuna.ical4j.vcard.parameter.Value;

public final class BDay
extends Property
implements Escapable {
    private static final long serialVersionUID = 4298026868242865633L;
    private Date date;
    private String text;

    public BDay(Date date) {
        super(Property.Id.BDAY);
        this.date = date;
    }

    public BDay(String text) {
        super(Property.Id.BDAY);
        this.text = text;
        this.getParameters().add(Value.TEXT);
    }

    public BDay(List<Parameter> params, String value) throws ParseException {
        super(Property.Id.BDAY, params);
        if (Value.TEXT.equals(this.getParameter(Parameter.Id.VALUE))) {
            this.text = value;
        } else {
            try {
                this.date = new Date(value);
            }
            catch (ParseException e) {
                try {
                    this.date = new DateTime(value);
                }
                catch (ParseException e2) {
                    try {
                        this.date = new Date(value, "yyyy'-'MM'-'dd");
                    }
                    catch (ParseException e3) {
                        this.date = new DateTime(value, "yyyy'-'MM'-'dd'T'HH':'mm':'ss'Z'", true);
                    }
                }
            }
        }
    }

    public Date getDate() {
        return this.date;
    }

    public String getText() {
        return this.text;
    }

    @Override
    public String getValue() {
        if (Value.TEXT.equals(this.getParameter(Parameter.Id.VALUE))) {
            return this.text;
        }
        return Strings.valueOf((Object)this.date);
    }

    @Override
    public void validate() throws ValidationException {
        this.assertOneOrLess(Parameter.Id.VALUE);
        if (this.getParameters().size() > 1) {
            throw new ValidationException("Illegal parameter count");
        }
        for (Parameter param : this.getParameters()) {
            if (Value.TEXT.equals(param)) continue;
            throw new ValidationException("Illegal parameter [" + (Object)((Object)param.getId()) + "]");
        }
    }

    public static class Factory
    extends AbstractFactory
    implements PropertyFactory<BDay> {
        public Factory() {
            super(Property.Id.BDAY.toString());
        }

        @Override
        public BDay createProperty(List<Parameter> params, String value) throws ParseException {
            return new BDay(params, Strings.unescape((String)value));
        }

        @Override
        public BDay createProperty(Group group, List<Parameter> params, String value) {
            return null;
        }
    }
}

