/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.videoconferencing.webex;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.core.commons.gwt.JsMapStringString;
import net.bluemind.core.container.api.IContainerManagementPromise;
import net.bluemind.core.container.api.gwt.endpoint.ContainerManagementGwtEndpoint;
import net.bluemind.core.container.model.acl.AccessControlEntry;
import net.bluemind.core.container.model.acl.Verb;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.CompositeGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtWidgetElement;
import net.bluemind.resource.api.IResourcesPromise;
import net.bluemind.resource.api.ResourceDescriptor;
import net.bluemind.resource.api.gwt.endpoint.ResourcesGwtEndpoint;
import net.bluemind.ui.adminconsole.videoconferencing.webex.l10n.WebexConstants;
import net.bluemind.ui.common.client.forms.Ajax;
import net.bluemind.ui.common.client.forms.tag.UUID;
import net.bluemind.ui.editor.client.Editor;
import net.bluemind.videoconferencing.api.IVideoConferencingPromise;
import net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor;
import net.bluemind.videoconferencing.api.gwt.endpoint.VideoConferencingGwtEndpoint;

public class WebexEditor
extends CompositeGwtWidgetElement {
    static final String TYPE = "bm.ac.WebexEditor";
    private static final String PROVIDER_NAME = "Webex";
    private static final String PROVIDER_TYPE = "videoconferencing-webex";
    private static final String SETTINGS_TEMPLATES = "templates";
    private static final String WEBEX_ICS_MAIL = "webex-ics-mail";
    private static final List<String> SUPPORTED_LANGUAGES = Arrays.asList("fr", "en", "de", "es", "pt", "it", "hu", "nl", "pl", "ru", "sk", "uk", "zh");
    private static WebexEditorUiBinder uiBinder = (WebexEditorUiBinder)GWT.create(WebexEditorUiBinder.class);
    @UiField
    Editor templateEditor;
    @UiField
    ListBox templateLanguagesComboBox;
    @UiField
    TextBox webexIcsUrl;
    @UiField
    Button deleteBtn;
    private String domainUid;
    private String resourceUid;
    private Map<String, String> templatesByLanguage = new HashMap<String, String>();
    private int selectedTemplateIndex;

    @UiHandler(value={"deleteBtn"})
    void deleteClick(ClickEvent clickEvent) {
        if (Window.confirm((String)WebexConstants.INST.deleteBtnConfirm())) {
            this.removeResource();
        }
    }

    protected WebexEditor() {
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        this.initWidget((Widget)hTMLPanel);
    }

    public static void registerType() {
        GwtWidgetElement.register((String)TYPE, (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtWidgetElement, WidgetElement>(){

            public IGwtWidgetElement create(WidgetElement widgetElement) {
                return new WebexEditor();
            }
        });
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
        String string2;
        super.loadModel(javaScriptObject);
        this.deleteBtn.setVisible(false);
        JsMapStringJsObject jsMapStringJsObject = (JsMapStringJsObject)javaScriptObject.cast();
        this.domainUid = jsMapStringJsObject.getString("domainUid");
        for (String string2 : SUPPORTED_LANGUAGES) {
            this.templateLanguagesComboBox.addItem(string2);
        }
        this.templateLanguagesComboBox.setSelectedIndex(0);
        this.selectedTemplateIndex = 0;
        this.templateLanguagesComboBox.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent changeEvent) {
                WebexEditor.this.storeCurrentTemplate();
                WebexEditor.this.selectedTemplateIndex = WebexEditor.this.templateLanguagesComboBox.getSelectedIndex();
                WebexEditor.this.templateEditor.setText((String)WebexEditor.this.templatesByLanguage.get(SUPPORTED_LANGUAGES.get(WebexEditor.this.selectedTemplateIndex)));
            }
        });
        string2 = new ResourcesGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        string2.byType("bm-videoconferencing").thenAccept(arg_0 -> this.lambda$0((IResourcesPromise)string2, arg_0));
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
        if (this.resourceUid != null) {
            this.setResourceSettings(this.resourceUid);
        } else {
            this.storeCurrentTemplate();
            if (!this.templatesByLanguage.isEmpty()) {
                String string = UUID.uuid();
                this.createResource(string).thenAccept(void_ -> this.setResourceSettings(string));
            }
        }
    }

    private CompletableFuture<Void> createResource(String string) {
        IVideoConferencingPromise iVideoConferencingPromise = new VideoConferencingGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        return iVideoConferencingPromise.createResource(string, VideoConferencingResourceDescriptor.create((String)PROVIDER_NAME, (String)PROVIDER_TYPE, Arrays.asList(AccessControlEntry.create((String)this.domainUid, (Verb)Verb.Invitation))));
    }

    private void setResourceSettings(String string) {
        IContainerManagementPromise iContainerManagementPromise = new ContainerManagementGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.getResourceSettingsContainer(string)}).promiseApi();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.storeCurrentTemplate();
        String string2 = JsonUtils.stringify((JavaScriptObject)JsMapStringString.create(this.templatesByLanguage));
        hashMap.put(SETTINGS_TEMPLATES, string2);
        if (this.webexIcsUrl.getValue() != null) {
            hashMap.put(WEBEX_ICS_MAIL, this.webexIcsUrl.getValue());
        }
        iContainerManagementPromise.setSettings(hashMap);
    }

    private void removeResource() {
        IResourcesPromise iResourcesPromise = new ResourcesGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        iResourcesPromise.delete(this.resourceUid).thenAccept(taskRef -> {
            this.templateLanguagesComboBox.setSelectedIndex(0);
            this.selectedTemplateIndex = 0;
            this.resourceUid = null;
            this.templatesByLanguage = new HashMap<String, String>();
            this.templateEditor.setText(null);
        });
    }

    private void storeCurrentTemplate() {
        String string = this.templateEditor.getText();
        if (string != null && !string.trim().equals("")) {
            this.templatesByLanguage.put(SUPPORTED_LANGUAGES.get(this.selectedTemplateIndex), string);
        }
    }

    private String getResourceSettingsContainer(String string) {
        return String.valueOf(string) + "-settings-container";
    }

    private /* synthetic */ void lambda$0(IResourcesPromise iResourcesPromise, List list) {
        if (list != null && !list.isEmpty()) {
            list.forEach(string -> iResourcesPromise.get(string).thenAccept(resourceDescriptor -> {
                boolean bl = false;
                int n = 0;
                while (n < resourceDescriptor.properties.size()) {
                    ResourceDescriptor.PropertyValue propertyValue = (ResourceDescriptor.PropertyValue)resourceDescriptor.properties.get(n);
                    if ("bm-videoconferencing-type".equals(propertyValue.propertyId) && PROVIDER_TYPE.equals(propertyValue.value)) {
                        bl = true;
                    }
                    ++n;
                }
                if (bl) {
                    this.deleteBtn.setVisible(true);
                    this.resourceUid = string;
                    IContainerManagementPromise iContainerManagementPromise = new ContainerManagementGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.getResourceSettingsContainer(this.resourceUid)}).promiseApi();
                    iContainerManagementPromise.getSettings().thenAccept(map -> {
                        Object object;
                        Object string = (String)map.get(SETTINGS_TEMPLATES);
                        if (string != null) {
                            object = JsonUtils.safeEval((String)string);
                            JsMapStringString jsMapStringString = (JsMapStringString)object.cast();
                            this.templatesByLanguage = jsMapStringString.asMap();
                            this.templateEditor.setText(this.templatesByLanguage.get(SUPPORTED_LANGUAGES.get(0)));
                        }
                        if ((object = (String)map.get(WEBEX_ICS_MAIL)) != null) {
                            this.webexIcsUrl.setValue(object);
                        }
                    });
                }
            }));
        }
    }

    static interface WebexEditorUiBinder
    extends UiBinder<HTMLPanel, WebexEditor> {
    }
}

