/*
 * Decompiled with CFR 0.152.
 */
package com.beetstra.jutf7;

import com.beetstra.jutf7.ModifiedUTF7Charset;
import com.beetstra.jutf7.UTF7Charset;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class CharsetProvider
extends java.nio.charset.spi.CharsetProvider {
    private static final String UTF7_NAME = "UTF-7";
    private static final String UTF7_O_NAME = "X-UTF-7-OPTIONAL";
    private static final String UTF7_M_NAME = "X-MODIFIED-UTF-7";
    private static final String[] UTF7_ALIASES = new String[]{"UNICODE-1-1-UTF-7", "CSUNICODE11UTF7", "X-RFC2152", "X-RFC-2152"};
    private static final String[] UTF7_O_ALIASES = new String[]{"X-RFC2152-OPTIONAL", "X-RFC-2152-OPTIONAL"};
    private static final String[] UTF7_M_ALIASES = new String[]{"X-IMAP-MODIFIED-UTF-7", "X-IMAP4-MODIFIED-UTF7", "X-IMAP4-MODIFIED-UTF-7", "X-RFC3501", "X-RFC-3501"};
    private Charset utf7charset = new UTF7Charset("UTF-7", UTF7_ALIASES, false);
    private Charset utf7oCharset = new UTF7Charset("X-UTF-7-OPTIONAL", UTF7_O_ALIASES, true);
    private Charset imap4charset = new ModifiedUTF7Charset("X-MODIFIED-UTF-7", UTF7_M_ALIASES);
    private List charsets = Arrays.asList(this.utf7charset, this.imap4charset, this.utf7oCharset);

    public Charset charsetForName(String string) {
        Charset charset;
        string = string.toUpperCase(Locale.US);
        Iterator iterator = this.charsets.iterator();
        while (iterator.hasNext()) {
            charset = (Charset)iterator.next();
            if (!charset.name().equals(string)) continue;
            return charset;
        }
        iterator = this.charsets.iterator();
        while (iterator.hasNext()) {
            charset = (Charset)iterator.next();
            if (!charset.aliases().contains(string)) continue;
            return charset;
        }
        return null;
    }

    public Iterator charsets() {
        return this.charsets.iterator();
    }

    public static void main(String[] stringArray) throws UnsupportedEncodingException {
        if (stringArray.length < 2) {
            CharsetProvider.showUsage();
        } else if ("encode".equalsIgnoreCase(stringArray[0])) {
            byte[] byArray = stringArray[1].getBytes(UTF7_NAME);
            System.out.println(new String(byArray, "US-ASCII"));
        } else if ("decode".equalsIgnoreCase(stringArray[0])) {
            byte[] byArray = stringArray[1].getBytes("US-ASCII");
            System.out.println(new String(byArray, UTF7_NAME));
        } else {
            CharsetProvider.showUsage();
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java -jar jutf7.jar [encode|decode] <text>");
        System.out.println();
        System.out.println("Example: java -jar jutf7 encode caf\u00e9");
        System.out.println("Result: caf+AOk-");
    }
}

