/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.migration;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.migration.IPubSubOldDAO;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

public class PubSubOldDAOJDBC
implements IPubSubOldDAO {
    private Connection conn;
    private PreparedStatement get_service_jids_st = null;
    private PreparedStatement get_nodes_list_st = null;
    private PreparedStatement get_node_creation_date = null;
    private PreparedStatement get_node_creator = null;
    private PreparedStatement get_node_config = null;
    private PreparedStatement get_node_affiliations = null;
    private PreparedStatement get_node_subscriptions = null;
    private PreparedStatement get_item_ids = null;
    private PreparedStatement get_item = null;
    private final SimpleParser parser = SingletonFactory.getParserInstance();

    public PubSubOldDAOJDBC(String type, String uri) throws RepositoryException {
        String driverClass = null;
        if (type.equals("mysql")) {
            driverClass = "com.mysql.jdbc.Driver";
        } else if (type.equals("pgsql")) {
            driverClass = "org.postgresql.Driver";
        } else if (type.equals("sqlserver")) {
            driverClass = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        try {
            Class.forName(driverClass, true, this.getClass().getClassLoader());
            this.conn = DriverManager.getConnection(uri);
            this.conn.setAutoCommit(true);
        }
        catch (Exception ex) {
            throw new RepositoryException("could not initialize repository", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BareJID[] getServiceJids() throws RepositoryException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.get_service_jids_st;
            synchronized (preparedStatement) {
                try {
                    rs = this.get_service_jids_st.executeQuery();
                    ArrayList<BareJID> result = new ArrayList<BareJID>();
                    while (rs.next()) {
                        result.add(BareJID.bareJIDInstanceNS((String)rs.getString(1)));
                    }
                    BareJID[] bareJIDArray = result.toArray(new BareJID[result.size()]);
                    return bareJIDArray;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("could not retreive service jids", ex);
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getNodesList(BareJID serviceJid) throws RepositoryException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.get_nodes_list_st;
            synchronized (preparedStatement) {
                try {
                    this.get_nodes_list_st.setString(1, serviceJid.toString());
                    rs = this.get_nodes_list_st.executeQuery();
                    ArrayList<String> result = new ArrayList<String>();
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    String[] stringArray = result.toArray(new String[result.size()]);
                    return stringArray;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("could not retreive nodes list", ex);
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public Date getNodeCreationDate(BareJID serviceJid, String nodeName) throws RepositoryException {
        ResultSet rs;
        block14: {
            rs = null;
            PreparedStatement preparedStatement = this.get_node_creation_date;
            // MONITORENTER : preparedStatement
            this.get_node_creation_date.setString(1, serviceJid.toString());
            this.get_node_creation_date.setString(2, nodeName);
            rs = this.get_node_creation_date.executeQuery();
            ArrayList result = new ArrayList();
            if (!rs.next()) break block14;
            Timestamp timestamp = rs.getTimestamp(1);
            // MONITOREXIT : preparedStatement
            if (rs == null) return timestamp;
            try {
                rs.close();
                return timestamp;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            return timestamp;
        }
        Date date = null;
        // MONITOREXIT : preparedStatement
        if (rs == null) return date;
        {
            catch (SQLException ex) {
                throw new RepositoryException("could not retreive node creation date", ex);
            }
        }
        try {
            rs.close();
            return date;
        }
        catch (SQLException ex) {
            Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        return date;
        catch (Throwable throwable) {
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public BareJID getNodeCreator(BareJID serviceJid, String nodeName) throws RepositoryException {
        ResultSet rs;
        block14: {
            rs = null;
            PreparedStatement preparedStatement = this.get_node_creator;
            // MONITORENTER : preparedStatement
            this.get_node_creator.setString(1, serviceJid.toString());
            this.get_node_creator.setString(2, nodeName);
            rs = this.get_node_creator.executeQuery();
            ArrayList result = new ArrayList();
            if (!rs.next()) break block14;
            BareJID bareJID = BareJID.bareJIDInstanceNS((String)rs.getString(1));
            // MONITOREXIT : preparedStatement
            if (rs == null) return bareJID;
            try {
                rs.close();
                return bareJID;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            return bareJID;
        }
        BareJID bareJID = null;
        // MONITOREXIT : preparedStatement
        if (rs == null) return bareJID;
        {
            catch (SQLException ex) {
                throw new RepositoryException("could not retreive node creation date", ex);
            }
        }
        try {
            rs.close();
            return bareJID;
        }
        catch (SQLException ex) {
            Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        return bareJID;
        catch (Throwable throwable) {
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) throws RepositoryException {
        CollectionNodeConfig nc;
        Form cnfForm;
        ResultSet rs;
        block22: {
            block21: {
                rs = null;
                PreparedStatement preparedStatement = this.get_node_config;
                // MONITORENTER : preparedStatement
                this.get_node_config.setString(1, serviceJid.toString());
                this.get_node_config.setString(2, nodeName);
                rs = this.get_node_config.executeQuery();
                ArrayList result = new ArrayList();
                if (rs.next()) break block21;
                AbstractNodeConfig abstractNodeConfig = null;
                // MONITOREXIT : preparedStatement
                if (rs == null) return abstractNodeConfig;
                try {
                    rs.close();
                    return abstractNodeConfig;
                }
                catch (SQLException ex) {
                    Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
                }
                return abstractNodeConfig;
            }
            cnfForm = this.readNodeConfigForm(rs.getString(1));
            if (cnfForm != null) break block22;
            AbstractNodeConfig ex = null;
            // MONITOREXIT : preparedStatement
            if (rs == null) return ex;
            {
                catch (Exception ex2) {
                    throw new RepositoryException("could not retreive node config", ex2);
                }
            }
            try {
                rs.close();
                return ex;
            }
            catch (SQLException ex3) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex3);
            }
            return ex;
        }
        NodeType type = NodeType.valueOf(cnfForm.getAsString("pubsub#node_type"));
        Class cl = null;
        switch (type) {
            case collection: {
                cl = CollectionNodeConfig.class;
                break;
            }
            case leaf: {
                cl = LeafNodeConfig.class;
                break;
            }
            default: {
                throw new RepositoryException("Unknown node type " + (Object)((Object)type));
            }
        }
        CollectionNodeConfig collectionNodeConfig = nc = this.getNodeConfig(cl, nodeName, cnfForm);
        // MONITOREXIT : preparedStatement
        if (rs == null) return collectionNodeConfig;
        try {
            rs.close();
            return collectionNodeConfig;
        }
        catch (SQLException ex) {
            Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        return collectionNodeConfig;
        catch (Throwable throwable) {
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public UsersAffiliation[] getNodeAffiliations(BareJID serviceJid, String nodeName) throws RepositoryException {
        ResultSet rs;
        block14: {
            rs = null;
            PreparedStatement preparedStatement = this.get_node_affiliations;
            // MONITORENTER : preparedStatement
            this.get_node_affiliations.setString(1, serviceJid.toString());
            this.get_node_affiliations.setString(2, nodeName);
            rs = this.get_node_affiliations.executeQuery();
            ArrayList result = new ArrayList();
            if (!rs.next()) break block14;
            String data = rs.getString(1);
            UsersAffiliation[] usersAffiliationArray = NodeAffiliations.create(data).getAffiliations();
            // MONITOREXIT : preparedStatement
            if (rs == null) return usersAffiliationArray;
            try {
                rs.close();
                return usersAffiliationArray;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            return usersAffiliationArray;
        }
        UsersAffiliation[] usersAffiliationArray = null;
        // MONITOREXIT : preparedStatement
        if (rs == null) return usersAffiliationArray;
        {
            catch (SQLException ex) {
                throw new RepositoryException("could not retreive node affiliations", ex);
            }
        }
        try {
            rs.close();
            return usersAffiliationArray;
        }
        catch (SQLException ex) {
            Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        return usersAffiliationArray;
        catch (Throwable throwable) {
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsersSubscription[] getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.get_node_subscriptions;
            synchronized (preparedStatement) {
                try {
                    this.get_node_subscriptions.setString(1, serviceJid.toString());
                    this.get_node_subscriptions.setString(2, nodeName);
                    rs = this.get_node_subscriptions.executeQuery();
                    tigase.pubsub.repository.cached.NodeSubscriptions subscrs = NodeSubscriptions.create();
                    if (rs.next()) {
                        String data = rs.getString(1);
                        subscrs.parse(data);
                    }
                    UsersSubscription[] usersSubscriptionArray = ((NodeSubscriptions)subscrs).getSubscriptions();
                    return usersSubscriptionArray;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("could not retreive node subscriptions", ex);
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getItemsIds(BareJID serviceJid, String nodeName) throws RepositoryException {
        ResultSet rs = null;
        try {
            PreparedStatement preparedStatement = this.get_item_ids;
            synchronized (preparedStatement) {
                try {
                    this.get_item_ids.setString(1, serviceJid.toString());
                    this.get_item_ids.setString(2, nodeName);
                    rs = this.get_item_ids.executeQuery();
                    ArrayList<String> result = new ArrayList<String>();
                    while (rs.next()) {
                        result.add(rs.getString(1));
                    }
                    String[] stringArray = result.toArray(new String[result.size()]);
                    return stringArray;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (SQLException ex) {
                        throw new RepositoryException("could not retreive node items ids", ex);
                    }
                }
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException ex) {
                    Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public IPubSubOldDAO.Item getItem(BareJID serviceJid, String nodeName, String id) throws RepositoryException {
        ResultSet rs;
        block14: {
            rs = null;
            PreparedStatement preparedStatement = this.get_item;
            // MONITORENTER : preparedStatement
            this.get_item.setString(1, serviceJid.toString());
            this.get_item.setString(2, nodeName);
            this.get_item.setString(3, id);
            rs = this.get_item.executeQuery();
            if (!rs.next()) break block14;
            IPubSubOldDAO.Item item = new IPubSubOldDAO.Item();
            item.id = id;
            item.creationDate = rs.getTimestamp(2);
            item.updateDate = rs.getTimestamp(3);
            item.publisher = rs.getString(4);
            char[] data = rs.getString(5).toCharArray();
            DomBuilderHandler domHandler = new DomBuilderHandler();
            this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
            Queue q = domHandler.getParsedElements();
            item.item = q != null && !q.isEmpty() ? (Element)q.poll() : null;
            IPubSubOldDAO.Item item2 = item;
            // MONITOREXIT : preparedStatement
            if (rs == null) return item2;
            try {
                rs.close();
                return item2;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            return item2;
        }
        IPubSubOldDAO.Item item = null;
        // MONITOREXIT : preparedStatement
        if (rs == null) return item;
        {
            catch (SQLException ex) {
                throw new RepositoryException("could not retreive node items ids", ex);
            }
        }
        try {
            rs.close();
            return item;
        }
        catch (SQLException ex) {
            Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
        }
        return item;
        catch (Throwable throwable) {
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException ex) {
                Logger.getLogger(PubSubOldDAOJDBC.class.getName()).log(Level.SEVERE, null, ex);
            }
            throw throwable;
        }
    }

    @Override
    public void init() throws RepositoryException {
        try {
            this.get_service_jids_st = this.conn.prepareStatement("select distinct service_jid from tig_pubsub_nodes_1");
            this.get_nodes_list_st = this.conn.prepareStatement("select name from tig_pubsub_nodes_1 where service_jid = ?");
            this.get_node_creation_date = this.conn.prepareStatement("select creation_date from tig_pubsub_nodes_1 where service_jid = ? and name = ?");
            this.get_node_creator = this.conn.prepareStatement("select creator from tig_pubsub_nodes_1 where service_jid = ? and name = ?");
            this.get_node_config = this.conn.prepareStatement("select configuration from tig_pubsub_nodes_1 where service_jid = ? and name = ?");
            this.get_node_affiliations = this.conn.prepareStatement("select affiliations from tig_pubsub_nodes_1 where service_jid = ? and name = ?");
            this.get_node_subscriptions = this.conn.prepareStatement("select subscriptions from tig_pubsub_subscriptions_1 s inner join tig_pubsub_nodes_1 n on s.service_jid_sha1 = n.service_jid_sha1 and s.node_name_sha1 = n.name_sha1 where service_jid = ? and name = ? order by index");
            this.get_item_ids = this.conn.prepareStatement("select id from tig_pubsub_items_1 i inner join tig_pubsub_nodes_1 n on i.service_jid_sha1 = n.service_jid_sha1 and i.node_name_sha1 = n.name_sha1 where service_jid = ? and name = ?");
            this.get_item = this.conn.prepareStatement("select id, creation_date, update_date, publisher, data from tig_pubsub_items_1 i inner join tig_pubsub_nodes_1 n on i.service_jid_sha1 = n.service_jid_sha1 and i.node_name_sha1 = n.name_sha1 where service_jid = ? and name = ? and id = ?");
        }
        catch (SQLException ex) {
            throw new RepositoryException("could not initialize repository", ex);
        }
    }

    public <T extends AbstractNodeConfig> T getNodeConfig(Class<T> nodeConfigClass, String nodeName, Form configForm) throws RepositoryException {
        try {
            Constructor<T> constructor = nodeConfigClass.getConstructor(String.class);
            AbstractNodeConfig nodeConfig = (AbstractNodeConfig)constructor.newInstance(nodeName);
            nodeConfig.copyFromForm(configForm);
            return (T)nodeConfig;
        }
        catch (Exception e) {
            throw new RepositoryException("Node configuration reading error", e);
        }
    }

    private Form readNodeConfigForm(String cnfData) throws UserNotFoundException, TigaseDBException {
        if (cnfData == null) {
            return null;
        }
        char[] data = cnfData.toCharArray();
        DomBuilderHandler domHandler = new DomBuilderHandler();
        this.parser.parse((SimpleHandler)domHandler, data, 0, data.length);
        Queue q = domHandler.getParsedElements();
        if (q != null && q.size() > 0) {
            Form form = new Form((Element)q.element());
            return form;
        }
        return null;
    }
}

