/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository.cached;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.repository.INodeMeta;
import tigase.pubsub.repository.cached.NodeAffiliations;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.xmpp.BareJID;

public class Node<T>
implements INodeMeta<T> {
    private static final Logger log = Logger.getLogger(Node.class.getName());
    private boolean conNeedsWriting = false;
    private final Date creationTime;
    private final BareJID creator;
    private boolean deleted = false;
    private String name;
    private T nodeId;
    private NodeAffiliations nodeAffiliations;
    private AbstractNodeConfig nodeConfig;
    private NodeSubscriptions nodeSubscriptions;
    private BareJID serviceJid;

    public Node(T nodeId, BareJID serviceJid, AbstractNodeConfig nodeConfig, NodeAffiliations nodeAffiliations, NodeSubscriptions nodeSubscriptions, BareJID creator, Date creationTime) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Constructing Node, serviceJid: {0}, nodeConfig: {1}, nodeId: {2}, nodeAffiliations: {3}, nodeSubscriptions: {4}", new Object[]{serviceJid, nodeConfig, nodeId, nodeAffiliations, nodeSubscriptions});
        }
        this.nodeId = nodeId;
        this.serviceJid = serviceJid;
        this.nodeConfig = nodeConfig;
        this.nodeAffiliations = nodeAffiliations;
        this.nodeSubscriptions = nodeSubscriptions;
        this.name = nodeConfig.getNodeName();
        this.creator = creator;
        this.creationTime = creationTime;
    }

    @Override
    public T getNodeId() {
        return this.nodeId;
    }

    public void affiliationsMerge() {
        this.nodeAffiliations.merge();
    }

    public boolean affiliationsNeedsWriting() {
        return this.nodeAffiliations.isChanged();
    }

    public void affiliationsSaved() {
        this.affiliationsMerge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configCopyFrom(AbstractNodeConfig nodeConfig) {
        Node node = this;
        synchronized (node) {
            this.nodeConfig.copyFrom(nodeConfig);
            this.conNeedsWriting = true;
        }
    }

    public boolean configNeedsWriting() {
        return this.conNeedsWriting;
    }

    public void configSaved() {
        this.conNeedsWriting = false;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public BareJID getCreator() {
        return this.creator;
    }

    public String getName() {
        return this.name;
    }

    public NodeAffiliations getNodeAffiliations() {
        return this.nodeAffiliations;
    }

    @Override
    public AbstractNodeConfig getNodeConfig() {
        return this.nodeConfig;
    }

    public NodeSubscriptions getNodeSubscriptions() {
        return this.nodeSubscriptions;
    }

    public BareJID getServiceJid() {
        return this.serviceJid;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean needsWriting() {
        return this.affiliationsNeedsWriting() || this.subscriptionsNeedsWriting() || this.conNeedsWriting;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void subscriptionsMerge() {
        this.nodeSubscriptions.merge();
    }

    public boolean subscriptionsNeedsWriting() {
        return this.nodeSubscriptions.isChanged();
    }

    public void subscriptionsSaved() {
        this.subscriptionsMerge();
    }

    public void resetChanges() {
        this.nodeAffiliations.resetChangedFlag();
        this.nodeSubscriptions.resetChangedFlag();
    }

    public String toString() {
        return "Node{creationTime=" + this.creationTime + ", deleted=" + this.deleted + ", name=" + this.name + ", nodeId=" + this.nodeId + ", nodeAffiliations=" + this.nodeAffiliations + ", nodeSubscriptions=" + this.nodeSubscriptions + ", serviceJid=" + this.serviceJid + ", creator=" + this.creator + '}';
    }
}

