/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.repository;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.xmpp.BareJID;

public abstract class NodeSubscriptions
implements ISubscriptions {
    protected static final String DELIMITER = ";";
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private boolean changed = false;
    protected final ConcurrentMap<BareJID, UsersSubscription> subs = new ConcurrentHashMap<BareJID, UsersSubscription>();

    public static tigase.pubsub.repository.cached.NodeSubscriptions create() {
        tigase.pubsub.repository.cached.NodeSubscriptions s = new tigase.pubsub.repository.cached.NodeSubscriptions();
        return s;
    }

    protected NodeSubscriptions() {
    }

    @Override
    public String addSubscriberJid(BareJID bareJid, Subscription subscription) {
        String subid = Utils.createUID(bareJid);
        UsersSubscription s = new UsersSubscription(bareJid, subid, subscription);
        this.subs.put(bareJid, s);
        this.changed = true;
        return subid;
    }

    @Override
    public void changeSubscription(BareJID bareJid, Subscription subscription) {
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            s.setSubscription(subscription);
            this.changed = true;
        }
    }

    public String toString() {
        return "NodeSubscriptions: " + this.subs;
    }

    protected UsersSubscription get(BareJID bareJid) {
        return (UsersSubscription)this.subs.get(bareJid);
    }

    @Override
    public Subscription getSubscription(BareJID bareJid) {
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            return s.getSubscription();
        }
        return Subscription.none;
    }

    @Override
    public String getSubscriptionId(BareJID bareJid) {
        UsersSubscription s = this.get(bareJid);
        if (s != null) {
            return s.getSubid();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UsersSubscription[] getSubscriptions() {
        ConcurrentMap<BareJID, UsersSubscription> concurrentMap = this.subs;
        synchronized (concurrentMap) {
            Object[] toArray = this.subs.values().toArray(new UsersSubscription[0]);
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "getSubscriptions: {0}, toArray:{1}", new Object[]{this.subs, Arrays.toString(toArray)});
            }
            return toArray;
        }
    }

    @Override
    public UsersSubscription[] getSubscriptionsForPublish() {
        Object[] subscriptions = this.getSubscriptions();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "getSubscriptionsForPublish, subs: {0}, subscriptions: {1}", new Object[]{this.subs, Arrays.toString(subscriptions)});
        }
        return subscriptions;
    }

    public Map<BareJID, UsersSubscription> getSubscriptionsMap() {
        return this.subs;
    }

    public void init(Queue<UsersSubscription> data) {
        UsersSubscription s = null;
        while ((s = data.poll()) != null) {
            this.subs.put(s.getJid(), s);
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    public void parse(String data) {
        HashMap parsed = new HashMap();
        String[] tokens = data.split(DELIMITER);
        int c = 0;
        BareJID jid = null;
        String subid = null;
        String state = null;
        for (String t : tokens) {
            if (c == 2) {
                state = t;
                ++c;
            } else if (c == 1) {
                subid = t;
                ++c;
            } else if (c == 0) {
                jid = BareJID.bareJIDInstanceNS((String)t);
                ++c;
            }
            if (c != 3) continue;
            UsersSubscription b = new UsersSubscription(jid, subid, Subscription.valueOf(state));
            this.subs.put(jid, b);
            jid = null;
            subid = null;
            state = null;
            c = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceBy(ISubscriptions nodeSubscriptions) {
        ConcurrentMap<BareJID, UsersSubscription> concurrentMap = this.subs;
        synchronized (concurrentMap) {
            if (nodeSubscriptions instanceof NodeSubscriptions) {
                NodeSubscriptions ns = (NodeSubscriptions)nodeSubscriptions;
                this.changed = true;
                this.subs.clear();
                for (UsersSubscription a : ns.subs.values()) {
                    this.subs.put(a.getJid(), a);
                }
            } else {
                throw new RuntimeException("!!!!!!!!!!!!!!!!!!!" + nodeSubscriptions.getClass());
            }
        }
    }

    public void resetChangedFlag() {
        this.changed = false;
    }

    @Override
    public String serialize(Map<BareJID, UsersSubscription> fragment) {
        StringBuilder sb = new StringBuilder();
        for (UsersSubscription s : fragment.values()) {
            if (s.getSubscription() == Subscription.none) continue;
            sb.append(s.getJid());
            sb.append(DELIMITER);
            sb.append(s.getSubid());
            sb.append(DELIMITER);
            sb.append(s.getSubscription().name());
            sb.append(DELIMITER);
        }
        return sb.toString();
    }
}

