/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.Affiliation;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class UnsubscribeNodeModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_UNSUBSCRIBE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"unsubscribe"));

    public UnsubscribeNodeModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    @Override
    public String[] getFeatures() {
        return null;
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_UNSUBSCRIBE;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element unsubscribe = pubSub.getChild("unsubscribe");
        JID senderJid = packet.getStanzaFrom();
        String nodeName = unsubscribe.getAttributeStaticStr("node");
        BareJID jid = BareJID.bareJIDInstanceNS((String)unsubscribe.getAttributeStaticStr("jid"));
        String subid = unsubscribe.getAttributeStaticStr("subid");
        try {
            String s;
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID());
            UsersAffiliation affiliation = nodeAffiliations.getSubscriberAffiliation(jid);
            if (!this.config.isAdmin(senderJid) && senderAffiliation.getAffiliation() != Affiliation.owner && !jid.equals((Object)senderJid.getBareJID())) {
                throw new PubSubException(element, Authorization.BAD_REQUEST, PubSubErrorCondition.INVALID_JID);
            }
            if (affiliation != null && affiliation.getAffiliation() == Affiliation.outcast) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            if (subid != null && !subid.equals(s = nodeSubscriptions.getSubscriptionId(jid))) {
                throw new PubSubException(element, Authorization.NOT_ACCEPTABLE, PubSubErrorCondition.INVALID_SUBID);
            }
            Subscription subscription = nodeSubscriptions.getSubscription(jid);
            if (subscription == null) {
                throw new PubSubException(Authorization.UNEXPECTED_REQUEST, PubSubErrorCondition.NOT_SUBSCRIBED);
            }
            nodeSubscriptions.changeSubscription(jid, Subscription.none);
            if (nodeSubscriptions.isChanged()) {
                this.getRepository().update(toJid, nodeName, nodeSubscriptions);
            }
            this.packetWriter.write(packet.okResult((Element)null, 0));
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

