/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.AccessModel;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.Subscription;
import tigase.pubsub.Utils;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.RepositoryException;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.util.DateTimeFormatter;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class RetrieveItemsModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.nameType((String)"iq", (String)"get").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"items"));
    private final DateTimeFormatter dtf = new DateTimeFormatter();

    public RetrieveItemsModule(PubSubConfig config, PacketWriter packetWriter) {
        super(config, packetWriter);
    }

    private Integer asInteger(String attribute) {
        if (attribute == null) {
            return null;
        }
        return Integer.parseInt(attribute);
    }

    private void checkPermission(JID senderJid, BareJID toJid, String nodeName, AbstractNodeConfig nodeConfig) throws PubSubException, RepositoryException {
        boolean allowed;
        if (nodeConfig == null) {
            throw new PubSubException(Authorization.ITEM_NOT_FOUND);
        }
        if (nodeConfig.getNodeAccessModel() == AccessModel.open && !Utils.isAllowedDomain(senderJid.getBareJID(), nodeConfig.getDomains())) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
        UsersAffiliation senderAffiliation = nodeAffiliations.getSubscriberAffiliation(senderJid.getBareJID());
        if (senderAffiliation.getAffiliation() == Affiliation.outcast) {
            throw new PubSubException(Authorization.FORBIDDEN);
        }
        ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
        Subscription senderSubscription = nodeSubscriptions.getSubscription(senderJid.getBareJID());
        if (nodeConfig.getNodeAccessModel() == AccessModel.whitelist && !senderAffiliation.getAffiliation().isRetrieveItem()) {
            throw new PubSubException(Authorization.NOT_ALLOWED, PubSubErrorCondition.CLOSED_NODE);
        }
        if (!(nodeConfig.getNodeAccessModel() != AccessModel.authorize || senderSubscription == Subscription.subscribed && senderAffiliation.getAffiliation().isRetrieveItem())) {
            throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_SUBSCRIBED);
        }
        if (nodeConfig.getNodeAccessModel() == AccessModel.presence) {
            boolean allowed2 = this.hasSenderSubscription(senderJid.getBareJID(), nodeAffiliations, nodeSubscriptions);
            if (!allowed2) {
                throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.PRESENCE_SUBSCRIPTION_REQUIRED);
            }
        } else if (nodeConfig.getNodeAccessModel() == AccessModel.roster && !(allowed = this.isSenderInRosterGroup(senderJid.getBareJID(), nodeConfig, nodeAffiliations, nodeSubscriptions))) {
            throw new PubSubException(Authorization.NOT_AUTHORIZED, PubSubErrorCondition.NOT_IN_ROSTER_GROUP);
        }
    }

    private List<String> extractItemsIds(Element items) throws PubSubException {
        List il = items.getChildren();
        if (il == null || il.size() == 0) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Element i : il) {
            String id = i.getAttributeStaticStr("id");
            if (!"item".equals(i.getName()) || id == null) {
                throw new PubSubException(Authorization.BAD_REQUEST);
            }
            result.add(id);
        }
        return result;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retrieve-items"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element pubsub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
            Element items = pubsub.getChild("items");
            String nodeName = items.getAttributeStaticStr("node");
            JID senderJid = packet.getStanzaFrom();
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            this.checkPermission(senderJid, toJid, nodeName, nodeConfig);
            if (nodeConfig instanceof CollectionNodeConfig) {
                CollectionItemsOrdering collectionItemsOrdering;
                ArrayList<IItems.ItemMeta> itemsMeta = new ArrayList<IItems.ItemMeta>();
                String[] childNodes = nodeConfig.getChildren();
                HashMap<String, IItems> nodeItemsCache = new HashMap<String, IItems>();
                if (childNodes != null) {
                    for (String childNodeName : childNodes) {
                        LeafNodeConfig leafChildNode;
                        AbstractNodeConfig childNode = this.getRepository().getNodeConfig(toJid, childNodeName);
                        if (childNode == null || childNode.getNodeType() != NodeType.leaf || !(leafChildNode = (LeafNodeConfig)childNode).isPersistItem()) continue;
                        try {
                            this.checkPermission(senderJid, toJid, childNodeName, childNode);
                            IItems childNodeItems = this.getRepository().getNodeItems(toJid, childNodeName);
                            nodeItemsCache.put(childNodeName, childNodeItems);
                            itemsMeta.addAll(childNodeItems.getItemsMeta());
                        }
                        catch (PubSubException childNodeItems) {
                            // empty catch block
                        }
                    }
                }
                if ((collectionItemsOrdering = nodeConfig.getCollectionItemsOrdering()) != null) {
                    Collections.sort(itemsMeta, collectionItemsOrdering.getComparator());
                } else {
                    Collections.sort(itemsMeta, CollectionItemsOrdering.byUpdateDate.getComparator());
                }
                Element rpubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
                Packet iq = packet.okResult(rpubsub, 0);
                Integer maxItems = this.asInteger(items.getAttributeStaticStr("max_items"));
                Integer offset = 0;
                Element rsmGet = pubsub.getChild("set", "http://jabber.org/protocol/rsm");
                if (rsmGet != null) {
                    Element m = rsmGet.getChild("max");
                    if (m != null) {
                        maxItems = this.asInteger(m.getCData());
                    }
                    if ((m = rsmGet.getChild("index")) != null) {
                        offset = this.asInteger(m.getCData());
                    }
                }
                HashMap nodeItemsElMap = new HashMap();
                int idx = offset;
                String lastId = null;
                for (int count = 0; itemsMeta.size() > idx && (maxItems == null || count < maxItems); ++idx, ++count) {
                    IItems.ItemMeta itemMeta = (IItems.ItemMeta)itemsMeta.get(idx);
                    String string = itemMeta.getNode();
                    ArrayList<Element> nodeItemsElems = (ArrayList<Element>)nodeItemsElMap.get(string);
                    if (nodeItemsElems == null) {
                        nodeItemsElems = new ArrayList<Element>();
                        nodeItemsElMap.put(string, nodeItemsElems);
                    }
                    IItems nodeItems = (IItems)nodeItemsCache.get(string);
                    Element item = nodeItems.getItem(itemMeta.getId());
                    lastId = itemMeta.getId();
                    nodeItemsElems.add(item);
                }
                nodeItemsCache.clear();
                for (Map.Entry entry : nodeItemsElMap.entrySet()) {
                    Element itemsEl = new Element("items", new String[]{"node"}, new String[]{(String)entry.getKey()});
                    List itemsElems = (List)entry.getValue();
                    Collections.reverse(itemsElems);
                    itemsEl.addChildren(itemsElems);
                    rpubsub.addChild((XMLNodeIfc)itemsEl);
                }
                if (nodeItemsElMap.size() > 0) {
                    Element rsmResponse = new Element("set", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/rsm"});
                    rsmResponse.addChild((XMLNodeIfc)new Element("first", ((IItems.ItemMeta)itemsMeta.get(offset)).getId(), new String[]{"index"}, new String[]{String.valueOf(offset)}));
                    rsmResponse.addChild((XMLNodeIfc)new Element("count", "" + itemsMeta.size()));
                    if (lastId != null) {
                        rsmResponse.addChild((XMLNodeIfc)new Element("last", lastId));
                    }
                    rpubsub.addChild((XMLNodeIfc)rsmResponse);
                } else {
                    rpubsub.addChild((XMLNodeIfc)new Element("items", new String[]{"node"}, new String[]{nodeName}));
                }
                this.packetWriter.write(iq);
                return;
            }
            if (nodeConfig instanceof LeafNodeConfig && !((LeafNodeConfig)nodeConfig).isPersistItem()) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "persistent-items"));
            }
            List<String> requestedId = this.extractItemsIds(items);
            boolean requestedExactItems = requestedId != null;
            Element rpubsub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub"});
            Element ritems = new Element("items", new String[]{"node"}, new String[]{nodeName});
            Packet iq = packet.okResult(rpubsub, 0);
            iq.setXMLNS("jabber:client");
            rpubsub.addChild((XMLNodeIfc)ritems);
            Integer maxItems = this.asInteger(items.getAttributeStaticStr("max_items"));
            Integer offset = 0;
            Calendar dtAfter = null;
            String afterId = null;
            String beforeId = null;
            Element rsmGet = pubsub.getChild("set", "http://jabber.org/protocol/rsm");
            if (rsmGet != null) {
                Element m = rsmGet.getChild("max");
                if (m != null) {
                    maxItems = this.asInteger(m.getCData());
                }
                if ((m = rsmGet.getChild("index")) != null) {
                    offset = this.asInteger(m.getCData());
                }
                if ((m = rsmGet.getChild("before")) != null) {
                    beforeId = m.getCData();
                }
                if ((m = rsmGet.getChild("adter")) != null) {
                    afterId = m.getCData();
                }
                if ((m = rsmGet.getChild("dt_after", "http://tigase.org/pubsub")) != null) {
                    dtAfter = this.dtf.parseDateTime(m.getCData());
                }
            }
            IItems nodeItems = this.getRepository().getNodeItems(toJid, nodeName);
            ArrayList<IItems.ItemMeta> itemsMeta = new ArrayList<IItems.ItemMeta>();
            itemsMeta.addAll(nodeItems.getItemsMeta());
            CollectionItemsOrdering collectionItemsOrdering = nodeConfig.getCollectionItemsOrdering();
            if (collectionItemsOrdering != null) {
                Collections.sort(itemsMeta, collectionItemsOrdering.getComparator());
            } else {
                Collections.sort(itemsMeta, CollectionItemsOrdering.byUpdateDate.getComparator());
            }
            if (requestedId == null) {
                requestedId = new ArrayList<String>(itemsMeta.size());
                for (IItems.ItemMeta item : itemsMeta) {
                    requestedId.add(item.getId());
                }
            }
            Element element = new Element("set", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/rsm"});
            if (requestedId != null) {
                if (maxItems == null) {
                    maxItems = requestedId.size();
                }
                ArrayList<Element> ritemsList = new ArrayList<Element>();
                element.addChild((XMLNodeIfc)new Element("count", "" + requestedId.size()));
                String lastId = null;
                int c = 0;
                boolean allow = false;
                for (int i = 0; i < requestedId.size(); ++i) {
                    if (i + offset >= requestedId.size()) continue;
                    if (c >= maxItems) break;
                    String id = requestedId.get(i + offset);
                    Date cd = null;
                    if (collectionItemsOrdering == CollectionItemsOrdering.byCreationDate) {
                        cd = nodeItems.getItemCreationDate(id);
                    } else if (collectionItemsOrdering == CollectionItemsOrdering.byUpdateDate) {
                        cd = nodeItems.getItemUpdateDate(id);
                    }
                    if (dtAfter != null && cd != null && !cd.after(dtAfter.getTime())) continue;
                    if (afterId != null && !allow && afterId.equals(id)) {
                        allow = true;
                        continue;
                    }
                    if (afterId != null && !allow) continue;
                    if (beforeId != null && beforeId.equals(id)) break;
                    Element item = nodeItems.getItem(id);
                    if (item == null) continue;
                    if (c == 0) {
                        element.addChild((XMLNodeIfc)new Element("first", id, new String[]{"index"}, new String[]{"" + (i + offset)}));
                    }
                    lastId = id;
                    ritemsList.add(item);
                    ++c;
                }
                if (lastId != null) {
                    element.addChild((XMLNodeIfc)new Element("last", lastId));
                }
                Collections.reverse(ritemsList);
                ritems.addChildren(ritemsList);
                if (!(ritemsList.isEmpty() && requestedExactItems || maxItems.intValue() == requestedId.size())) {
                    rpubsub.addChild((XMLNodeIfc)element);
                }
            }
            this.packetWriter.write(iq);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

