/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import tigase.component2.PacketWriter;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;

public class RetractItemModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_RETRACT = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub")).add((Criteria)ElementCriteria.name((String)"retract"));
    private final PublishItemModule publishModule;

    public RetractItemModule(PubSubConfig config, PacketWriter packetWriter, PublishItemModule publishItemModule) {
        super(config, packetWriter);
        this.publishModule = publishItemModule;
    }

    private Element createNotification(LeafNodeConfig config, List<String> itemsToSend, String nodeName) {
        Element items = new Element("items", new String[]{"node"}, new String[]{nodeName});
        for (String id : itemsToSend) {
            items.addChild((XMLNodeIfc)new Element("retract", new String[]{"id"}, new String[]{id}));
        }
        return items;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#retract-items"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_RETRACT;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element pubSub = packet.getElement().getChild("pubsub", "http://jabber.org/protocol/pubsub");
        Element retract = pubSub.getChild("retract");
        String nodeName = retract.getAttributeStaticStr("node");
        try {
            if (nodeName == null) {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.NODE_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(packet.getElement(), Authorization.ITEM_NOT_FOUND);
            }
            if (nodeConfig.getNodeType() == NodeType.collection) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "retract-items"));
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            UsersAffiliation affiliation = nodeAffiliations.getSubscriberAffiliation(packet.getStanzaFrom().getBareJID());
            if (!affiliation.getAffiliation().isDeleteItem()) {
                throw new PubSubException(Authorization.FORBIDDEN);
            }
            LeafNodeConfig leafNodeConfig = (LeafNodeConfig)nodeConfig;
            if (!leafNodeConfig.isPersistItem()) {
                throw new PubSubException(Authorization.FEATURE_NOT_IMPLEMENTED, new PubSubErrorCondition("unsupported", "persistent-items"));
            }
            ArrayList<String> itemsToDelete = new ArrayList<String>();
            if (retract.getChildren() != null) {
                for (Element item : retract.getChildren()) {
                    String n = item.getAttributeStaticStr("id");
                    if (n != null) {
                        itemsToDelete.add(n);
                        continue;
                    }
                    throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.ITEM_REQUIRED);
                }
            } else {
                throw new PubSubException(Authorization.BAD_REQUEST, PubSubErrorCondition.ITEM_REQUIRED);
            }
            Packet result = packet.okResult((Element)null, 0);
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            IItems nodeItems = this.getRepository().getNodeItems(toJid, nodeName);
            for (String id : itemsToDelete) {
                Date date = nodeItems.getItemCreationDate(id);
                if (date == null) continue;
                Element notification = this.createNotification(leafNodeConfig, itemsToDelete, nodeName);
                this.publishModule.sendNotifications(notification, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions);
                nodeItems.deleteItem(id);
            }
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

