/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import tigase.component2.PacketWriter;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventType;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class NodeDeleteModule
extends AbstractPubSubModule {
    private static final Criteria CRIT_DELETE = ElementCriteria.nameType((String)"iq", (String)"set").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"delete"));
    private final PublishItemModule publishModule;

    public NodeDeleteModule(PubSubConfig config, PacketWriter packetWriter, PublishItemModule publishItemModule) {
        super(config, packetWriter);
        this.publishModule = publishItemModule;
    }

    public void addNodeDeleteHandler(NodeDeleteHandler handler) {
        this.config.getEventBus().addHandler(NodeDeleteHandler.NodeDeleteEvent.TYPE, handler);
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#delete-nodes"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_DELETE;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        BareJID toJid = packet.getStanzaTo().getBareJID();
        Element element = packet.getElement();
        Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
        Element delete = pubSub.getChild("delete");
        String nodeName = delete.getAttributeStaticStr("node");
        try {
            CollectionNodeConfig cnc;
            String[] childrenNodes;
            UsersAffiliation senderAffiliation;
            if (nodeName == null) {
                throw new PubSubException(element, Authorization.NOT_ALLOWED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            JID jid = packet.getStanzaFrom();
            if (!this.config.isAdmin(jid) && !(senderAffiliation = nodeAffiliations.getSubscriberAffiliation(jid.getBareJID())).getAffiliation().isDeleteNode()) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            Packet result = packet.okResult((Element)null, 0);
            if (nodeConfig.isNotify_config()) {
                ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
                Element del = new Element("delete", new String[]{"node"}, new String[]{nodeName});
                this.publishModule.sendNotifications(del, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions);
            }
            String parentNodeName = nodeConfig.getCollection();
            CollectionNodeConfig parentCollectionConfig = null;
            if (parentNodeName != null && !parentNodeName.equals("")) {
                parentCollectionConfig = (CollectionNodeConfig)this.getRepository().getNodeConfig(toJid, parentNodeName);
                if (parentCollectionConfig != null) {
                    parentCollectionConfig.removeChildren(nodeName);
                }
            } else {
                this.getRepository().removeFromRootCollection(toJid, nodeName);
            }
            if (nodeConfig instanceof CollectionNodeConfig && (childrenNodes = (cnc = (CollectionNodeConfig)nodeConfig).getChildren()) != null && childrenNodes.length > 0) {
                for (String childNodeName : childrenNodes) {
                    AbstractNodeConfig childNodeConfig = this.getRepository().getNodeConfig(toJid, childNodeName);
                    if (childNodeConfig != null) {
                        childNodeConfig.setCollection(parentNodeName);
                        this.getRepository().update(toJid, childNodeName, childNodeConfig);
                    }
                    if (parentCollectionConfig != null) {
                        parentCollectionConfig.addChildren(childNodeName);
                        continue;
                    }
                    this.getRepository().addToRootCollection(toJid, childNodeName);
                }
            }
            if (parentCollectionConfig != null) {
                this.getRepository().update(toJid, parentNodeName, parentCollectionConfig);
            }
            this.log.fine("Delete node [" + nodeName + "]");
            this.getRepository().deleteNode(toJid, nodeName);
            NodeDeleteHandler.NodeDeleteEvent event = new NodeDeleteHandler.NodeDeleteEvent(packet, nodeName);
            this.getEventBus().fire(event);
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void removeNodeDeleteHandler(NodeDeleteHandler handler) {
        this.config.getEventBus().remove(handler);
    }

    public static interface NodeDeleteHandler
    extends EventHandler {
        public void onNodeDeleted(Packet var1, String var2);

        public static class NodeDeleteEvent
        extends Event<NodeDeleteHandler> {
            public static final EventType<NodeDeleteHandler> TYPE = new EventType();
            private final String nodeName;
            private final Packet packet;

            public NodeDeleteEvent(Packet packet, String nodeName) {
                super(TYPE);
                this.packet = packet;
                this.nodeName = nodeName;
            }

            @Override
            protected void dispatch(NodeDeleteHandler handler) {
                handler.onNodeDeleted(this.packet, this.nodeName);
            }
        }
    }
}

