/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.Arrays;
import java.util.HashSet;
import tigase.component2.PacketWriter;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventType;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.SendLastPublishedItem;
import tigase.pubsub.exceptions.PubSubErrorCondition;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.AbstractConfigCreateNode;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;

public class NodeConfigModule
extends AbstractConfigCreateNode {
    private static final Criteria CRIT_CONFIG = ElementCriteria.name((String)"iq").add((Criteria)ElementCriteria.name((String)"pubsub", (String)"http://jabber.org/protocol/pubsub#owner")).add((Criteria)ElementCriteria.name((String)"configure"));
    private final PublishItemModule publishModule;

    protected static String[] diff(String[] a, String[] b) {
        HashSet<String> r = new HashSet<String>();
        for (String $a : a) {
            r.add($a);
        }
        for (String $a : b) {
            r.add($a);
        }
        for (String $a : b) {
            r.remove($a);
        }
        return r.toArray(new String[0]);
    }

    public static void parseConf(AbstractNodeConfig conf, Element configure, PubSubConfig config) throws PubSubException {
        Element x = configure.getChild("x", "jabber:x:data");
        Form foo = new Form(x);
        if (x != null && "submit".equals(x.getAttributeStaticStr("type"))) {
            for (Field field : conf.getForm().getAllFields()) {
                String var = field.getVar();
                Field cf = foo.get(var);
                if (cf == null) continue;
                if (!config.isSendLastPublishedItemOnPresence() && "pubsub#send_last_published_item".equals(var) && SendLastPublishedItem.on_sub_and_presence.name().equals(cf.getValue())) {
                    throw new PubSubException(Authorization.NOT_ACCEPTABLE, "Requested on_sub_and_presence mode for sending last published item is disabled.");
                }
                field.setValues(cf.getValues());
            }
        }
    }

    public NodeConfigModule(PubSubConfig config, PacketWriter packetWriter, LeafNodeConfig defaultNodeConfig, PublishItemModule publishItemModule) {
        super(config, defaultNodeConfig, packetWriter);
        this.publishModule = publishItemModule;
    }

    public void addNodeConfigurationChangedHandler(NodeConfigurationChangedHandler handler) {
        this.getEventBus().addHandler(NodeConfigurationChangedHandler.NodeConfigurationChangedEvent.TYPE, handler);
    }

    private Element createAssociateNotification(String collectionNodeName, String associatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild((XMLNodeIfc)new Element("associate", new String[]{"node"}, new String[]{associatedNodeName}));
        return colE;
    }

    private Element createDisassociateNotification(String collectionNodeName, String disassociatedNodeName) {
        Element colE = new Element("collection", new String[]{"node"}, new String[]{collectionNodeName});
        colE.addChild((XMLNodeIfc)new Element("disassociate", new String[]{"node"}, new String[]{disassociatedNodeName}));
        return colE;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#config-node"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT_CONFIG;
    }

    protected boolean isIn(String node, String[] children) {
        if (node == null | children == null) {
            return false;
        }
        for (String x : children) {
            if (!x.equals(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        try {
            UsersAffiliation senderAffiliation;
            BareJID toJid = packet.getStanzaTo().getBareJID();
            Element element = packet.getElement();
            Element pubSub = element.getChild("pubsub", "http://jabber.org/protocol/pubsub#owner");
            Element configure = pubSub.getChild("configure");
            String nodeName = configure.getAttributeStaticStr("node");
            StanzaType type = packet.getType();
            String id = element.getAttributeStaticStr("id");
            if (nodeName == null) {
                throw new PubSubException(element, Authorization.BAD_REQUEST, PubSubErrorCondition.NODEID_REQUIRED);
            }
            AbstractNodeConfig nodeConfig = this.getRepository().getNodeConfig(toJid, nodeName);
            if (nodeConfig == null) {
                throw new PubSubException(element, Authorization.ITEM_NOT_FOUND);
            }
            IAffiliations nodeAffiliations = this.getRepository().getNodeAffiliations(toJid, nodeName);
            JID jid = packet.getStanzaFrom();
            if (!this.config.isAdmin(jid) && (senderAffiliation = nodeAffiliations.getSubscriberAffiliation(jid.getBareJID())).getAffiliation() != Affiliation.owner) {
                throw new PubSubException(element, Authorization.FORBIDDEN);
            }
            Packet result = packet.okResult((Element)null, 0);
            ISubscriptions nodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, nodeName);
            if (type == StanzaType.get) {
                Element rPubSub = new Element("pubsub", new String[]{"xmlns"}, new String[]{"http://jabber.org/protocol/pubsub#owner"});
                Element rConfigure = new Element("configure", new String[]{"node"}, new String[]{nodeName});
                Element f = nodeConfig.getFormElement();
                rConfigure.addChild((XMLNodeIfc)f);
                rPubSub.addChild((XMLNodeIfc)rConfigure);
                result.getElement().addChild((XMLNodeIfc)rPubSub);
            } else if (type == StanzaType.set) {
                String[] children = nodeConfig.getChildren() == null ? new String[]{} : Arrays.copyOf(nodeConfig.getChildren(), nodeConfig.getChildren().length);
                String collectionOld = nodeConfig.getCollection() == null ? "" : nodeConfig.getCollection();
                NodeConfigModule.parseConf(nodeConfig, configure, this.config);
                if (!collectionOld.equals(nodeConfig.getCollection())) {
                    ISubscriptions colNodeSubscriptions;
                    IAffiliations colNodeAffiliations;
                    AbstractNodeConfig colNodeConfig;
                    if (collectionOld.equals("")) {
                        colNodeConfig = this.getRepository().getNodeConfig(toJid, nodeConfig.getCollection());
                        if (colNodeConfig == null) {
                            throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#1) Node '" + nodeConfig.getCollection() + "' doesn't exists");
                        }
                        if (!(colNodeConfig instanceof CollectionNodeConfig)) {
                            throw new PubSubException(Authorization.NOT_ALLOWED, "(#1) Node '" + nodeConfig.getCollection() + "' is not collection node");
                        }
                        ((CollectionNodeConfig)colNodeConfig).addChildren(nodeName);
                        this.getRepository().update(toJid, colNodeConfig.getNodeName(), colNodeConfig);
                        this.getRepository().removeFromRootCollection(toJid, nodeName);
                        colNodeAffiliations = this.getRepository().getNodeAffiliations(toJid, colNodeConfig.getNodeName());
                        colNodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, colNodeConfig.getNodeName());
                        Element associateNotification = this.createAssociateNotification(colNodeConfig.getNodeName(), nodeName);
                        this.publishModule.sendNotifications(associateNotification, packet.getStanzaTo(), nodeName, nodeConfig, colNodeAffiliations, colNodeSubscriptions);
                    }
                    if (nodeConfig.getCollection().equals("")) {
                        colNodeConfig = this.getRepository().getNodeConfig(toJid, collectionOld);
                        if (colNodeConfig != null && colNodeConfig instanceof CollectionNodeConfig) {
                            ((CollectionNodeConfig)colNodeConfig).removeChildren(nodeName);
                            this.getRepository().update(toJid, colNodeConfig.getNodeName(), colNodeConfig);
                        }
                        this.getRepository().addToRootCollection(toJid, nodeName);
                        colNodeAffiliations = this.getRepository().getNodeAffiliations(toJid, colNodeConfig.getNodeName());
                        colNodeSubscriptions = this.getRepository().getNodeSubscriptions(toJid, colNodeConfig.getNodeName());
                        Element disassociateNotification = this.createDisassociateNotification(collectionOld, nodeName);
                        this.publishModule.sendNotifications(disassociateNotification, packet.getStanzaTo(), nodeName, nodeConfig, colNodeAffiliations, colNodeSubscriptions);
                    }
                }
                if (nodeConfig instanceof CollectionNodeConfig) {
                    AbstractNodeConfig nc;
                    String[] addedChildNodes;
                    String[] removedChildNodes = NodeConfigModule.diff(children == null ? new String[]{} : children, nodeConfig.getChildren() == null ? new String[]{} : nodeConfig.getChildren());
                    for (String ann : addedChildNodes = NodeConfigModule.diff(nodeConfig.getChildren() == null ? new String[]{} : nodeConfig.getChildren(), children == null ? new String[]{} : children)) {
                        nc = this.getRepository().getNodeConfig(toJid, ann);
                        if (nc == null) {
                            throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#2) Node '" + ann + "' doesn't exists");
                        }
                        if (nc.getCollection().equals("")) {
                            this.getRepository().removeFromRootCollection(toJid, nc.getNodeName());
                        } else {
                            AbstractNodeConfig cnc = this.getRepository().getNodeConfig(toJid, nc.getCollection());
                            if (cnc == null) {
                                throw new PubSubException(Authorization.ITEM_NOT_FOUND, "(#3) Node '" + nc.getCollection() + "' doesn't exists");
                            }
                            if (!(cnc instanceof CollectionNodeConfig)) {
                                throw new PubSubException(Authorization.NOT_ALLOWED, "(#2) Node '" + nc.getCollection() + "' is not collection node");
                            }
                            ((CollectionNodeConfig)cnc).removeChildren(nc.getNodeName());
                            this.getRepository().update(toJid, cnc.getNodeName(), cnc);
                        }
                        nc.setCollection(nodeName);
                        this.getRepository().update(toJid, nc.getNodeName(), nc);
                        Element associateNotification = this.createAssociateNotification(nodeName, ann);
                        this.publishModule.sendNotifications(associateNotification, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions);
                    }
                    for (String rnn : removedChildNodes) {
                        nc = this.getRepository().getNodeConfig(toJid, rnn);
                        if (nc != null) {
                            nc.setCollection("");
                            this.getRepository().update(toJid, nc.getNodeName(), nc);
                        }
                        if (rnn == null || rnn.length() == 0) continue;
                        Element disassociateNotification = this.createDisassociateNotification(nodeName, rnn);
                        this.publishModule.sendNotifications(disassociateNotification, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions);
                    }
                }
                this.getRepository().update(toJid, nodeName, nodeConfig);
                NodeConfigurationChangedHandler.NodeConfigurationChangedEvent event = new NodeConfigurationChangedHandler.NodeConfigurationChangedEvent(packet, nodeName);
                this.getEventBus().fire(event);
                if (nodeConfig.isNotify_config()) {
                    Element configuration = new Element("configuration", new String[]{"node"}, new String[]{nodeName});
                    this.publishModule.sendNotifications(configuration, packet.getStanzaTo(), nodeName, nodeConfig, nodeAffiliations, nodeSubscriptions);
                }
            } else {
                throw new PubSubException(element, Authorization.BAD_REQUEST);
            }
            this.packetWriter.write(result);
        }
        catch (PubSubException e1) {
            throw e1;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void removeNodeConfigurationChangedHandler(NodeConfigurationChangedHandler handler) {
        this.getEventBus().remove(handler);
    }

    public static interface NodeConfigurationChangedHandler
    extends EventHandler {
        public void onConfigurationChanged(Packet var1, String var2);

        public static class NodeConfigurationChangedEvent
        extends Event<NodeConfigurationChangedHandler> {
            public static final EventType<NodeConfigurationChangedHandler> TYPE = new EventType();
            private final String nodeName;
            private final Packet packet;

            public NodeConfigurationChangedEvent(Packet packet, String nodeName) {
                super(TYPE);
                this.packet = packet;
                this.nodeName = nodeName;
            }

            @Override
            protected void dispatch(NodeConfigurationChangedHandler handler) {
                handler.onConfigurationChanged(this.packet, this.nodeName);
            }
        }
    }
}

