/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub;

import java.util.logging.Logger;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import tigase.osgi.ModulesManager;
import tigase.pubsub.PepPlugin;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.repository.PubSubDAOJDBC;

public class Activator
implements BundleActivator,
ServiceListener {
    private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
    private BundleContext context = null;
    private Class<PepPlugin> pepPluginClass = null;
    private Class<PubSubComponent> pubsubComponentClass = null;
    private ModulesManager serviceManager = null;
    private ServiceReference serviceReference = null;

    private void registerAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.registerServerComponentClass(this.pubsubComponentClass);
            this.serviceManager.registerPluginClass(this.pepPluginClass);
            this.serviceManager.registerClass(PubSubDAOJDBC.class);
            this.serviceManager.update();
        }
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            if (this.serviceReference == null) {
                this.serviceReference = event.getServiceReference();
                this.serviceManager = (ModulesManager)this.context.getService(this.serviceReference);
                this.registerAddons();
            }
        } else if (event.getType() == 4 && this.serviceReference == event.getServiceReference()) {
            this.unregisterAddons();
            this.context.ungetService(this.serviceReference);
            this.serviceManager = null;
            this.serviceReference = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            this.context = bc;
            this.pepPluginClass = PepPlugin.class;
            this.pubsubComponentClass = PubSubComponent.class;
            bc.addServiceListener((ServiceListener)this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
            this.serviceReference = bc.getServiceReference(ModulesManager.class.getName());
            if (this.serviceReference != null) {
                this.serviceManager = (ModulesManager)bc.getService(this.serviceReference);
                this.registerAddons();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext bc) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            if (this.serviceManager != null) {
                this.unregisterAddons();
                this.context.ungetService(this.serviceReference);
                this.serviceManager = null;
                this.serviceReference = null;
            }
            this.pubsubComponentClass = null;
        }
    }

    private void unregisterAddons() {
        if (this.serviceManager != null) {
            this.serviceManager.unregisterClass(PubSubDAOJDBC.class);
            this.serviceManager.unregisterPluginClass(this.pepPluginClass);
            this.serviceManager.unregisterServerComponentClass(this.pubsubComponentClass);
            this.serviceManager.update();
        }
    }
}

