/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.util.StringUtils;

public class AccountManager
extends Manager {
    private static final Map<XMPPConnection, AccountManager> INSTANCES = new WeakHashMap<XMPPConnection, AccountManager>();
    private Registration info = null;
    private boolean accountCreationSupported = false;

    public static synchronized AccountManager getInstance(XMPPConnection connection) {
        AccountManager accountManager = INSTANCES.get(connection);
        if (accountManager == null) {
            accountManager = new AccountManager(connection);
        }
        return accountManager;
    }

    private AccountManager(XMPPConnection connection) {
        super(connection);
        INSTANCES.put(connection, this);
    }

    void setSupportsAccountCreation(boolean accountCreationSupported) {
        this.accountCreationSupported = accountCreationSupported;
    }

    public boolean supportsAccountCreation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.accountCreationSupported) {
            return true;
        }
        if (this.info == null) {
            this.getRegistrationInfo();
            this.accountCreationSupported = this.info.getType() != IQ.Type.ERROR;
        }
        return this.accountCreationSupported;
    }

    public Collection<String> getAccountAttributes() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Map<String, String> attributes;
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        if ((attributes = this.info.getAttributes()) != null) {
            return Collections.unmodifiableSet(attributes.keySet());
        }
        return Collections.emptySet();
    }

    public String getAccountAttribute(String name) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getAttributes().get(name);
    }

    public String getAccountInstructions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.info == null) {
            this.getRegistrationInfo();
        }
        return this.info.getInstructions();
    }

    public void createAccount(String username, String password) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String attributeName : this.getAccountAttributes()) {
            attributes.put(attributeName, "");
        }
        this.createAccount(username, password, attributes);
    }

    public void createAccount(String username, String password, Map<String, String> attributes) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection().getServiceName());
        attributes.put("username", username);
        attributes.put("password", password);
        reg.setAttributes(attributes);
        this.connection().createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    public void changePassword(String newPassword) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection().getServiceName());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("username", StringUtils.parseName(this.connection().getUser()));
        map.put("password", newPassword);
        reg.setAttributes(map);
        this.connection().createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    public void deleteAccount() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setType(IQ.Type.SET);
        reg.setTo(this.connection().getServiceName());
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("remove", "");
        reg.setAttributes(attributes);
        this.connection().createPacketCollectorAndSend(reg).nextResultOrThrow();
    }

    private synchronized void getRegistrationInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Registration reg = new Registration();
        reg.setTo(this.connection().getServiceName());
        this.info = (Registration)this.connection().createPacketCollectorAndSend(reg).nextResultOrThrow();
    }
}

