/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.patch.delta;

import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.list.HollowListTypeReadState;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.read.engine.set.HollowSetTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSchemaSorter;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.HollowWriteStateCreator;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.core.util.LongList;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.combine.IdentityOrdinalRemapper;
import com.netflix.hollow.tools.patch.delta.PartialOrdinalRemapper;
import com.netflix.hollow.tools.traverse.TransitiveSetTraverser;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HollowStateDeltaPatcher {
    private final HollowReadStateEngine from;
    private final HollowReadStateEngine to;
    private final HollowWriteStateEngine writeEngine;
    private final List<HollowSchema> schemas;
    private Map<String, BitSet> changedOrdinalsBetweenStates;

    public HollowStateDeltaPatcher(HollowReadStateEngine from, HollowReadStateEngine to) {
        this.from = from;
        this.to = to;
        this.schemas = HollowSchemaSorter.dependencyOrderedSchemaList(this.getCommonSchemas(from, to));
        this.writeEngine = HollowWriteStateCreator.createWithSchemas(this.schemas);
        this.changedOrdinalsBetweenStates = this.discoverChangedOrdinalsBetweenStates();
    }

    public HollowWriteStateEngine getStateEngine() {
        return this.writeEngine;
    }

    public void prepareInitialTransition() {
        this.writeEngine.overridePreviousStateRandomizedTag(this.from.getCurrentRandomizedTag());
        this.copyUnchangedDataToIntermediateState();
        this.remapTheChangedDataToUnusedOrdinals();
    }

    public void prepareFinalTransition() {
        this.writeEngine.prepareForNextCycle();
        this.writeEngine.overrideNextStateRandomizedTag(this.to.getCurrentRandomizedTag());
        this.copyUnchangedDataToDestinationState();
        this.remapTheChangedDataToDestinationOrdinals();
    }

    private void copyUnchangedDataToIntermediateState() {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "copy-unchanged");
        for (final HollowSchema schema : this.schemas) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    HollowTypeReadState fromTypeState = HollowStateDeltaPatcher.this.from.getTypeState(schema.getName());
                    HollowTypeWriteState writeTypeState = HollowStateDeltaPatcher.this.writeEngine.getTypeState(schema.getName());
                    BitSet changedOrdinals = (BitSet)HollowStateDeltaPatcher.this.changedOrdinalsBetweenStates.get(schema.getName());
                    HollowRecordCopier copier = HollowRecordCopier.createCopier(fromTypeState, schema, IdentityOrdinalRemapper.INSTANCE, true);
                    BitSet fromOrdinals = fromTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
                    int ordinal = fromOrdinals.nextSetBit(0);
                    while (ordinal != -1) {
                        boolean markCurrentCycle = !changedOrdinals.get(ordinal);
                        HollowWriteRecord rec = copier.copy(ordinal);
                        writeTypeState.mapOrdinal(rec, ordinal, true, markCurrentCycle);
                        ordinal = fromOrdinals.nextSetBit(ordinal + 1);
                    }
                    writeTypeState.recalculateFreeOrdinals();
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void remapTheChangedDataToUnusedOrdinals() {
        PartialOrdinalRemapper remapper = new PartialOrdinalRemapper();
        for (HollowSchema schema : this.schemas) {
            BitSet ordinalsToRemap = this.changedOrdinalsBetweenStates.get(schema.getName());
            HollowTypeReadState fromTypeState = this.from.getTypeState(schema.getName());
            HollowTypeReadState toTypeState = this.to.getTypeState(schema.getName());
            HollowTypeWriteState typeWriteState = this.writeEngine.getTypeState(schema.getName());
            IntMap ordinalRemapping = new IntMap(ordinalsToRemap.cardinality());
            int nextFreeOrdinal = Math.max(fromTypeState.maxOrdinal(), toTypeState.maxOrdinal()) + 1;
            boolean preserveHashPositions = this.shouldPreserveHashPositions(schema);
            HollowRecordCopier copier = HollowRecordCopier.createCopier(fromTypeState, schema, remapper, preserveHashPositions);
            int ordinal = ordinalsToRemap.nextSetBit(0);
            while (ordinal != -1 && ordinal <= fromTypeState.maxOrdinal()) {
                HollowWriteRecord copy = copier.copy(ordinal);
                typeWriteState.mapOrdinal(copy, nextFreeOrdinal, false, true);
                ordinalRemapping.put(ordinal, nextFreeOrdinal++);
                ordinal = ordinalsToRemap.nextSetBit(ordinal + 1);
            }
            remapper.addOrdinalRemapping(schema.getName(), ordinalRemapping);
            typeWriteState.recalculateFreeOrdinals();
        }
    }

    private void copyUnchangedDataToDestinationState() {
        for (HollowSchema schema : this.schemas) {
            HollowTypeWriteState writeTypeState = this.writeEngine.getTypeState(schema.getName());
            HollowTypeReadState toTypeState = this.to.getTypeState(schema.getName());
            HollowTypeReadState fromTypeState = this.from.getTypeState(schema.getName());
            BitSet toOrdinals = toTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            BitSet fromOrdinals = fromTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            BitSet changedOrdinals = this.changedOrdinalsBetweenStates.get(schema.getName());
            int ordinal = toOrdinals.nextSetBit(0);
            while (ordinal != -1) {
                if (!changedOrdinals.get(ordinal) && fromOrdinals.get(ordinal)) {
                    writeTypeState.addOrdinalFromPreviousCycle(ordinal);
                }
                ordinal = toOrdinals.nextSetBit(ordinal + 1);
            }
        }
    }

    private void remapTheChangedDataToDestinationOrdinals() {
        for (HollowSchema schema : this.schemas) {
            BitSet changedOrdinals = this.changedOrdinalsBetweenStates.get(schema.getName());
            HollowTypeWriteState typeWriteState = this.writeEngine.getTypeState(schema.getName());
            HollowTypeReadState toReadState = this.to.getTypeState(schema.getName());
            HollowTypeReadState fromReadState = this.from.getTypeState(schema.getName());
            BitSet toOrdinals = toReadState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            BitSet fromOrdinals = fromReadState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            HollowRecordCopier copier = HollowRecordCopier.createCopier(toReadState, schema, IdentityOrdinalRemapper.INSTANCE, true);
            int ordinal = toOrdinals.nextSetBit(0);
            while (ordinal != -1) {
                if (!fromOrdinals.get(ordinal) || changedOrdinals.get(ordinal)) {
                    HollowWriteRecord copy = copier.copy(ordinal);
                    typeWriteState.mapOrdinal(copy, ordinal, false, true);
                }
                ordinal = toOrdinals.nextSetBit(ordinal + 1);
            }
            typeWriteState.recalculateFreeOrdinals();
        }
    }

    private Map<String, BitSet> discoverChangedOrdinalsBetweenStates() {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "discover-changed");
        HashMap<String, BitSet> excludeOrdinalsFromCopy = new HashMap<String, BitSet>();
        for (HollowSchema schema : this.schemas) {
            BitSet recordsToExclude = this.findOrdinalsPopulatedWithDifferentRecords(schema.getName(), executor);
            excludeOrdinalsFromCopy.put(schema.getName(), recordsToExclude);
        }
        TransitiveSetTraverser.addReferencingOutsideClosure(this.from, excludeOrdinalsFromCopy);
        return excludeOrdinalsFromCopy;
    }

    private BitSet findOrdinalsPopulatedWithDifferentRecords(String typeName, SimultaneousExecutor executor) {
        final HollowTypeReadState fromTypeState = this.from.getTypeState(typeName);
        final HollowTypeReadState toTypeState = this.to.getTypeState(typeName);
        if (fromTypeState.getSchema().getSchemaType() != HollowSchema.SchemaType.OBJECT) {
            this.ensureEqualSchemas(fromTypeState, toTypeState);
        }
        final BitSet fromOrdinals = fromTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        final BitSet toOrdinals = toTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        final int maxSharedOrdinal = Math.min(fromTypeState.maxOrdinal(), toTypeState.maxOrdinal());
        final ThreadSafeBitSet populatedOrdinalsWithDifferentRecords = new ThreadSafeBitSet();
        final int numThreads = executor.getCorePoolSize();
        int i = 0;
        while (i < numThreads) {
            final int threadNum = i++;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    EqualityCondition equalityCondition = null;
                    switch (fromTypeState.getSchema().getSchemaType()) {
                        case OBJECT: {
                            equalityCondition = HollowStateDeltaPatcher.this.objectRecordEquality(fromTypeState, toTypeState);
                            break;
                        }
                        case LIST: {
                            equalityCondition = HollowStateDeltaPatcher.this.listRecordEquality(fromTypeState, toTypeState);
                            break;
                        }
                        case SET: {
                            equalityCondition = HollowStateDeltaPatcher.this.setRecordEquality(fromTypeState, toTypeState);
                            break;
                        }
                        case MAP: {
                            equalityCondition = HollowStateDeltaPatcher.this.mapRecordEquality(fromTypeState, toTypeState);
                        }
                    }
                    for (int i = threadNum; i <= maxSharedOrdinal; i += numThreads) {
                        if (!fromOrdinals.get(i) || !toOrdinals.get(i) || equalityCondition.recordsAreEqual(i)) continue;
                        populatedOrdinalsWithDifferentRecords.set(i);
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletionOfCurrentTasks();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this.toBitSet(populatedOrdinalsWithDifferentRecords);
    }

    private BitSet toBitSet(ThreadSafeBitSet tsbs) {
        BitSet bs = new BitSet(tsbs.currentCapacity());
        int bit = tsbs.nextSetBit(0);
        while (bit != -1) {
            bs.set(bit);
            bit = tsbs.nextSetBit(bit + 1);
        }
        return bs;
    }

    private EqualityCondition objectRecordEquality(HollowTypeReadState fromState, HollowTypeReadState toState) {
        final HollowObjectTypeReadState fromObjectState = (HollowObjectTypeReadState)fromState;
        final HollowObjectTypeReadState toObjectState = (HollowObjectTypeReadState)toState;
        final HollowObjectSchema commonSchema = fromObjectState.getSchema().findCommonSchema(toObjectState.getSchema());
        return new EqualityCondition(){

            @Override
            public boolean recordsAreEqual(int ordinal) {
                for (int i = 0; i < commonSchema.numFields(); ++i) {
                    int fromFieldPos = fromObjectState.getSchema().getPosition(commonSchema.getFieldName(i));
                    int toFieldPos = toObjectState.getSchema().getPosition(commonSchema.getFieldName(i));
                    if (!(commonSchema.getFieldType(i) == HollowObjectSchema.FieldType.REFERENCE ? fromObjectState.readOrdinal(ordinal, fromFieldPos) != toObjectState.readOrdinal(ordinal, toFieldPos) : !HollowReadFieldUtils.fieldsAreEqual(fromObjectState, ordinal, fromFieldPos, toObjectState, ordinal, toFieldPos))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private EqualityCondition listRecordEquality(HollowTypeReadState fromState, HollowTypeReadState toState) {
        final HollowListTypeReadState fromListState = (HollowListTypeReadState)fromState;
        final HollowListTypeReadState toListState = (HollowListTypeReadState)toState;
        return new EqualityCondition(){

            @Override
            public boolean recordsAreEqual(int ordinal) {
                int size = fromListState.size(ordinal);
                if (toListState.size(ordinal) != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (fromListState.getElementOrdinal(ordinal, i) == toListState.getElementOrdinal(ordinal, i)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private EqualityCondition setRecordEquality(HollowTypeReadState fromState, HollowTypeReadState toState) {
        final HollowSetTypeReadState fromSetState = (HollowSetTypeReadState)fromState;
        final HollowSetTypeReadState toSetState = (HollowSetTypeReadState)toState;
        return new EqualityCondition(){
            final IntList fromScratch = new IntList();
            final IntList toScratch = new IntList();

            @Override
            public boolean recordsAreEqual(int ordinal) {
                int size = fromSetState.size(ordinal);
                if (toSetState.size(ordinal) != size) {
                    return false;
                }
                this.fromScratch.clear();
                this.toScratch.clear();
                HollowOrdinalIterator iter = fromSetState.ordinalIterator(ordinal);
                int next = iter.next();
                while (next != Integer.MAX_VALUE) {
                    this.fromScratch.add(next);
                    next = iter.next();
                }
                iter = toSetState.ordinalIterator(ordinal);
                next = iter.next();
                while (next != Integer.MAX_VALUE) {
                    this.toScratch.add(next);
                    next = iter.next();
                }
                this.fromScratch.sort();
                this.toScratch.sort();
                return this.fromScratch.equals(this.toScratch);
            }
        };
    }

    private EqualityCondition mapRecordEquality(HollowTypeReadState fromState, HollowTypeReadState toState) {
        final HollowMapTypeReadState fromMapState = (HollowMapTypeReadState)fromState;
        final HollowMapTypeReadState toMapState = (HollowMapTypeReadState)toState;
        return new EqualityCondition(){
            final LongList fromScratch = new LongList();
            final LongList toScratch = new LongList();

            @Override
            public boolean recordsAreEqual(int ordinal) {
                int size = fromMapState.size(ordinal);
                if (toMapState.size(ordinal) != size) {
                    return false;
                }
                this.fromScratch.clear();
                this.toScratch.clear();
                HollowMapEntryOrdinalIterator iter = fromMapState.ordinalIterator(ordinal);
                while (iter.next()) {
                    this.fromScratch.add((long)iter.getKey() << 32 | (long)iter.getValue());
                }
                iter = toMapState.ordinalIterator(ordinal);
                while (iter.next()) {
                    this.toScratch.add((long)iter.getKey() << 32 | (long)iter.getValue());
                }
                this.fromScratch.sort();
                this.toScratch.sort();
                return this.fromScratch.equals(this.toScratch);
            }
        };
    }

    private void ensureEqualSchemas(HollowTypeReadState fromState, HollowTypeReadState toState) {
        if (!fromState.getSchema().equals(toState.getSchema())) {
            throw new IllegalStateException("FROM and TO schemas were not the same: " + fromState.getSchema().getName());
        }
    }

    private Set<HollowSchema> getCommonSchemas(HollowReadStateEngine from, HollowReadStateEngine to) {
        HashSet<HollowSchema> schemas = new HashSet<HollowSchema>();
        for (HollowSchema fromSchema : from.getSchemas()) {
            HollowSchema toSchema = to.getTypeState(fromSchema.getName()).getSchema();
            if (toSchema == null) continue;
            if (fromSchema.getSchemaType() == HollowSchema.SchemaType.OBJECT) {
                HollowObjectSchema commonSchema = ((HollowObjectSchema)fromSchema).findCommonSchema((HollowObjectSchema)toSchema);
                schemas.add(commonSchema);
                continue;
            }
            schemas.add(toSchema);
        }
        return schemas;
    }

    private boolean shouldPreserveHashPositions(HollowSchema schema) {
        switch (schema.getSchemaType()) {
            case MAP: {
                return this.from.getTypesWithDefinedHashCodes().contains(((HollowMapSchema)schema).getKeyType());
            }
            case SET: {
                return this.from.getTypesWithDefinedHashCodes().contains(((HollowSetSchema)schema).getElementType());
            }
        }
        return false;
    }

    private static interface EqualityCondition {
        public boolean recordsAreEqual(int var1);
    }
}

