/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history.keyindex;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.HollowReadFieldUtils;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.util.LongList;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.tools.util.SearchUtils;
import java.util.Arrays;
import java.util.BitSet;

public class HollowHistoryTypeKeyIndex {
    private final PrimaryKey primaryKey;
    private final String[][] keyFieldParts;
    private final boolean[] keyFieldIsIndexed;
    private HollowObjectSchema keySchema;
    private int[] hashedRecordKeys;
    private int[][] hashedFieldKeys;
    private LongList hashedFieldKeyChains;
    private int maxIndexedKeyOrdinal = 0;
    private final HollowWriteStateEngine writeStateEngine;
    private HollowReadStateEngine readStateEngine;
    private boolean isInitialized = false;

    public HollowHistoryTypeKeyIndex(PrimaryKey primaryKey, HollowDataset dataModel, HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine) {
        this.primaryKey = primaryKey;
        this.writeStateEngine = writeEngine;
        this.readStateEngine = readEngine;
        this.keyFieldParts = this.getKeyFieldParts(dataModel);
        this.keyFieldIsIndexed = new boolean[primaryKey.numFields()];
    }

    public void addFieldIndex(String fieldName, HollowDataset dataModel) {
        Object[] fieldPathParts = PrimaryKey.getCompleteFieldPathParts(dataModel, this.primaryKey.getType(), fieldName);
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            Object[] pkFieldPathParts = PrimaryKey.getCompleteFieldPathParts(dataModel, this.primaryKey.getType(), this.primaryKey.getFieldPath(i));
            if (!Arrays.equals(pkFieldPathParts, fieldPathParts)) continue;
            this.keyFieldIsIndexed[i] = true;
            break;
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void initialize(HollowObjectTypeReadState initialTypeState) {
        if (this.isInitialized) {
            return;
        }
        this.initKeySchema(initialTypeState.getSchema());
        this.initializeTypeWriteState();
        this.isInitialized = true;
    }

    public void updateReadStateEngine(HollowReadStateEngine readEngine) {
        this.readStateEngine = readEngine;
    }

    public void update(HollowObjectTypeReadState latestTypeState, boolean isDelta) {
        this.copyExistingKeys();
        if (latestTypeState == null) {
            return;
        }
        if (isDelta) {
            this.populateNewCurrentRecordKeys(latestTypeState);
        } else {
            this.populateAllCurrentRecordKeys(latestTypeState);
        }
    }

    public void hashRecordKeys() {
        HollowObjectTypeReadState keyTypeState = (HollowObjectTypeReadState)this.readStateEngine.getTypeState(this.primaryKey.getType());
        if (keyTypeState == null) {
            return;
        }
        int hashTableSize = HashCodes.hashTableSize(keyTypeState.maxOrdinal() + 1);
        if (this.hashedRecordKeys == null || this.hashedRecordKeys.length < hashTableSize) {
            this.rehashAllRecordKeys(keyTypeState, hashTableSize);
        } else {
            this.hashNewRecordKeys(keyTypeState);
        }
    }

    private void hashNewRecordKeys(HollowObjectTypeReadState keyTypeState) {
        for (int i = this.maxIndexedKeyOrdinal + 1; i <= keyTypeState.maxOrdinal(); ++i) {
            this.indexOrdinal(keyTypeState, i, this.hashedRecordKeys, this.hashedFieldKeys, this.hashedFieldKeyChains);
        }
        this.maxIndexedKeyOrdinal = keyTypeState.maxOrdinal();
    }

    private void rehashAllRecordKeys(HollowObjectTypeReadState keyTypeState, int hashTableSize) {
        int i;
        int[] hashedRecordKeys = this.initializeHashedKeyArray(hashTableSize);
        int[][] hashedFieldKeys = new int[this.primaryKey.numFields()][];
        LongList hashedFieldKeyChains = new LongList();
        for (i = 0; i < this.primaryKey.numFields(); ++i) {
            if (!this.keyFieldIsIndexed[i]) continue;
            hashedFieldKeys[i] = this.initializeHashedKeyArray(hashTableSize);
        }
        for (i = 0; i <= keyTypeState.maxOrdinal(); ++i) {
            this.indexOrdinal(keyTypeState, i, hashedRecordKeys, hashedFieldKeys, hashedFieldKeyChains);
        }
        this.hashedRecordKeys = hashedRecordKeys;
        this.hashedFieldKeys = hashedFieldKeys;
        this.hashedFieldKeyChains = hashedFieldKeyChains;
        this.maxIndexedKeyOrdinal = keyTypeState.maxOrdinal();
    }

    private void indexOrdinal(HollowObjectTypeReadState keyTypeState, int ordinal, int[] hashedRecordKeys, int[][] hashedFieldKeys, LongList hashedFieldKeyChains) {
        int bucketMask = hashedRecordKeys.length - 1;
        int bucket = this.hashKeyRecord(keyTypeState, ordinal) & bucketMask;
        while (hashedRecordKeys[bucket] != -1) {
            bucket = bucket + 1 & bucketMask;
        }
        hashedRecordKeys[bucket] = ordinal;
        for (int j = 0; j < this.primaryKey.numFields(); ++j) {
            if (!this.keyFieldIsIndexed[j]) continue;
            int fieldBucket = HashCodes.hashInt(HollowReadFieldUtils.fieldHashCode(keyTypeState, ordinal, j)) & bucketMask;
            int chainStartIndex = hashedFieldKeys[j][fieldBucket];
            while (chainStartIndex != -1) {
                int representativeOrdinal = (int)hashedFieldKeyChains.get(chainStartIndex);
                if (HollowReadFieldUtils.fieldsAreEqual(keyTypeState, ordinal, j, keyTypeState, representativeOrdinal, j)) {
                    hashedFieldKeyChains.add((long)chainStartIndex << 32 | (long)ordinal);
                    hashedFieldKeys[j][fieldBucket] = hashedFieldKeyChains.size() - 1;
                    break;
                }
                fieldBucket = fieldBucket + 1 & bucketMask;
                chainStartIndex = hashedFieldKeys[j][fieldBucket];
            }
            if (chainStartIndex != -1) continue;
            hashedFieldKeyChains.add(0x7FFFFFFF00000000L | (long)ordinal);
            hashedFieldKeys[j][fieldBucket] = hashedFieldKeyChains.size() - 1;
        }
    }

    private int[] initializeHashedKeyArray(int hashTableSize) {
        int[] hashedRecordKeys = new int[hashTableSize];
        Arrays.fill(hashedRecordKeys, -1);
        return hashedRecordKeys;
    }

    private int hashKeyRecord(HollowObjectTypeReadState typeState, int ordinal) {
        int hashCode = 0;
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            int fieldHashCode = HollowReadFieldUtils.fieldHashCode(typeState, ordinal, i);
            hashCode = hashCode * 31 ^ fieldHashCode;
        }
        return HashCodes.hashInt(hashCode);
    }

    public int findKeyIndexOrdinal(HollowObjectTypeReadState typeState, int ordinal) {
        HollowObjectTypeReadState keyTypeState = (HollowObjectTypeReadState)this.readStateEngine.getTypeState(this.primaryKey.getType());
        int bucketMask = this.hashedRecordKeys.length - 1;
        int bucket = this.findKeyHashCode(typeState, ordinal) & bucketMask;
        while (this.hashedRecordKeys[bucket] != -1) {
            if (this.recordMatchesKey(typeState, ordinal, keyTypeState, this.hashedRecordKeys[bucket])) {
                return this.hashedRecordKeys[bucket];
            }
            ++bucket;
            bucket &= bucketMask;
        }
        return -1;
    }

    private int findKeyHashCode(HollowObjectTypeReadState typeState, int ordinal) {
        int hashCode = 0;
        for (String[] keyFieldPart : this.keyFieldParts) {
            int fieldHashCode = this.findKeyFieldHashCode(typeState, ordinal, keyFieldPart, 0);
            hashCode = hashCode * 31 ^ fieldHashCode;
        }
        return HashCodes.hashInt(hashCode);
    }

    public IntList queryIndexedFields(final String query) {
        final HollowObjectTypeReadState keyTypeState = (HollowObjectTypeReadState)this.readStateEngine.getTypeState(this.primaryKey.getType());
        IntList matchingKeys = new IntList();
        if (keyTypeState == null) {
            return matchingKeys;
        }
        if (query.contains(":")) {
            Object[] parsedKey;
            String[] parts = query.split(":");
            if (parts.length != this.primaryKey.numFields()) {
                return matchingKeys;
            }
            try {
                parsedKey = SearchUtils.parseKey(this.readStateEngine, this.primaryKey, query);
            }
            catch (Exception e) {
                return matchingKeys;
            }
            BitSet selectedOrdinals = keyTypeState.getPopulatedOrdinals();
            int[][] fieldPathIndexes = SearchUtils.getFieldPathIndexes(this.readStateEngine, this.primaryKey);
            int ordinal = SearchUtils.getOrdinalToDisplay(this.readStateEngine, query, parsedKey, -1, selectedOrdinals, fieldPathIndexes, keyTypeState);
            matchingKeys.add(ordinal);
            return matchingKeys;
        }
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            final int fieldIndex = i;
            try {
                if (!this.keyFieldIsIndexed[i]) continue;
                switch (this.keySchema.getFieldType(i)) {
                    case INT: {
                        final int queryInt = Integer.parseInt(query);
                        int hashCode = HollowReadFieldUtils.intHashCode(queryInt);
                        this.addMatches(new Matcher(){

                            @Override
                            public boolean foundMatch(int ordinal) {
                                return keyTypeState.readInt(ordinal, fieldIndex) == queryInt;
                            }
                        }, i, hashCode, matchingKeys);
                        break;
                    }
                    case LONG: {
                        final long queryLong = Long.parseLong(query);
                        int hashCode = HollowReadFieldUtils.longHashCode(queryLong);
                        this.addMatches(new Matcher(){

                            @Override
                            public boolean foundMatch(int ordinal) {
                                return keyTypeState.readLong(ordinal, fieldIndex) == queryLong;
                            }
                        }, i, hashCode, matchingKeys);
                        break;
                    }
                    case STRING: {
                        int hashCode = HashCodes.hashCode(query);
                        this.addMatches(new Matcher(){

                            @Override
                            public boolean foundMatch(int ordinal) {
                                return keyTypeState.isStringFieldEqual(ordinal, fieldIndex, query);
                            }
                        }, i, hashCode, matchingKeys);
                        break;
                    }
                    case DOUBLE: {
                        final double queryDouble = Double.parseDouble(query);
                        int hashCode = HollowReadFieldUtils.doubleHashCode(queryDouble);
                        this.addMatches(new Matcher(){

                            @Override
                            public boolean foundMatch(int ordinal) {
                                return keyTypeState.readDouble(ordinal, fieldIndex) == queryDouble;
                            }
                        }, i, hashCode, matchingKeys);
                        break;
                    }
                    case FLOAT: {
                        final float queryFloat = Float.parseFloat(query);
                        int hashCode = HollowReadFieldUtils.floatHashCode(queryFloat);
                        this.addMatches(new Matcher(){

                            @Override
                            public boolean foundMatch(int ordinal) {
                                return keyTypeState.readFloat(ordinal, fieldIndex) == queryFloat;
                            }
                        }, i, hashCode, matchingKeys);
                        break;
                    }
                }
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return matchingKeys;
    }

    private void addMatches(Matcher matcher, int fieldIndex, int hashCode, IntList results) {
        int hashIntCode = HashCodes.hashInt(hashCode);
        int bucket = hashIntCode & this.hashedFieldKeys[fieldIndex].length - 1;
        while (this.hashedFieldKeys[fieldIndex][bucket] != -1) {
            int chainIndex = this.hashedFieldKeys[fieldIndex][bucket];
            int representativeOrdinal = (int)this.hashedFieldKeyChains.get(chainIndex);
            if (matcher.foundMatch(representativeOrdinal)) {
                while (representativeOrdinal != -1) {
                    results.add(representativeOrdinal);
                    chainIndex = (int)(this.hashedFieldKeyChains.get(chainIndex) >> 32);
                    representativeOrdinal = chainIndex == Integer.MAX_VALUE ? -1 : (int)this.hashedFieldKeyChains.get(chainIndex);
                }
                return;
            }
            ++bucket;
            bucket &= this.hashedFieldKeys[fieldIndex].length - 1;
        }
    }

    private int findKeyFieldHashCode(HollowObjectTypeReadState typeState, int ordinal, String[] keyFieldParts, int keyFieldPartPosition) {
        int schemaPosition = typeState.getSchema().getPosition(keyFieldParts[keyFieldPartPosition]);
        if (keyFieldPartPosition < keyFieldParts.length - 1) {
            HollowObjectTypeReadState nextPartTypeState = (HollowObjectTypeReadState)typeState.getSchema().getReferencedTypeState(schemaPosition);
            int nextOrdinal = typeState.readOrdinal(ordinal, schemaPosition);
            return this.findKeyFieldHashCode(nextPartTypeState, nextOrdinal, keyFieldParts, keyFieldPartPosition + 1);
        }
        return HollowReadFieldUtils.fieldHashCode(typeState, ordinal, schemaPosition);
    }

    private boolean recordMatchesKey(HollowObjectTypeReadState typeState, int ordinal, HollowObjectTypeReadState keyTypeState, int keyOrdinal) {
        for (int i = 0; i < this.keyFieldParts.length; ++i) {
            if (this.recordFieldMatchesKey(typeState, ordinal, keyTypeState, keyOrdinal, i, this.keyFieldParts[i], 0)) continue;
            return false;
        }
        return true;
    }

    private boolean recordFieldMatchesKey(HollowObjectTypeReadState typeState, int ordinal, HollowObjectTypeReadState keyTypeState, int keyOrdinal, int keyFieldPosition, String[] keyFieldParts, int keyFieldPartPosition) {
        int schemaPosition = typeState.getSchema().getPosition(keyFieldParts[keyFieldPartPosition]);
        if (keyFieldPartPosition < keyFieldParts.length - 1) {
            HollowObjectTypeReadState nextPartTypeState = (HollowObjectTypeReadState)typeState.getSchema().getReferencedTypeState(schemaPosition);
            int nextOrdinal = typeState.readOrdinal(ordinal, schemaPosition);
            return this.recordFieldMatchesKey(nextPartTypeState, nextOrdinal, keyTypeState, keyOrdinal, keyFieldPosition, keyFieldParts, keyFieldPartPosition + 1);
        }
        return HollowReadFieldUtils.fieldsAreEqual(typeState, ordinal, schemaPosition, keyTypeState, keyOrdinal, keyFieldPosition);
    }

    private void copyExistingKeys() {
        HollowTypeWriteState typeState = this.writeStateEngine.getTypeState(this.primaryKey.getType());
        if (typeState == null) {
            return;
        }
        typeState.addAllObjectsFromPreviousCycle();
    }

    private void populateAllCurrentRecordKeys(HollowObjectTypeReadState typeState) {
        HollowObjectWriteRecord rec = new HollowObjectWriteRecord(this.keySchema);
        PopulatedOrdinalListener listener = typeState.getListener(PopulatedOrdinalListener.class);
        BitSet previousOrdinals = listener.getPreviousOrdinals();
        BitSet populatedOrdinals = listener.getPopulatedOrdinals();
        int maxLength = Math.max(previousOrdinals.length(), populatedOrdinals.length());
        for (int i = 0; i < maxLength; ++i) {
            if (!populatedOrdinals.get(i) && !previousOrdinals.get(i)) continue;
            this.writeKeyObject(typeState, i, rec);
        }
    }

    private void populateNewCurrentRecordKeys(HollowObjectTypeReadState typeState) {
        HollowObjectWriteRecord rec = new HollowObjectWriteRecord(this.keySchema);
        PopulatedOrdinalListener listener = typeState.getListener(PopulatedOrdinalListener.class);
        BitSet populatedOrdinals = listener.getPopulatedOrdinals();
        BitSet previousOrdinals = listener.getPreviousOrdinals();
        RemovedOrdinalIterator iter = new RemovedOrdinalIterator(populatedOrdinals, previousOrdinals);
        int ordinal = iter.next();
        while (ordinal != -1) {
            this.writeKeyObject(typeState, ordinal, rec);
            ordinal = iter.next();
        }
    }

    public String[] getKeyFields() {
        return this.primaryKey.getFieldPaths();
    }

    public Object getKeyFieldValue(int keyFieldIdx, int keyOrdinal) {
        return HollowReadFieldUtils.fieldValueObject((HollowObjectTypeReadState)this.readStateEngine.getTypeState(this.primaryKey.getType()), keyOrdinal, keyFieldIdx);
    }

    public String getKeyDisplayString(int keyOrdinal) {
        HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)this.readStateEngine.getTypeState(this.primaryKey.getType());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            builder.append(HollowReadFieldUtils.displayString(typeState, keyOrdinal, i));
            if (i >= this.primaryKey.numFields() - 1) continue;
            builder.append(":");
        }
        return builder.toString();
    }

    private void writeKeyObject(HollowObjectTypeReadState typeState, int ordinal, HollowObjectWriteRecord rec) {
        rec.reset();
        for (int i = 0; i < this.keyFieldParts.length; ++i) {
            this.writeKeyField(typeState, ordinal, rec, this.primaryKey.getFieldPath(i), this.keyFieldParts[i], 0);
        }
        this.writeStateEngine.add(this.primaryKey.getType(), rec);
    }

    private void writeKeyField(HollowObjectTypeReadState typeState, int ordinal, HollowObjectWriteRecord rec, String keyField, String[] keyFieldParts, int keyFieldPartPosition) {
        int schemaPosition = typeState.getSchema().getPosition(keyFieldParts[keyFieldPartPosition]);
        if (keyFieldPartPosition < keyFieldParts.length - 1) {
            HollowObjectTypeReadState nextPartTypeState = (HollowObjectTypeReadState)typeState.getSchema().getReferencedTypeState(schemaPosition);
            int nextOrdinal = typeState.readOrdinal(ordinal, schemaPosition);
            this.writeKeyField(nextPartTypeState, nextOrdinal, rec, keyField, keyFieldParts, keyFieldPartPosition + 1);
        } else {
            switch (typeState.getSchema().getFieldType(schemaPosition)) {
                case BOOLEAN: {
                    Boolean bool = typeState.readBoolean(ordinal, schemaPosition);
                    if (bool == null) break;
                    rec.setBoolean(keyField, bool);
                    break;
                }
                case BYTES: {
                    byte[] b = typeState.readBytes(ordinal, schemaPosition);
                    if (b == null) break;
                    rec.setBytes(keyField, b);
                    break;
                }
                case DOUBLE: {
                    double d = typeState.readDouble(ordinal, schemaPosition);
                    if (Double.isNaN(d)) break;
                    rec.setDouble(keyField, d);
                    break;
                }
                case FLOAT: {
                    float f = typeState.readFloat(ordinal, schemaPosition);
                    if (Float.isNaN(f)) break;
                    rec.setFloat(keyField, f);
                    break;
                }
                case INT: {
                    int i = typeState.readInt(ordinal, schemaPosition);
                    rec.setInt(keyField, i);
                    break;
                }
                case LONG: {
                    long l = typeState.readLong(ordinal, schemaPosition);
                    rec.setLong(keyField, l);
                    break;
                }
                case STRING: {
                    String s = typeState.readString(ordinal, schemaPosition);
                    if (s == null) break;
                    rec.setString(keyField, s);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Primary key components must be a value leaf node");
                }
            }
        }
    }

    private void initKeySchema(HollowObjectSchema entireObjectSchema) {
        if (this.keySchema == null) {
            this.keySchema = new HollowObjectSchema(this.primaryKey.getType(), this.primaryKey.numFields(), new String[0]);
            for (int i = 0; i < this.keyFieldParts.length; ++i) {
                this.addSchemaField(entireObjectSchema, this.keySchema, this.primaryKey.getFieldPath(i), this.keyFieldParts[i], 0);
            }
        }
    }

    private void addSchemaField(HollowObjectSchema schema, HollowObjectSchema keySchema, String keyField, String[] keyFieldParts, int keyFieldPartPosition) {
        int schemaPosition = schema.getPosition(keyFieldParts[keyFieldPartPosition]);
        if (keyFieldPartPosition < keyFieldParts.length - 1) {
            HollowObjectSchema nextPartSchema = (HollowObjectSchema)schema.getReferencedTypeState(schemaPosition).getSchema();
            this.addSchemaField(nextPartSchema, keySchema, keyField, keyFieldParts, keyFieldPartPosition + 1);
        } else {
            keySchema.addField(keyField, schema.getFieldType(schemaPosition), schema.getReferencedType(schemaPosition));
        }
    }

    private void initializeTypeWriteState() {
        HollowObjectTypeWriteState writeState = new HollowObjectTypeWriteState(this.keySchema);
        this.writeStateEngine.addTypeState(writeState);
    }

    private String[][] getKeyFieldParts(HollowDataset dataModel) {
        String[][] keyFieldParts = new String[this.primaryKey.numFields()][];
        for (int i = 0; i < this.primaryKey.numFields(); ++i) {
            keyFieldParts[i] = PrimaryKey.getCompleteFieldPathParts(dataModel, this.primaryKey.getType(), this.primaryKey.getFieldPath(i));
        }
        return keyFieldParts;
    }

    private static interface Matcher {
        public boolean foundMatch(int var1);
    }
}

