/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history.keyindex;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.read.engine.HollowBlobReader;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowBlobWriter;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.tools.history.HollowHistory;
import com.netflix.hollow.tools.history.keyindex.HollowHistoryTypeKeyIndex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class HollowHistoryKeyIndex {
    private final HollowHistory history;
    private final Map<String, HollowHistoryTypeKeyIndex> typeKeyIndexes;
    private final HollowWriteStateEngine writeStateEngine;
    private HollowReadStateEngine readStateEngine;

    public HollowHistoryKeyIndex(HollowHistory history) {
        this.history = history;
        this.typeKeyIndexes = new HashMap<String, HollowHistoryTypeKeyIndex>();
        this.writeStateEngine = new HollowWriteStateEngine();
        this.readStateEngine = new HollowReadStateEngine();
    }

    public int numUniqueKeys(String type) {
        return this.readStateEngine.getTypeState(type).maxOrdinal() + 1;
    }

    public String getKeyDisplayString(String type, int keyOrdinal) {
        return this.typeKeyIndexes.get(type).getKeyDisplayString(keyOrdinal);
    }

    public int getRecordKeyOrdinal(HollowObjectTypeReadState typeState, int ordinal) {
        return this.typeKeyIndexes.get(typeState.getSchema().getName()).findKeyIndexOrdinal(typeState, ordinal);
    }

    public void addTypeIndex(String type, String ... keyFieldPaths) {
        this.addTypeIndex(new PrimaryKey(type, keyFieldPaths));
    }

    public void addTypeIndex(PrimaryKey primaryKey) {
        this.addTypeIndex(primaryKey, this.history.getLatestState());
    }

    public HollowHistoryTypeKeyIndex addTypeIndex(PrimaryKey primaryKey, HollowDataset dataModel) {
        HollowHistoryTypeKeyIndex keyIdx = new HollowHistoryTypeKeyIndex(primaryKey, dataModel, this.writeStateEngine, this.readStateEngine);
        this.typeKeyIndexes.put(primaryKey.getType(), keyIdx);
        return keyIdx;
    }

    public void indexTypeField(String type, String keyFieldPath) {
        this.typeKeyIndexes.get(type).addFieldIndex(keyFieldPath, this.history.getLatestState());
    }

    public void indexTypeField(PrimaryKey primaryKey) {
        this.indexTypeField(primaryKey, this.history.getLatestState());
    }

    public void indexTypeField(PrimaryKey primaryKey, HollowDataset dataModel) {
        String type = primaryKey.getType();
        HollowHistoryTypeKeyIndex typeIndex = this.typeKeyIndexes.get(type);
        if (typeIndex == null) {
            typeIndex = this.addTypeIndex(primaryKey, dataModel);
        }
        for (String fieldPath : primaryKey.getFieldPaths()) {
            typeIndex.addFieldIndex(fieldPath, dataModel);
        }
    }

    public Map<String, HollowHistoryTypeKeyIndex> getTypeKeyIndexes() {
        return this.typeKeyIndexes;
    }

    public void update(HollowReadStateEngine latestStateEngine, boolean isDelta) {
        boolean isInitialUpdate = !this.isInitialized();
        this.initializeTypeIndexes(latestStateEngine);
        this.updateTypeIndexes(latestStateEngine, isDelta && !isInitialUpdate);
        HollowReadStateEngine newReadState = this.roundTripStateEngine(isInitialUpdate, !isDelta);
        if (newReadState != this.readStateEngine) {
            this.readStateEngine = newReadState;
            for (Map.Entry<String, HollowHistoryTypeKeyIndex> entry : this.typeKeyIndexes.entrySet()) {
                entry.getValue().updateReadStateEngine(this.readStateEngine);
            }
        }
        this.rehashKeys();
    }

    public boolean isInitialized() {
        return !this.readStateEngine.getTypeStates().isEmpty();
    }

    private void initializeTypeIndexes(HollowReadStateEngine latestStateEngine) {
        for (Map.Entry<String, HollowHistoryTypeKeyIndex> entry : this.typeKeyIndexes.entrySet()) {
            HollowObjectTypeReadState typeState;
            String type = entry.getKey();
            HollowHistoryTypeKeyIndex index = entry.getValue();
            if (index.isInitialized() || (typeState = (HollowObjectTypeReadState)latestStateEngine.getTypeState(type)) == null) continue;
            index.initialize(typeState);
        }
    }

    private void updateTypeIndexes(HollowReadStateEngine latestStateEngine, boolean isDelta) {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "update-type-indexes");
        for (Map.Entry<String, HollowHistoryTypeKeyIndex> entry : this.typeKeyIndexes.entrySet()) {
            executor.execute(() -> {
                HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)latestStateEngine.getTypeState((String)entry.getKey());
                ((HollowHistoryTypeKeyIndex)entry.getValue()).update(typeState, isDelta);
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private HollowReadStateEngine roundTripStateEngine(boolean isInitialUpdate, boolean isSnapshot) {
        HollowBlobWriter writer = new HollowBlobWriter(this.writeStateEngine);
        HollowReadStateEngine newReadStateEngine = isInitialUpdate || !isSnapshot ? this.readStateEngine : new HollowReadStateEngine();
        HollowBlobReader reader = new HollowBlobReader(newReadStateEngine);
        SimultaneousExecutor executor = new SimultaneousExecutor(1, HollowHistoryKeyIndex.class, "round-trip");
        Exception pipeException = null;
        try (PipedInputStream is = new PipedInputStream(32768);){
            BufferedOutputStream out = new BufferedOutputStream(new PipedOutputStream(is));
            executor.execute(() -> {
                try (BufferedOutputStream ac = out;){
                    if (isInitialUpdate || isSnapshot) {
                        writer.writeSnapshot(out);
                    } else {
                        writer.writeDelta(out);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            HollowBlobInput in = HollowBlobInput.serial(new BufferedInputStream(is));
            if (isInitialUpdate || isSnapshot) {
                reader.readSnapshot(in);
            } else {
                reader.applyDelta(in);
            }
        }
        catch (Exception e) {
            pipeException = e;
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            if (pipeException == null) {
                throw new RuntimeException(e);
            }
            pipeException.addSuppressed(e);
        }
        if (pipeException != null) {
            throw new RuntimeException(pipeException);
        }
        this.writeStateEngine.prepareForNextCycle();
        return newReadStateEngine;
    }

    private void rehashKeys() {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "rehash-keys");
        for (Map.Entry<String, HollowHistoryTypeKeyIndex> entry : this.typeKeyIndexes.entrySet()) {
            executor.execute(() -> ((HollowHistoryTypeKeyIndex)entry.getValue()).hashRecordKeys());
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }
}

