/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.read.engine.object.HollowObjectTypeReadState;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.RemovedOrdinalIterator;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.tools.diff.exact.DiffEqualOrdinalMap;
import com.netflix.hollow.tools.diff.exact.DiffEqualityMapping;
import com.netflix.hollow.tools.history.DiffEqualityMappingOrdinalRemapper;
import com.netflix.hollow.tools.history.HollowHistoricalState;
import com.netflix.hollow.tools.history.HollowHistoricalStateCreator;
import com.netflix.hollow.tools.history.HollowHistoricalStateDataAccess;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateKeyOrdinalMapping;
import com.netflix.hollow.tools.history.keyindex.HollowHistoricalStateTypeKeyOrdinalMapping;
import com.netflix.hollow.tools.history.keyindex.HollowHistoryKeyIndex;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;

public class HollowHistory {
    private final HollowHistoryKeyIndex keyIndex = new HollowHistoryKeyIndex(this);
    private final HollowHistoricalStateCreator creator = new HollowHistoricalStateCreator(this);
    private final int maxHistoricalStatesToKeep;
    private HollowReadStateEngine latestHollowReadStateEngine;
    private Map<String, String> latestHeaderEntries;
    private final List<HollowHistoricalState> historicalStates;
    private final Map<Long, HollowHistoricalState> historicalStateLookupMap;
    private long latestVersion;
    private boolean ignoreListOrderingOnDoubleSnapshot = false;

    public HollowHistory(HollowReadStateEngine initialHollowStateEngine, long initialVersion, int maxHistoricalStatesToKeep) {
        this(initialHollowStateEngine, initialVersion, maxHistoricalStatesToKeep, true);
    }

    public HollowHistory(HollowReadStateEngine initialHollowStateEngine, long initialVersion, int maxHistoricalStatesToKeep, boolean isAutoDiscoverTypeIndex) {
        this.latestHollowReadStateEngine = initialHollowStateEngine;
        this.latestHeaderEntries = this.latestHollowReadStateEngine.getHeaderTags();
        this.historicalStates = new ArrayList<HollowHistoricalState>();
        this.historicalStateLookupMap = new HashMap<Long, HollowHistoricalState>();
        this.maxHistoricalStatesToKeep = maxHistoricalStatesToKeep;
        this.latestVersion = initialVersion;
        if (isAutoDiscoverTypeIndex) {
            for (HollowSchema schema : initialHollowStateEngine.getSchemas()) {
                PrimaryKey pKey;
                if (!(schema instanceof HollowObjectSchema) || (pKey = ((HollowObjectSchema)schema).getPrimaryKey()) == null) continue;
                this.keyIndex.addTypeIndex(pKey);
                this.keyIndex.indexTypeField(pKey);
            }
        }
    }

    public void ignoreListOrderingOnDoubleSnapshot() {
        this.ignoreListOrderingOnDoubleSnapshot = true;
    }

    public HollowHistoryKeyIndex getKeyIndex() {
        return this.keyIndex;
    }

    public HollowReadStateEngine getLatestState() {
        return this.latestHollowReadStateEngine;
    }

    public HollowHistoricalState[] getHistoricalStates() {
        return this.historicalStates.toArray(new HollowHistoricalState[this.historicalStates.size()]);
    }

    public int getNumberOfHistoricalStates() {
        return this.historicalStates.size();
    }

    public HollowHistoricalState getHistoricalState(long version) {
        if (this.latestVersion == version) {
            return this.historicalStates.get(0);
        }
        return this.historicalStateLookupMap.get(version);
    }

    public void deltaOccurred(long newVersion) {
        this.keyIndex.update(this.latestHollowReadStateEngine, true);
        HollowHistoricalStateDataAccess historicalDataAccess = this.creator.createBasedOnNewDelta(this.latestVersion, this.latestHollowReadStateEngine);
        historicalDataAccess.setNextState(this.latestHollowReadStateEngine);
        HollowHistoricalStateKeyOrdinalMapping keyOrdinalMapping = this.createKeyOrdinalMappingFromDelta();
        HollowHistoricalState historicalState = new HollowHistoricalState(newVersion, keyOrdinalMapping, historicalDataAccess, this.latestHeaderEntries);
        this.addHistoricalState(historicalState);
        this.latestVersion = newVersion;
        this.latestHeaderEntries = this.latestHollowReadStateEngine.getHeaderTags();
    }

    public void doubleSnapshotOccurred(HollowReadStateEngine newHollowStateEngine, long newVersion) {
        HollowHistoricalStateDataAccess historicalDataAccess;
        if (!this.keyIndex.isInitialized()) {
            this.keyIndex.update(this.latestHollowReadStateEngine, false);
        }
        this.keyIndex.update(newHollowStateEngine, false);
        DiffEqualityMapping mapping = new DiffEqualityMapping(this.latestHollowReadStateEngine, newHollowStateEngine, true, !this.ignoreListOrderingOnDoubleSnapshot);
        DiffEqualityMappingOrdinalRemapper remapper = new DiffEqualityMappingOrdinalRemapper(mapping);
        HollowHistoricalStateDataAccess nextRemappedDataAccess = historicalDataAccess = this.creator.createHistoricalStateFromDoubleSnapshot(this.latestVersion, this.latestHollowReadStateEngine, newHollowStateEngine, remapper);
        HollowHistoricalState nextRemappedState = null;
        HollowHistoricalStateDataAccess[] remappedDataAccesses = new HollowHistoricalStateDataAccess[this.historicalStates.size()];
        HollowHistoricalStateKeyOrdinalMapping[] remappedKeyOrdinalMappings = new HollowHistoricalStateKeyOrdinalMapping[this.historicalStates.size()];
        this.remapHistoricalStateOrdinals(remapper, remappedDataAccesses, remappedKeyOrdinalMappings);
        for (int i = 0; i < this.historicalStates.size(); ++i) {
            HollowHistoricalState historicalStateToRemap = this.historicalStates.get(i);
            HollowHistoricalStateDataAccess remappedDataAccess = remappedDataAccesses[i];
            HollowHistoricalStateKeyOrdinalMapping remappedKeyOrdinalMapping = remappedKeyOrdinalMappings[i];
            remappedDataAccess.setNextState(nextRemappedDataAccess);
            nextRemappedDataAccess = remappedDataAccess;
            HollowHistoricalState remappedState = new HollowHistoricalState(historicalStateToRemap.getVersion(), remappedKeyOrdinalMapping, remappedDataAccess, historicalStateToRemap.getHeaderEntries());
            remappedState.setNextState(nextRemappedState);
            nextRemappedState = remappedState;
            this.historicalStates.set(i, remappedState);
            this.historicalStateLookupMap.put(remappedState.getVersion(), remappedState);
        }
        historicalDataAccess.setNextState(newHollowStateEngine);
        HollowHistoricalStateKeyOrdinalMapping keyOrdinalMapping = this.createKeyOrdinalMappingFromDoubleSnapshot(newHollowStateEngine, remapper);
        HollowHistoricalState historicalState = new HollowHistoricalState(newVersion, keyOrdinalMapping, historicalDataAccess, this.latestHeaderEntries);
        this.addHistoricalState(historicalState);
        this.latestVersion = newVersion;
        this.latestHollowReadStateEngine = newHollowStateEngine;
        this.latestHeaderEntries = this.latestHollowReadStateEngine.getHeaderTags();
    }

    private void remapHistoricalStateOrdinals(DiffEqualityMappingOrdinalRemapper remapper, HollowHistoricalStateDataAccess[] remappedDataAccesses, HollowHistoricalStateKeyOrdinalMapping[] remappedKeyOrdinalMappings) {
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "remap");
        int numThreads = executor.getCorePoolSize();
        int i = 0;
        while (i < executor.getCorePoolSize()) {
            int threadNumber = i++;
            executor.execute(() -> {
                for (int t = threadNumber; t < this.historicalStates.size(); t += numThreads) {
                    HollowHistoricalState historicalStateToRemap = this.historicalStates.get(t);
                    remappedDataAccesses[t] = this.creator.copyButRemapOrdinals(historicalStateToRemap.getDataAccess(), remapper);
                    remappedKeyOrdinalMappings[t] = historicalStateToRemap.getKeyOrdinalMapping().remap(remapper);
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private HollowHistoricalStateKeyOrdinalMapping createKeyOrdinalMappingFromDelta() {
        HollowHistoricalStateKeyOrdinalMapping keyOrdinalMapping = new HollowHistoricalStateKeyOrdinalMapping(this.keyIndex);
        for (String keyType : this.keyIndex.getTypeKeyIndexes().keySet()) {
            HollowHistoricalStateTypeKeyOrdinalMapping typeMapping = keyOrdinalMapping.getTypeMapping(keyType);
            HollowObjectTypeReadState typeState = (HollowObjectTypeReadState)this.latestHollowReadStateEngine.getTypeState(keyType);
            if (typeState == null) {
                typeMapping.prepare(0, 0);
                typeMapping.finish();
                continue;
            }
            PopulatedOrdinalListener listener = typeState.getListener(PopulatedOrdinalListener.class);
            RemovedOrdinalIterator removalIterator = new RemovedOrdinalIterator(listener);
            RemovedOrdinalIterator additionsIterator = new RemovedOrdinalIterator(listener.getPopulatedOrdinals(), listener.getPreviousOrdinals());
            typeMapping.prepare(additionsIterator.countTotal(), removalIterator.countTotal());
            int removedOrdinal = removalIterator.next();
            while (removedOrdinal != -1) {
                typeMapping.removed(typeState, removedOrdinal);
                removedOrdinal = removalIterator.next();
            }
            int addedOrdinal = additionsIterator.next();
            while (addedOrdinal != -1) {
                typeMapping.added(typeState, addedOrdinal);
                addedOrdinal = additionsIterator.next();
            }
            typeMapping.finish();
        }
        return keyOrdinalMapping;
    }

    private HollowHistoricalStateKeyOrdinalMapping createKeyOrdinalMappingFromDoubleSnapshot(HollowReadStateEngine newStateEngine, DiffEqualityMappingOrdinalRemapper ordinalRemapper) {
        HollowHistoricalStateKeyOrdinalMapping keyOrdinalMapping = new HollowHistoricalStateKeyOrdinalMapping(this.keyIndex);
        DiffEqualityMapping mapping = ordinalRemapper.getDiffEqualityMapping();
        for (String keyType : this.keyIndex.getTypeKeyIndexes().keySet()) {
            HollowHistoricalStateTypeKeyOrdinalMapping typeMapping = keyOrdinalMapping.getTypeMapping(keyType);
            HollowObjectTypeReadState fromTypeState = (HollowObjectTypeReadState)this.latestHollowReadStateEngine.getTypeState(keyType);
            HollowObjectTypeReadState toTypeState = (HollowObjectTypeReadState)newStateEngine.getTypeState(keyType);
            DiffEqualOrdinalMap equalOrdinalMap = mapping.getEqualOrdinalMap(keyType);
            BitSet fromOrdinals = fromTypeState == null ? new BitSet() : fromTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            BitSet toOrdinals = toTypeState == null ? new BitSet() : toTypeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            int removedOrdinalsCount = this.countUnmatchedOrdinals(fromOrdinals, equalOrdinalMap.getFromOrdinalIdentityTranslator());
            int addedOrdinalsCount = this.countUnmatchedOrdinals(toOrdinals, equalOrdinalMap.getToOrdinalIdentityTranslator());
            typeMapping.prepare(addedOrdinalsCount, removedOrdinalsCount);
            int fromOrdinal = fromOrdinals.nextSetBit(0);
            while (fromOrdinal != -1) {
                if (equalOrdinalMap.getIdentityFromOrdinal(fromOrdinal) == -1) {
                    typeMapping.removed(fromTypeState, fromOrdinal, ordinalRemapper.getMappedOrdinal(keyType, fromOrdinal));
                }
                fromOrdinal = fromOrdinals.nextSetBit(fromOrdinal + 1);
            }
            int toOrdinal = toOrdinals.nextSetBit(0);
            while (toOrdinal != -1) {
                if (equalOrdinalMap.getIdentityToOrdinal(toOrdinal) == -1) {
                    typeMapping.added(toTypeState, toOrdinal);
                }
                toOrdinal = toOrdinals.nextSetBit(toOrdinal + 1);
            }
            typeMapping.finish();
        }
        return keyOrdinalMapping;
    }

    private int countUnmatchedOrdinals(BitSet ordinals, DiffEqualOrdinalMap.OrdinalIdentityTranslator translator) {
        int count = 0;
        int ordinal = ordinals.nextSetBit(0);
        while (ordinal != -1) {
            if (translator.getIdentityOrdinal(ordinal) == -1) {
                ++count;
            }
            ordinal = ordinals.nextSetBit(ordinal + 1);
        }
        return count;
    }

    private void addHistoricalState(HollowHistoricalState historicalState) {
        if (this.historicalStates.size() > 0) {
            this.historicalStates.get(0).getDataAccess().setNextState(historicalState.getDataAccess());
            this.historicalStates.get(0).setNextState(historicalState);
        }
        this.historicalStates.add(0, historicalState);
        this.historicalStateLookupMap.put(historicalState.getVersion(), historicalState);
        if (this.historicalStates.size() > this.maxHistoricalStatesToKeep) {
            this.removeHistoricalStates(1);
        }
    }

    public void removeHistoricalStates(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.format("Number of states to remove is negative: %d", n));
        }
        if (n > this.historicalStates.size()) {
            throw new IllegalArgumentException(String.format("Number of states to remove, %d, is greater than the number of states. %d", n, this.historicalStates.size()));
        }
        while (n-- > 0) {
            HollowHistoricalState removedState = this.historicalStates.remove(this.historicalStates.size() - 1);
            this.historicalStateLookupMap.remove(removedState.getVersion());
        }
    }
}

