/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.api.client.StackTraceRecorder;
import com.netflix.hollow.api.error.SchemaNotFoundException;
import com.netflix.hollow.core.read.dataaccess.HollowDataAccess;
import com.netflix.hollow.core.read.dataaccess.HollowTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.missing.MissingDataHandler;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import com.netflix.hollow.tools.history.HollowHistoricalListDataAccess;
import com.netflix.hollow.tools.history.HollowHistoricalMapDataAccess;
import com.netflix.hollow.tools.history.HollowHistoricalObjectDataAccess;
import com.netflix.hollow.tools.history.HollowHistoricalSchemaChange;
import com.netflix.hollow.tools.history.HollowHistoricalSetDataAccess;
import com.netflix.hollow.tools.history.HollowHistoricalTypeDataAccess;
import com.netflix.hollow.tools.history.HollowHistory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HollowHistoricalStateDataAccess
implements HollowDataAccess {
    private final HollowHistory totalHistory;
    private final long version;
    private final OrdinalRemapper removedCopyOrdinalMapping;
    private final Map<String, HollowHistoricalSchemaChange> schemaChanges;
    private final Map<String, HollowHistoricalTypeDataAccess> typeDataAccessMap;
    private final HollowObjectHashCodeFinder hashCodeFinder;
    private final MissingDataHandler missingDataHandler;
    private HollowDataAccess nextState;
    private StackTraceRecorder stackTraceRecorder;

    public HollowHistoricalStateDataAccess(HollowHistory totalHistory, long version, HollowReadStateEngine removedRecordCopies, OrdinalRemapper removedCopyOrdinalMappings, Map<String, HollowHistoricalSchemaChange> schemaChanges) {
        this(totalHistory, version, removedRecordCopies, removedRecordCopies.getTypeStates(), removedCopyOrdinalMappings, schemaChanges);
    }

    public HollowHistoricalStateDataAccess(HollowHistory totalHistory, long version, HollowReadStateEngine removedRecordCopies, Collection<HollowTypeReadState> typeStates, OrdinalRemapper removedCopyOrdinalMappings, Map<String, HollowHistoricalSchemaChange> schemaChanges) {
        this.totalHistory = totalHistory;
        this.version = version;
        this.hashCodeFinder = removedRecordCopies.getHashCodeFinder();
        this.missingDataHandler = removedRecordCopies.getMissingDataHandler();
        this.removedCopyOrdinalMapping = removedCopyOrdinalMappings;
        this.schemaChanges = schemaChanges;
        HashMap<String, HollowHistoricalTypeDataAccess> typeDataAccessMap = new HashMap<String, HollowHistoricalTypeDataAccess>();
        for (HollowTypeReadState hollowTypeReadState : typeStates) {
            String typeName = hollowTypeReadState.getSchema().getName();
            switch (hollowTypeReadState.getSchema().getSchemaType()) {
                case OBJECT: {
                    typeDataAccessMap.put(typeName, new HollowHistoricalObjectDataAccess(this, hollowTypeReadState));
                    break;
                }
                case LIST: {
                    typeDataAccessMap.put(typeName, new HollowHistoricalListDataAccess(this, hollowTypeReadState));
                    break;
                }
                case SET: {
                    typeDataAccessMap.put(typeName, new HollowHistoricalSetDataAccess(this, hollowTypeReadState));
                    break;
                }
                case MAP: {
                    typeDataAccessMap.put(typeName, new HollowHistoricalMapDataAccess(this, hollowTypeReadState));
                }
            }
        }
        this.typeDataAccessMap = typeDataAccessMap;
        for (Map.Entry entry : typeDataAccessMap.entrySet()) {
            HollowHistoricalTypeDataAccess typeDataAccess = (HollowHistoricalTypeDataAccess)entry.getValue();
            switch (typeDataAccess.getSchema().getSchemaType()) {
                case MAP: {
                    ((HollowHistoricalMapDataAccess)typeDataAccess).buildKeyMatcher();
                    break;
                }
                case SET: {
                    ((HollowHistoricalSetDataAccess)typeDataAccess).buildKeyMatcher();
                    break;
                }
            }
        }
    }

    public HollowHistory getTotalHistory() {
        return this.totalHistory;
    }

    public long getVersion() {
        return this.version;
    }

    public void setNextState(HollowDataAccess nextState) {
        this.nextState = nextState;
    }

    public HollowDataAccess getNextState() {
        return this.nextState;
    }

    public OrdinalRemapper getOrdinalMapping() {
        return this.removedCopyOrdinalMapping;
    }

    public Map<String, HollowHistoricalSchemaChange> getSchemaChanges() {
        return this.schemaChanges;
    }

    @Override
    public HollowTypeDataAccess getTypeDataAccess(String typeName) {
        HollowDataAccess state = this;
        HollowTypeDataAccess typeDataAccess = this.typeDataAccessMap.get(typeName);
        if (typeDataAccess != null) {
            return typeDataAccess;
        }
        while (state instanceof HollowHistoricalStateDataAccess) {
            HollowHistoricalStateDataAccess historicalState = state;
            typeDataAccess = historicalState.typeDataAccessMap.get(typeName);
            if (typeDataAccess != null) {
                return typeDataAccess;
            }
            state = historicalState.getNextState();
        }
        return state.getTypeDataAccess(typeName);
    }

    @Override
    public Collection<String> getAllTypes() {
        return this.typeDataAccessMap.keySet();
    }

    @Override
    public HollowTypeDataAccess getTypeDataAccess(String typeName, int ordinal) {
        HollowDataAccess state = this;
        while (state instanceof HollowHistoricalStateDataAccess) {
            HollowHistoricalStateDataAccess historicalState = state;
            if (historicalState.getOrdinalMapping().ordinalIsMapped(typeName, ordinal)) {
                return state.getTypeDataAccess(typeName);
            }
            state = historicalState.getNextState();
        }
        return state.getTypeDataAccess(typeName);
    }

    @Override
    public HollowObjectHashCodeFinder getHashCodeFinder() {
        return this.hashCodeFinder;
    }

    @Override
    public MissingDataHandler getMissingDataHandler() {
        return this.missingDataHandler;
    }

    @Override
    public void resetSampling() {
        for (Map.Entry<String, HollowHistoricalTypeDataAccess> entry : this.typeDataAccessMap.entrySet()) {
            entry.getValue().getSampler().reset();
        }
    }

    @Override
    public boolean hasSampleResults() {
        for (Map.Entry<String, HollowHistoricalTypeDataAccess> entry : this.typeDataAccessMap.entrySet()) {
            if (!entry.getValue().getSampler().hasSampleResults()) continue;
            return true;
        }
        return false;
    }

    public void setStackTraceRecorder(StackTraceRecorder recorder) {
        this.stackTraceRecorder = recorder;
    }

    StackTraceRecorder getStackTraceRecorder() {
        return this.stackTraceRecorder;
    }

    @Override
    public List<HollowSchema> getSchemas() {
        ArrayList<HollowSchema> schemas = new ArrayList<HollowSchema>(this.typeDataAccessMap.size());
        for (Map.Entry<String, HollowHistoricalTypeDataAccess> entry : this.typeDataAccessMap.entrySet()) {
            schemas.add(entry.getValue().getSchema());
        }
        return schemas;
    }

    @Override
    public HollowSchema getSchema(String name) {
        return this.getTypeDataAccess(name).getSchema();
    }

    @Override
    public HollowSchema getNonNullSchema(String name) {
        HollowSchema schema = this.getSchema(name);
        if (schema == null) {
            throw new SchemaNotFoundException(name, this.getAllTypes());
        }
        return schema;
    }
}

