/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.history;

import com.netflix.hollow.api.sampling.DisabledSamplingDirector;
import com.netflix.hollow.api.sampling.HollowMapSampler;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.SetMapKeyHasher;
import com.netflix.hollow.core.read.engine.map.HollowMapTypeReadState;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.tools.history.HistoricalPrimaryKeyMatcher;
import com.netflix.hollow.tools.history.HollowHistoricalStateDataAccess;
import com.netflix.hollow.tools.history.HollowHistoricalTypeDataAccess;

public class HollowHistoricalMapDataAccess
extends HollowHistoricalTypeDataAccess
implements HollowMapTypeDataAccess {
    private HistoricalPrimaryKeyMatcher keyMatcher;

    public HollowHistoricalMapDataAccess(HollowHistoricalStateDataAccess dataAccess, HollowTypeReadState typeState) {
        super(dataAccess, typeState, new HollowMapSampler(typeState.getSchema().getName(), DisabledSamplingDirector.INSTANCE));
    }

    @Override
    public HollowMapSchema getSchema() {
        return (HollowMapSchema)this.removedRecords.getSchema();
    }

    @Override
    public int size(int ordinal) {
        this.sampler().recordSize();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowMapTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).size(ordinal);
        }
        return this.removedRecords().size(this.getMappedOrdinal(ordinal));
    }

    @Override
    public int get(int ordinal, int keyOrdinal) {
        this.sampler().recordGet();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowMapTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).get(ordinal, keyOrdinal);
        }
        return this.removedRecords().get(this.getMappedOrdinal(ordinal), keyOrdinal);
    }

    @Override
    public int get(int ordinal, int keyOrdinal, int hashCode) {
        this.sampler().recordGet();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowMapTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).get(ordinal, keyOrdinal, hashCode);
        }
        return this.removedRecords().get(this.getMappedOrdinal(ordinal), keyOrdinal, hashCode);
    }

    @Override
    public int findKey(int ordinal, Object ... hashKey) {
        return (int)(this.findEntry(ordinal, hashKey) >> 32);
    }

    @Override
    public int findValue(int ordinal, Object ... hashKey) {
        return (int)this.findEntry(ordinal, hashKey);
    }

    @Override
    public long findEntry(int ordinal, Object ... hashKey) {
        this.sampler().recordGet();
        this.recordStackTrace();
        if (this.keyMatcher == null) {
            return -1L;
        }
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowMapTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).findEntry(ordinal, hashKey);
        }
        ordinal = this.ordinalRemap.get(ordinal);
        HollowMapTypeReadState removedRecords = (HollowMapTypeReadState)this.getRemovedRecords();
        int hashTableSize = HashCodes.hashTableSize(removedRecords.size(ordinal));
        int hash = SetMapKeyHasher.hash(hashKey, this.keyMatcher.getFieldTypes());
        int bucket = hash & hashTableSize - 1;
        long bucketOrdinals = removedRecords.relativeBucket(ordinal, bucket);
        while (bucketOrdinals != -1L) {
            if (this.keyMatcher.keyMatches((int)(bucketOrdinals >> 32), hashKey)) {
                return bucketOrdinals;
            }
            ++bucket;
            bucketOrdinals = removedRecords.relativeBucket(ordinal, bucket &= hashTableSize - 1);
        }
        return -1L;
    }

    @Override
    public HollowMapEntryOrdinalIterator potentialMatchOrdinalIterator(int ordinal, int hashCode) {
        this.sampler().recordIterator();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowMapTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).potentialMatchOrdinalIterator(ordinal, hashCode);
        }
        return this.removedRecords().potentialMatchOrdinalIterator(this.getMappedOrdinal(ordinal), hashCode);
    }

    @Override
    public HollowMapEntryOrdinalIterator ordinalIterator(int ordinal) {
        this.sampler().recordIterator();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowMapTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).ordinalIterator(ordinal);
        }
        return this.removedRecords().ordinalIterator(this.getMappedOrdinal(ordinal));
    }

    @Override
    public long relativeBucket(int ordinal, int bucketIndex) {
        this.sampler().recordBucketRetrieval();
        this.recordStackTrace();
        if (!this.ordinalIsPresent(ordinal)) {
            return ((HollowMapTypeDataAccess)this.dataAccess.getTypeDataAccess(this.getSchema().getName(), ordinal)).relativeBucket(ordinal, bucketIndex);
        }
        return this.removedRecords().relativeBucket(this.getMappedOrdinal(ordinal), bucketIndex);
    }

    private HollowMapTypeReadState removedRecords() {
        return (HollowMapTypeReadState)this.removedRecords;
    }

    private HollowMapSampler sampler() {
        return (HollowMapSampler)this.sampler;
    }

    void buildKeyMatcher() {
        PrimaryKey hashKey = this.getSchema().getHashKey();
        if (hashKey != null) {
            this.keyMatcher = new HistoricalPrimaryKeyMatcher(this.getDataAccess(), hashKey);
        }
    }
}

