/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff.exact;

import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.util.LongList;

public class CombinedMatchPairResultsIterator {
    private final LongList[] shardedResults;
    private int currentShardList;
    private int currentShardListPosition;
    private int currentFromOrdinal;
    private final IntList list;

    public CombinedMatchPairResultsIterator(LongList[] shardedResults) {
        this.shardedResults = shardedResults;
        this.list = new IntList();
    }

    public boolean next() {
        this.list.clear();
        while (this.currentShardList < this.shardedResults.length) {
            if (this.currentShardListPosition < this.shardedResults[this.currentShardList].size()) {
                this.currentFromOrdinal = (int)(this.shardedResults[this.currentShardList].get(this.currentShardListPosition) >> 32);
                while (this.currentShardListPosition < this.shardedResults[this.currentShardList].size() && (int)(this.shardedResults[this.currentShardList].get(this.currentShardListPosition) >> 32) == this.currentFromOrdinal) {
                    int toOrdinal = (int)this.shardedResults[this.currentShardList].get(this.currentShardListPosition);
                    this.list.add(toOrdinal);
                    ++this.currentShardListPosition;
                }
                return true;
            }
            this.currentShardListPosition = 0;
            ++this.currentShardList;
        }
        return false;
    }

    public int fromOrdinal() {
        return this.currentFromOrdinal;
    }

    public IntList toOrdinals() {
        return this.list;
    }
}

