/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HollowDiffNodeIdentifier {
    private final List<HollowDiffNodeIdentifier> parents;
    private final String viaFieldName;
    private final String nodeName;

    public HollowDiffNodeIdentifier(String typeName) {
        this(null, null, typeName);
    }

    public HollowDiffNodeIdentifier(HollowDiffNodeIdentifier parent, String viaFieldName, String typeName) {
        this.parents = parent == null ? Collections.emptyList() : this.buildParentsList(parent);
        this.viaFieldName = viaFieldName;
        this.nodeName = typeName;
    }

    public List<HollowDiffNodeIdentifier> getParents() {
        return this.parents;
    }

    public String getViaFieldName() {
        return this.viaFieldName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    private List<HollowDiffNodeIdentifier> buildParentsList(HollowDiffNodeIdentifier immediateParent) {
        ArrayList<HollowDiffNodeIdentifier> parents = new ArrayList<HollowDiffNodeIdentifier>(immediateParent.getParents().size() + 1);
        parents.addAll(immediateParent.getParents());
        parents.add(immediateParent);
        return parents;
    }

    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.parents.size(); ++i) {
            String parentViaFieldName = this.parents.get(i).getViaFieldName();
            if (parentViaFieldName != null) {
                hashCode = 31 * hashCode + parentViaFieldName.hashCode();
            }
            hashCode = 31 * hashCode + this.parents.get(i).getNodeName().hashCode();
        }
        if (this.viaFieldName != null) {
            hashCode = 31 * hashCode + this.viaFieldName.hashCode();
        }
        hashCode = 31 * hashCode + this.nodeName.hashCode();
        return hashCode;
    }

    public boolean equals(Object other) {
        HollowDiffNodeIdentifier otherId;
        if (this == other) {
            return true;
        }
        if (other instanceof HollowDiffNodeIdentifier && (otherId = (HollowDiffNodeIdentifier)other).getParents().size() == this.parents.size()) {
            for (int i = this.parents.size() - 1; i >= 0; --i) {
                HollowDiffNodeIdentifier otherParent;
                HollowDiffNodeIdentifier myParent = this.parents.get(i);
                if (myParent.shallowEquals(otherParent = otherId.getParents().get(i))) continue;
                return false;
            }
            return this.shallowEquals(otherId);
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.parents.size() > 0) {
            builder.append(this.parents.get(0).getNodeName());
        }
        for (int i = 1; i < this.parents.size(); ++i) {
            builder.append('.').append(this.parents.get(i).getViaFieldName());
        }
        builder.append('.').append(this.viaFieldName);
        builder.append(" (").append(this.nodeName).append(")");
        return builder.toString();
    }

    private boolean shallowEquals(HollowDiffNodeIdentifier other) {
        if (this.viaFieldName == null ? other.getViaFieldName() == null : this.viaFieldName.equals(other.getViaFieldName())) {
            return this.nodeName.equals(other.getNodeName());
        }
        return false;
    }
}

