/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.compact;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSchemaSorter;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.IntMap;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.patch.delta.PartialOrdinalRemapper;
import com.netflix.hollow.tools.traverse.TransitiveSetTraverser;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HollowCompactor {
    private final HollowWriteStateEngine writeEngine;
    private final HollowReadStateEngine readEngine;
    private long minCandidateHoleCostInBytes;
    private int minCandidateHolePercentage;

    public HollowCompactor(HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine, CompactionConfig config) {
        this(writeEngine, readEngine, config.getMinCandidateHoleCostInBytes(), config.getMinCandidateHolePercentage());
    }

    public HollowCompactor(HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine, long minCandidateHoleCostInBytes, int minCandidateHolePercentage) {
        this.writeEngine = writeEngine;
        this.readEngine = readEngine;
        this.minCandidateHoleCostInBytes = minCandidateHoleCostInBytes;
        this.minCandidateHolePercentage = minCandidateHolePercentage;
    }

    public boolean needsCompaction() {
        return !this.findCompactionTargets().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact() {
        Set<String> compactionTargets = this.findCompactionTargets();
        HashMap<String, BitSet> relocatedOrdinals = new HashMap<String, BitSet>();
        PartialOrdinalRemapper remapper = new PartialOrdinalRemapper();
        for (String compactionTarget : compactionTargets) {
            HollowTypeReadState typeState = this.readEngine.getTypeState(compactionTarget);
            HollowTypeWriteState writeState = this.writeEngine.getTypeState(compactionTarget);
            BitSet populatedOrdinals = typeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
            BitSet typeRelocatedOrdinals = new BitSet(populatedOrdinals.length());
            int populatedCardinality = populatedOrdinals.cardinality();
            writeState.addAllObjectsFromPreviousCycle();
            int numRelocations = 0;
            int ordinalToRelocate = populatedOrdinals.nextSetBit(populatedCardinality);
            while (ordinalToRelocate != -1) {
                ++numRelocations;
                ordinalToRelocate = populatedOrdinals.nextSetBit(ordinalToRelocate + 1);
            }
            HollowRecordCopier copier = HollowRecordCopier.createCopier(typeState);
            IntMap remappedOrdinals = new IntMap(numRelocations);
            ordinalToRelocate = populatedOrdinals.length();
            int relocatePosition = -1;
            try {
                for (int i = 0; i < numRelocations; ++i) {
                    while (!populatedOrdinals.get(--ordinalToRelocate)) {
                    }
                    relocatePosition = populatedOrdinals.nextClearBit(relocatePosition + 1);
                    typeRelocatedOrdinals.set(ordinalToRelocate);
                    writeState.removeOrdinalFromThisCycle(ordinalToRelocate);
                    HollowWriteRecord rec = copier.copy(ordinalToRelocate);
                    writeState.mapOrdinal(rec, relocatePosition, false, true);
                    remappedOrdinals.put(ordinalToRelocate, relocatePosition);
                }
            }
            finally {
                writeState.recalculateFreeOrdinals();
            }
            remapper.addOrdinalRemapping(compactionTarget, remappedOrdinals);
            relocatedOrdinals.put(compactionTarget, typeRelocatedOrdinals);
        }
        TransitiveSetTraverser.addReferencingOutsideClosure(this.readEngine, relocatedOrdinals);
        for (HollowSchema schema : HollowSchemaSorter.dependencyOrderedSchemaList(this.writeEngine.getSchemas())) {
            if (compactionTargets.contains(schema.getName())) continue;
            HollowTypeWriteState writeState = this.writeEngine.getTypeState(schema.getName());
            writeState.addAllObjectsFromPreviousCycle();
            BitSet typeRelocatedOrdinals = (BitSet)relocatedOrdinals.get(schema.getName());
            if (typeRelocatedOrdinals == null) continue;
            HollowTypeReadState readState = this.readEngine.getTypeState(schema.getName());
            IntMap remappedOrdinals = new IntMap(typeRelocatedOrdinals.cardinality());
            boolean preserveHashPositions = this.shouldPreserveHashPositions(schema);
            HollowRecordCopier copier = HollowRecordCopier.createCopier(readState, remapper, preserveHashPositions);
            int remapOrdinal = typeRelocatedOrdinals.nextSetBit(0);
            while (remapOrdinal != -1) {
                HollowWriteRecord rec = copier.copy(remapOrdinal);
                int newOrdinal = writeState.add(rec);
                remappedOrdinals.put(remapOrdinal, newOrdinal);
                writeState.removeOrdinalFromThisCycle(remapOrdinal);
                remapOrdinal = typeRelocatedOrdinals.nextSetBit(remapOrdinal + 1);
            }
            remapper.addOrdinalRemapping(schema.getName(), remappedOrdinals);
        }
    }

    private Set<String> findCompactionTargets() {
        List<HollowSchema> schemas = HollowSchemaSorter.dependencyOrderedSchemaList(this.readEngine.getSchemas());
        HashSet<String> typesToCompact = new HashSet<String>();
        for (HollowSchema schema : schemas) {
            if (!this.isCompactionCandidate(schema.getName()) || this.candidateIsDependentOnAnyTargetedType(schema.getName(), typesToCompact)) continue;
            typesToCompact.add(schema.getName());
        }
        return typesToCompact;
    }

    private boolean isCompactionCandidate(String typeName) {
        HollowTypeReadState typeState = this.readEngine.getTypeState(typeName);
        BitSet populatedOrdinals = typeState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
        double numOrdinals = populatedOrdinals.length();
        double numHoles = populatedOrdinals.length() - populatedOrdinals.cardinality();
        double holePercentage = numHoles / numOrdinals * 100.0;
        long approximateHoleCostInBytes = typeState.getApproximateHoleCostInBytes();
        boolean isCompactionCandidate = holePercentage > (double)this.minCandidateHolePercentage && approximateHoleCostInBytes > this.minCandidateHoleCostInBytes;
        return isCompactionCandidate;
    }

    private boolean candidateIsDependentOnAnyTargetedType(String type, Set<String> targetedTypes) {
        for (String targetedType : targetedTypes) {
            if (!HollowSchemaSorter.typeIsTransitivelyDependent(this.readEngine, type, targetedType)) continue;
            return true;
        }
        return false;
    }

    private boolean shouldPreserveHashPositions(HollowSchema schema) {
        switch (schema.getSchemaType()) {
            case MAP: {
                return this.readEngine.getTypesWithDefinedHashCodes().contains(((HollowMapSchema)schema).getKeyType());
            }
            case SET: {
                return this.readEngine.getTypesWithDefinedHashCodes().contains(((HollowSetSchema)schema).getElementType());
            }
        }
        return false;
    }

    public static class CompactionConfig {
        private final long minCandidateHoleCostInBytes;
        private final int minCandidateHolePercentage;

        public CompactionConfig(long minCandidateHoleCostInBytes, int minCandidateHolePercentage) {
            this.minCandidateHoleCostInBytes = minCandidateHoleCostInBytes;
            this.minCandidateHolePercentage = minCandidateHolePercentage;
        }

        public long getMinCandidateHoleCostInBytes() {
            return this.minCandidateHoleCostInBytes;
        }

        public int getMinCandidateHolePercentage() {
            return this.minCandidateHolePercentage;
        }
    }
}

