/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.combine;

import com.netflix.hollow.core.index.HollowPrimaryKeyIndex;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import java.util.Map;

class HollowCombinerPrimaryKeyOrdinalRemapper
implements OrdinalRemapper {
    private final Map<String, HollowPrimaryKeyIndex[]> primaryKeyIndexes;
    private final OrdinalRemapper[] baseRemappers;
    private final int stateEngineIdx;

    public HollowCombinerPrimaryKeyOrdinalRemapper(OrdinalRemapper[] baseRemappers, Map<String, HollowPrimaryKeyIndex[]> primaryKeyIndexes, int stateEngineIdx) {
        this.primaryKeyIndexes = primaryKeyIndexes;
        this.baseRemappers = baseRemappers;
        this.stateEngineIdx = stateEngineIdx;
    }

    @Override
    public int getMappedOrdinal(String type, int originalOrdinal) {
        return this.baseRemappers[this.stateEngineIdx].getMappedOrdinal(type, originalOrdinal);
    }

    @Override
    public void remapOrdinal(String type, int originalOrdinal, int mappedOrdinal) {
        this.baseRemappers[this.stateEngineIdx].remapOrdinal(type, originalOrdinal, mappedOrdinal);
        HollowPrimaryKeyIndex[] typeKeyIndexes = this.primaryKeyIndexes.get(type);
        if (typeKeyIndexes != null) {
            Object[] primaryKey = typeKeyIndexes[this.stateEngineIdx].getRecordKey(originalOrdinal);
            for (int i = 0; i < this.baseRemappers.length; ++i) {
                int matchOrdinal;
                if (i == this.stateEngineIdx || typeKeyIndexes[i] == null || (matchOrdinal = typeKeyIndexes[i].getMatchingOrdinal(primaryKey)) == -1) continue;
                this.baseRemappers[i].remapOrdinal(type, matchOrdinal, mappedOrdinal);
            }
        }
    }

    @Override
    public boolean ordinalIsMapped(String type, int originalOrdinal) {
        return this.baseRemappers[this.stateEngineIdx].ordinalIsMapped(type, originalOrdinal);
    }
}

