/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.tools.combine;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.tools.combine.HollowCombiner;
import com.netflix.hollow.tools.combine.OrdinalRemapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class HollowCombinerOrdinalRemapper
implements OrdinalRemapper {
    private final HollowCombiner combiner;
    private final Map<String, int[]> typeMappings;

    public HollowCombinerOrdinalRemapper(HollowCombiner combiner, HollowReadStateEngine inputStateEngine) {
        this.combiner = combiner;
        this.typeMappings = this.initializeTypeMappings(inputStateEngine);
    }

    @Override
    public int getMappedOrdinal(String type, int originalOrdinal) {
        int[] typeMapping = this.typeMappings.get(type);
        if (typeMapping == null) {
            return originalOrdinal;
        }
        if (typeMapping[originalOrdinal] == -1) {
            typeMapping[originalOrdinal] = this.combiner.copyOrdinal(type, originalOrdinal);
        }
        return typeMapping[originalOrdinal];
    }

    @Override
    public void remapOrdinal(String type, int originalOrdinal, int mappedOrdinal) {
        this.typeMappings.get((Object)type)[originalOrdinal] = mappedOrdinal;
    }

    @Override
    public boolean ordinalIsMapped(String type, int originalOrdinal) {
        return this.typeMappings.get(type)[originalOrdinal] != -1;
    }

    private Map<String, int[]> initializeTypeMappings(HollowReadStateEngine inputStateEngine) {
        HashMap<String, int[]> typeMappings = new HashMap<String, int[]>();
        for (HollowTypeReadState typeState : inputStateEngine.getTypeStates()) {
            int[] mapping = new int[typeState.maxOrdinal() + 1];
            Arrays.fill(mapping, -1);
            typeMappings.put(typeState.getSchema().getName(), mapping);
        }
        return typeMappings;
    }
}

