/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper.flatrecords;

import com.netflix.hollow.core.HollowDataset;
import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.ArrayByteData;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.IntList;
import com.netflix.hollow.core.write.HollowHashableWriteRecord;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecord;
import com.netflix.hollow.core.write.objectmapper.flatrecords.HollowSchemaIdentifierMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FlatRecordWriter {
    private final HollowDataset dataset;
    private final HollowSchemaIdentifierMapper schemaIdMapper;
    private final ByteDataArray buf;
    private final Map<Integer, List<RecordLocation>> recordLocationsByHashCode;
    private final IntList recordLocationsByOrdinal;

    public FlatRecordWriter(HollowDataset dataset, HollowSchemaIdentifierMapper schemaIdMapper) {
        this.dataset = dataset;
        this.schemaIdMapper = schemaIdMapper;
        this.buf = new ByteDataArray();
        this.recordLocationsByOrdinal = new IntList();
        this.recordLocationsByHashCode = new HashMap<Integer, List<RecordLocation>>();
    }

    public int write(HollowSchema schema, HollowWriteRecord rec) {
        int schemaOrdinal = this.schemaIdMapper.getSchemaId(schema);
        int nextRecordOrdinal = this.recordLocationsByOrdinal.size();
        int recStart = (int)this.buf.length();
        VarInt.writeVInt(this.buf, schemaOrdinal);
        if (rec instanceof HollowHashableWriteRecord) {
            ((HollowHashableWriteRecord)rec).writeDataTo(this.buf, HollowHashableWriteRecord.HashBehavior.IGNORED_HASHES);
        } else {
            rec.writeDataTo(this.buf);
        }
        int recLen = (int)(this.buf.length() - (long)recStart);
        Integer recordHashCode = HashCodes.hashCode(this.buf.getUnderlyingArray(), recStart, recLen);
        List<RecordLocation> existingRecLocs = this.recordLocationsByHashCode.get(recordHashCode);
        if (existingRecLocs == null) {
            RecordLocation newRecordLocation = new RecordLocation(nextRecordOrdinal, recStart, recLen);
            existingRecLocs = Collections.singletonList(newRecordLocation);
            this.recordLocationsByHashCode.put(recordHashCode, existingRecLocs);
            this.recordLocationsByOrdinal.add(recStart);
            return newRecordLocation.ordinal;
        }
        for (RecordLocation existing : existingRecLocs) {
            if (recLen != existing.len || !this.buf.getUnderlyingArray().rangeEquals(recStart, this.buf.getUnderlyingArray(), existing.start, recLen)) continue;
            this.buf.setPosition(recStart);
            return existing.ordinal;
        }
        RecordLocation newRecordLocation = new RecordLocation(nextRecordOrdinal, recStart, recLen);
        if (existingRecLocs.size() == 1) {
            ArrayList<Object> newRecLocs = new ArrayList<Object>(2);
            newRecLocs.add(existingRecLocs.get(0));
            newRecLocs.add(newRecordLocation);
            this.recordLocationsByHashCode.put(recordHashCode, newRecLocs);
        } else {
            existingRecLocs.add(newRecordLocation);
        }
        this.recordLocationsByOrdinal.add(recStart);
        return newRecordLocation.ordinal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlatRecord generateFlatRecord() {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.writeTo(baos);
            byte[] arr = baos.toByteArray();
            ArrayByteData recordData = new ArrayByteData(arr);
            FlatRecord flatRecord = new FlatRecord(recordData, this.schemaIdMapper);
            return flatRecord;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        PrimaryKey primaryKey;
        if (this.recordLocationsByOrdinal.size() == 0) {
            throw new IOException("No data to write!");
        }
        int locationOfTopRecord = this.recordLocationsByOrdinal.get(this.recordLocationsByOrdinal.size() - 1);
        int schemaIdOfTopRecord = VarInt.readVInt(this.buf.getUnderlyingArray(), locationOfTopRecord);
        HollowSchema schemaOfTopRecord = this.schemaIdMapper.getSchema(schemaIdOfTopRecord);
        VarInt.writeVInt(os, locationOfTopRecord);
        int[] pkFieldValueLocations = null;
        if (schemaOfTopRecord.getSchemaType() == HollowSchema.SchemaType.OBJECT && (primaryKey = ((HollowObjectSchema)schemaOfTopRecord).getPrimaryKey()) != null) {
            pkFieldValueLocations = new int[primaryKey.numFields()];
            for (int i = 0; i < primaryKey.numFields(); ++i) {
                int[] fieldPathIndex = primaryKey.getFieldPathIndex(this.dataset, i);
                pkFieldValueLocations[i] = this.locatePrimaryKeyField(locationOfTopRecord, fieldPathIndex, 0);
            }
        }
        VarInt.writeVInt(os, (int)this.buf.length() - locationOfTopRecord);
        this.buf.getUnderlyingArray().writeTo(os, 0L, this.buf.length());
        if (pkFieldValueLocations != null) {
            for (int i = 0; i < pkFieldValueLocations.length; ++i) {
                VarInt.writeVInt(os, pkFieldValueLocations[i]);
            }
        }
    }

    private int locatePrimaryKeyField(int locationOfCurrentRecord, int[] fieldPathIndex, int idx) {
        int schemaIdOfRecord = VarInt.readVInt(this.buf.getUnderlyingArray(), locationOfCurrentRecord);
        HollowObjectSchema recordSchema = (HollowObjectSchema)this.schemaIdMapper.getSchema(schemaIdOfRecord);
        int fieldOffset = this.navigateToField(recordSchema, fieldPathIndex[idx], locationOfCurrentRecord += VarInt.sizeOfVInt(schemaIdOfRecord));
        if (idx == fieldPathIndex.length - 1) {
            return fieldOffset;
        }
        int ordinalOfNextRecord = VarInt.readVInt(this.buf.getUnderlyingArray(), fieldOffset);
        int offsetOfNextRecord = this.recordLocationsByOrdinal.get(ordinalOfNextRecord);
        return this.locatePrimaryKeyField(offsetOfNextRecord, fieldPathIndex, idx + 1);
    }

    private int navigateToField(HollowObjectSchema schema, int fieldIdx, int offset) {
        block7: for (int i = 0; i < fieldIdx; ++i) {
            switch (schema.getFieldType(i)) {
                case INT: 
                case LONG: 
                case REFERENCE: {
                    offset += VarInt.nextVLongSize(this.buf.getUnderlyingArray(), offset);
                    continue block7;
                }
                case BYTES: 
                case STRING: {
                    int fieldLength = VarInt.readVInt(this.buf.getUnderlyingArray(), offset);
                    offset += VarInt.sizeOfVInt(fieldLength);
                    offset += fieldLength;
                    continue block7;
                }
                case BOOLEAN: {
                    ++offset;
                    continue block7;
                }
                case DOUBLE: {
                    offset += 8;
                    continue block7;
                }
                case FLOAT: {
                    offset += 4;
                }
            }
        }
        return offset;
    }

    public void reset() {
        this.buf.reset();
        this.recordLocationsByHashCode.clear();
        this.recordLocationsByOrdinal.clear();
    }

    private static class RecordLocation {
        private final int ordinal;
        private final long start;
        private final int len;

        public RecordLocation(int ordinal, long start, int len) {
            this.ordinal = ordinal;
            this.start = start;
            this.len = len;
        }
    }
}

