/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper;

import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.HollowObjectHashCodeFinder;
import com.netflix.hollow.core.write.HollowSetTypeWriteState;
import com.netflix.hollow.core.write.HollowSetWriteRecord;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.HollowObjectTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import com.netflix.hollow.core.write.objectmapper.MemoizedSet;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;

public class HollowSetTypeMapper
extends HollowTypeMapper {
    private static final String NULL_ELEMENT_MESSAGE = "Null element contained in instance of a Set with schema \"%s\". Sets cannot contain null elements";
    private final HollowSetSchema schema;
    private final HollowSetTypeWriteState writeState;
    private final HollowObjectHashCodeFinder hashCodeFinder;
    private final HollowTypeMapper elementMapper;

    public HollowSetTypeMapper(HollowObjectMapper parentMapper, ParameterizedType type, String declaredName, String[] hashKeyFieldPaths, int numShards, HollowWriteStateEngine stateEngine, boolean useDefaultHashKeys, Set<Type> visited) {
        String typeName;
        this.elementMapper = parentMapper.getTypeMapper(type.getActualTypeArguments()[0], null, null, -1, visited);
        String string = typeName = declaredName != null ? declaredName : HollowSetTypeMapper.getDefaultTypeName(type);
        if (hashKeyFieldPaths == null && useDefaultHashKeys && this.elementMapper instanceof HollowObjectTypeMapper) {
            hashKeyFieldPaths = ((HollowObjectTypeMapper)this.elementMapper).getDefaultElementHashKey();
        }
        this.schema = new HollowSetSchema(typeName, this.elementMapper.getTypeName(), hashKeyFieldPaths);
        this.hashCodeFinder = stateEngine.getHashCodeFinder();
        HollowSetTypeWriteState existingTypeState = (HollowSetTypeWriteState)parentMapper.getStateEngine().getTypeState(typeName);
        this.writeState = existingTypeState != null ? existingTypeState : new HollowSetTypeWriteState(this.schema, numShards);
    }

    @Override
    protected String getTypeName() {
        return this.schema.getName();
    }

    @Override
    protected int write(Object obj) {
        long assignedOrdinal;
        if (obj instanceof MemoizedSet && ((assignedOrdinal = ((MemoizedSet)obj).__assigned_ordinal) & 0xFFFFFFFF00000000L) == this.cycleSpecificAssignedOrdinalBits()) {
            return (int)assignedOrdinal & Integer.MAX_VALUE;
        }
        Set s = (Set)obj;
        HollowSetWriteRecord rec = this.copyToWriteRecord(s, null);
        int assignedOrdinal2 = this.writeState.add(rec);
        if (obj instanceof MemoizedSet) {
            ((MemoizedSet)obj).__assigned_ordinal = (long)assignedOrdinal2 | this.cycleSpecificAssignedOrdinalBits();
        }
        return assignedOrdinal2;
    }

    @Override
    protected int writeFlat(Object obj, FlatRecordWriter flatRecordWriter) {
        HollowSetWriteRecord rec = this.copyToWriteRecord((Set)obj, flatRecordWriter);
        return flatRecordWriter.write(this.schema, rec);
    }

    private HollowSetWriteRecord copyToWriteRecord(Set<?> s, FlatRecordWriter flatRecordWriter) {
        HollowSetWriteRecord rec = (HollowSetWriteRecord)this.writeRecord();
        for (Object o : s) {
            if (o == null) {
                throw new NullPointerException(String.format(NULL_ELEMENT_MESSAGE, this.schema));
            }
            int ordinal = flatRecordWriter == null ? this.elementMapper.write(o) : this.elementMapper.writeFlat(o, flatRecordWriter);
            int hashCode = this.hashCodeFinder.hashCode(this.elementMapper.getTypeName(), ordinal, o);
            rec.addElement(ordinal, hashCode);
        }
        return rec;
    }

    @Override
    protected HollowWriteRecord newWriteRecord() {
        return new HollowSetWriteRecord();
    }

    @Override
    protected HollowTypeWriteState getTypeWriteState() {
        return this.writeState;
    }
}

