/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper;

import com.netflix.hollow.core.index.key.PrimaryKey;
import com.netflix.hollow.core.memory.HollowUnsafeHandle;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowObjectWriteRecord;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.objectmapper.HollowHashKey;
import com.netflix.hollow.core.write.objectmapper.HollowInline;
import com.netflix.hollow.core.write.objectmapper.HollowObjectMapper;
import com.netflix.hollow.core.write.objectmapper.HollowPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.HollowShardLargeType;
import com.netflix.hollow.core.write.objectmapper.HollowTransient;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowTypeName;
import com.netflix.hollow.core.write.objectmapper.NullablePrimitiveBoolean;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import sun.misc.Unsafe;

public class HollowObjectTypeMapper
extends HollowTypeMapper {
    private static final Unsafe unsafe = HollowUnsafeHandle.getUnsafe();
    private final HollowObjectMapper parentMapper;
    private final String typeName;
    private final Class<?> clazz;
    private final HollowObjectSchema schema;
    private final HollowObjectTypeWriteState writeState;
    private final boolean hasAssignedOrdinalField;
    private final long assignedOrdinalFieldOffset;
    private final List<MappedField> mappedFields;
    private volatile int[][] primaryKeyFieldPathIdx;

    public HollowObjectTypeMapper(HollowObjectMapper parentMapper, Class<?> clazz, String declaredTypeName, Set<Type> visited) {
        this.parentMapper = parentMapper;
        this.clazz = clazz;
        this.typeName = declaredTypeName != null ? declaredTypeName : HollowObjectTypeMapper.getDefaultTypeName(clazz);
        this.mappedFields = new ArrayList<MappedField>();
        boolean hasAssignedOrdinalField = false;
        long assignedOrdinalFieldOffset = -1L;
        if (clazz == String.class) {
            try {
                this.mappedFields.add(new MappedField(clazz.getDeclaredField("value")));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else if (clazz == Date.class) {
            try {
                this.mappedFields.add(new MappedField(MappedFieldType.DATE_TIME));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            for (Class currentClass = clazz; currentClass != Object.class && currentClass != Enum.class; currentClass = currentClass.getSuperclass()) {
                if (currentClass.isInterface()) {
                    throw new IllegalArgumentException("Unexpected interface " + currentClass.getSimpleName() + " passed as field.");
                }
                if (currentClass.isArray()) {
                    throw new IllegalArgumentException("Unexpected array " + currentClass.getSimpleName() + " passed as field. Consider using collections or marking as transient.");
                }
                Field[] declaredFields = currentClass.getDeclaredFields();
                for (int i = 0; i < declaredFields.length; ++i) {
                    Field declaredField = declaredFields[i];
                    int modifiers = declaredField.getModifiers();
                    if (!(Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || "__assigned_ordinal".equals(declaredField.getName()) || declaredField.isAnnotationPresent(HollowTransient.class))) {
                        this.mappedFields.add(new MappedField(declaredField, visited));
                        continue;
                    }
                    if (!"__assigned_ordinal".equals(declaredField.getName()) || currentClass != clazz || declaredField.getType() != Long.TYPE) continue;
                    assignedOrdinalFieldOffset = unsafe.objectFieldOffset(declaredField);
                    hasAssignedOrdinalField = true;
                }
                if (!currentClass.isEnum()) continue;
                this.mappedFields.add(new MappedField(MappedFieldType.ENUM_NAME));
            }
        }
        this.schema = new HollowObjectSchema(this.typeName, this.mappedFields.size(), HollowObjectTypeMapper.getKeyFieldPaths(clazz));
        for (MappedField field : this.mappedFields) {
            if (field.getFieldType() == MappedFieldType.REFERENCE) {
                this.schema.addField(field.getFieldName(), field.getFieldType().getSchemaFieldType(), field.getReferencedTypeName());
                continue;
            }
            this.schema.addField(field.getFieldName(), field.getFieldType().getSchemaFieldType());
        }
        HollowObjectTypeWriteState existingWriteState = (HollowObjectTypeWriteState)parentMapper.getStateEngine().getTypeState(this.typeName);
        this.writeState = existingWriteState != null ? existingWriteState : new HollowObjectTypeWriteState(this.schema, HollowObjectTypeMapper.getNumShards(clazz));
        this.assignedOrdinalFieldOffset = assignedOrdinalFieldOffset;
        this.hasAssignedOrdinalField = hasAssignedOrdinalField;
    }

    private static String[] getKeyFieldPaths(Class<?> clazz) {
        HollowPrimaryKey primaryKey = clazz.getAnnotation(HollowPrimaryKey.class);
        while (primaryKey == null && clazz != Object.class && clazz.isInterface()) {
            clazz = clazz.getSuperclass();
            primaryKey = clazz.getAnnotation(HollowPrimaryKey.class);
        }
        return primaryKey == null ? null : primaryKey.fields();
    }

    private static int getNumShards(Class<?> clazz) {
        HollowShardLargeType numShardsAnnotation = clazz.getAnnotation(HollowShardLargeType.class);
        if (numShardsAnnotation != null) {
            return numShardsAnnotation.numShards();
        }
        return -1;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public int write(Object obj) {
        long assignedOrdinal;
        if (this.hasAssignedOrdinalField && ((assignedOrdinal = unsafe.getLong(obj, this.assignedOrdinalFieldOffset)) & 0xFFFFFFFF00000000L) == this.cycleSpecificAssignedOrdinalBits()) {
            return (int)assignedOrdinal & Integer.MAX_VALUE;
        }
        HollowObjectWriteRecord rec = this.copyToWriteRecord(obj, null);
        int assignedOrdinal2 = this.writeState.add(rec);
        if (this.hasAssignedOrdinalField) {
            unsafe.putLong(obj, this.assignedOrdinalFieldOffset, (long)assignedOrdinal2 | this.cycleSpecificAssignedOrdinalBits());
        }
        return assignedOrdinal2;
    }

    @Override
    public int writeFlat(Object obj, FlatRecordWriter flatRecordWriter) {
        HollowObjectWriteRecord rec = this.copyToWriteRecord(obj, flatRecordWriter);
        return flatRecordWriter.write(this.schema, rec);
    }

    private HollowObjectWriteRecord copyToWriteRecord(Object obj, FlatRecordWriter flatRecordWriter) {
        if (obj.getClass() != this.clazz && !this.clazz.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Attempting to write unexpected class!  Expected " + this.clazz + " but object was " + obj.getClass());
        }
        HollowObjectWriteRecord rec = (HollowObjectWriteRecord)this.writeRecord();
        for (int i = 0; i < this.mappedFields.size(); ++i) {
            this.mappedFields.get(i).copy(obj, rec, flatRecordWriter);
        }
        return rec;
    }

    Object[] extractPrimaryKey(Object obj) {
        int[][] primaryKeyFieldPathIdx = this.primaryKeyFieldPathIdx;
        if (primaryKeyFieldPathIdx == null) {
            this.primaryKeyFieldPathIdx = primaryKeyFieldPathIdx = this.calculatePrimaryKeyFieldPathIdx(primaryKeyFieldPathIdx);
        }
        Object[] key = new Object[primaryKeyFieldPathIdx.length];
        for (int i = 0; i < key.length; ++i) {
            key[i] = this.retrieveFieldValue(obj, primaryKeyFieldPathIdx[i], 0);
        }
        return key;
    }

    private int[][] calculatePrimaryKeyFieldPathIdx(int[][] primaryKeyFieldPathIdx) {
        if (this.schema.getPrimaryKey() == null) {
            throw new IllegalArgumentException("Type " + this.typeName + " does not have a primary key defined");
        }
        primaryKeyFieldPathIdx = new int[this.schema.getPrimaryKey().numFields()][];
        for (int i = 0; i < ((int[][])primaryKeyFieldPathIdx).length; ++i) {
            primaryKeyFieldPathIdx[i] = this.schema.getPrimaryKey().getFieldPathIndex(this.parentMapper.getStateEngine(), i);
        }
        return primaryKeyFieldPathIdx;
    }

    String[] getDefaultElementHashKey() {
        MappedField singleField;
        PrimaryKey pKey = this.schema.getPrimaryKey();
        if (pKey != null) {
            return pKey.getFieldPaths();
        }
        if (this.mappedFields.size() == 1 && (singleField = this.mappedFields.get(0)).getFieldType() != MappedFieldType.REFERENCE) {
            return new String[]{singleField.getFieldName()};
        }
        return null;
    }

    @Override
    protected HollowWriteRecord newWriteRecord() {
        return new HollowObjectWriteRecord(this.schema);
    }

    @Override
    protected HollowTypeWriteState getTypeWriteState() {
        return this.writeState;
    }

    private Object retrieveFieldValue(Object obj, int[] fieldPathIdx, int idx) {
        return this.mappedFields.get(fieldPathIdx[idx]).retrieveFieldValue(obj, fieldPathIdx, idx);
    }

    private static enum MappedFieldType {
        BOOLEAN(HollowObjectSchema.FieldType.BOOLEAN),
        NULLABLE_PRIMITIVE_BOOLEAN(HollowObjectSchema.FieldType.BOOLEAN),
        BYTES(HollowObjectSchema.FieldType.BYTES),
        DOUBLE(HollowObjectSchema.FieldType.DOUBLE),
        FLOAT(HollowObjectSchema.FieldType.FLOAT),
        INT(HollowObjectSchema.FieldType.INT),
        SHORT(HollowObjectSchema.FieldType.INT),
        BYTE(HollowObjectSchema.FieldType.INT),
        CHAR(HollowObjectSchema.FieldType.INT),
        LONG(HollowObjectSchema.FieldType.LONG),
        STRING(HollowObjectSchema.FieldType.STRING),
        INLINED_BOOLEAN(HollowObjectSchema.FieldType.BOOLEAN),
        INLINED_DOUBLE(HollowObjectSchema.FieldType.DOUBLE),
        INLINED_FLOAT(HollowObjectSchema.FieldType.FLOAT),
        INLINED_INT(HollowObjectSchema.FieldType.INT),
        INLINED_SHORT(HollowObjectSchema.FieldType.INT),
        INLINED_BYTE(HollowObjectSchema.FieldType.INT),
        INLINED_CHAR(HollowObjectSchema.FieldType.INT),
        INLINED_LONG(HollowObjectSchema.FieldType.LONG),
        INLINED_STRING(HollowObjectSchema.FieldType.STRING),
        REFERENCE(HollowObjectSchema.FieldType.REFERENCE),
        ENUM_NAME(HollowObjectSchema.FieldType.STRING, "_name"),
        DATE_TIME(HollowObjectSchema.FieldType.LONG, "value");

        private final HollowObjectSchema.FieldType schemaFieldType;
        private final String specialFieldName;

        private MappedFieldType(HollowObjectSchema.FieldType schemaFieldType) {
            this.specialFieldName = null;
            this.schemaFieldType = schemaFieldType;
        }

        private MappedFieldType(HollowObjectSchema.FieldType schemaFieldType, String specialFieldName) {
            this.schemaFieldType = schemaFieldType;
            this.specialFieldName = specialFieldName;
        }

        public String getSpecialFieldName() {
            return this.specialFieldName;
        }

        public HollowObjectSchema.FieldType getSchemaFieldType() {
            return this.schemaFieldType;
        }
    }

    private class MappedField {
        private final String fieldName;
        private final long fieldOffset;
        private final Type type;
        private final MappedFieldType fieldType;
        private final HollowTypeMapper subTypeMapper;
        private final HollowTypeName typeNameAnnotation;
        private final HollowHashKey hashKeyAnnotation;
        private final HollowShardLargeType numShardsAnnotation;
        private final boolean isInlinedField;

        private MappedField(Field f) {
            this(f, new HashSet<Type>());
        }

        private MappedField(Field f, Set<Type> visitedTypes) {
            this.fieldOffset = unsafe.objectFieldOffset(f);
            this.fieldName = f.getName();
            this.type = f.getGenericType();
            this.typeNameAnnotation = f.getAnnotation(HollowTypeName.class);
            this.hashKeyAnnotation = f.getAnnotation(HollowHashKey.class);
            this.numShardsAnnotation = f.getAnnotation(HollowShardLargeType.class);
            this.isInlinedField = f.isAnnotationPresent(HollowInline.class);
            HollowTypeMapper subTypeMapper = null;
            if (this.type == Integer.TYPE) {
                this.fieldType = MappedFieldType.INT;
            } else if (this.type == Short.TYPE) {
                this.fieldType = MappedFieldType.SHORT;
            } else if (this.type == Byte.TYPE) {
                this.fieldType = MappedFieldType.BYTE;
            } else if (this.type == Character.TYPE) {
                this.fieldType = MappedFieldType.CHAR;
            } else if (this.type == Long.TYPE) {
                this.fieldType = MappedFieldType.LONG;
            } else if (this.type == Boolean.TYPE) {
                this.fieldType = MappedFieldType.BOOLEAN;
            } else if (this.type == Float.TYPE) {
                this.fieldType = MappedFieldType.FLOAT;
            } else if (this.type == Double.TYPE) {
                this.fieldType = MappedFieldType.DOUBLE;
            } else if (this.type == byte[].class && HollowObjectTypeMapper.this.clazz == String.class) {
                this.fieldType = MappedFieldType.STRING;
            } else if (this.type == byte[].class) {
                this.fieldType = MappedFieldType.BYTES;
            } else if (this.type == char[].class) {
                this.fieldType = MappedFieldType.STRING;
            } else if (this.isInlinedField && this.type == Integer.class) {
                this.fieldType = MappedFieldType.INLINED_INT;
            } else if (this.isInlinedField && this.type == Short.class) {
                this.fieldType = MappedFieldType.INLINED_SHORT;
            } else if (this.isInlinedField && this.type == Byte.class) {
                this.fieldType = MappedFieldType.INLINED_BYTE;
            } else if (this.isInlinedField && this.type == Character.class) {
                this.fieldType = MappedFieldType.INLINED_CHAR;
            } else if (this.isInlinedField && this.type == Long.class) {
                this.fieldType = MappedFieldType.INLINED_LONG;
            } else if (this.isInlinedField && this.type == Boolean.class) {
                this.fieldType = MappedFieldType.INLINED_BOOLEAN;
            } else if (this.isInlinedField && this.type == Float.class) {
                this.fieldType = MappedFieldType.INLINED_FLOAT;
            } else if (this.isInlinedField && this.type == Double.class) {
                this.fieldType = MappedFieldType.INLINED_DOUBLE;
            } else if (this.isInlinedField && this.type == String.class) {
                this.fieldType = MappedFieldType.INLINED_STRING;
            } else if (this.type == NullablePrimitiveBoolean.class) {
                this.fieldType = MappedFieldType.NULLABLE_PRIMITIVE_BOOLEAN;
            } else {
                if (this.isInlinedField) {
                    throw new IllegalStateException("@HollowInline annotation defined on field " + f + ", which is not either a String or boxed primitive.");
                }
                this.fieldType = MappedFieldType.REFERENCE;
                if (visitedTypes.contains(this.type)) {
                    throw new IllegalStateException("circular reference detected on field " + f + "; this type of relationship is not supported");
                }
                visitedTypes.add(this.type);
                subTypeMapper = HollowObjectTypeMapper.this.parentMapper.getTypeMapper(this.type, this.typeNameAnnotation != null ? this.typeNameAnnotation.name() : null, this.hashKeyAnnotation != null ? this.hashKeyAnnotation.fields() : null, this.numShardsAnnotation != null ? this.numShardsAnnotation.numShards() : -1, visitedTypes);
                visitedTypes.remove(this.type);
            }
            this.subTypeMapper = subTypeMapper;
        }

        private MappedField(MappedFieldType specialField) {
            this.fieldOffset = -1L;
            this.type = null;
            this.typeNameAnnotation = null;
            this.hashKeyAnnotation = null;
            this.numShardsAnnotation = null;
            this.fieldName = specialField.getSpecialFieldName();
            this.fieldType = specialField;
            this.subTypeMapper = null;
            this.isInlinedField = false;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public MappedFieldType getFieldType() {
            return this.fieldType;
        }

        public String getReferencedTypeName() {
            if (this.typeNameAnnotation != null) {
                return this.typeNameAnnotation.name();
            }
            return this.subTypeMapper.getTypeName();
        }

        public void copy(Object obj, HollowObjectWriteRecord rec, FlatRecordWriter flatRecordWriter) {
            switch (this.fieldType) {
                case BOOLEAN: {
                    rec.setBoolean(this.fieldName, unsafe.getBoolean(obj, this.fieldOffset));
                    break;
                }
                case INT: {
                    rec.setInt(this.fieldName, unsafe.getInt(obj, this.fieldOffset));
                    break;
                }
                case SHORT: {
                    rec.setInt(this.fieldName, unsafe.getShort(obj, this.fieldOffset));
                    break;
                }
                case BYTE: {
                    rec.setInt(this.fieldName, unsafe.getByte(obj, this.fieldOffset));
                    break;
                }
                case CHAR: {
                    rec.setInt(this.fieldName, unsafe.getChar(obj, this.fieldOffset));
                    break;
                }
                case LONG: {
                    rec.setLong(this.fieldName, unsafe.getLong(obj, this.fieldOffset));
                    break;
                }
                case DOUBLE: {
                    double d = unsafe.getDouble(obj, this.fieldOffset);
                    if (Double.isNaN(d)) break;
                    rec.setDouble(this.fieldName, d);
                    break;
                }
                case FLOAT: {
                    float f = unsafe.getFloat(obj, this.fieldOffset);
                    if (Float.isNaN(f)) break;
                    rec.setFloat(this.fieldName, f);
                    break;
                }
                case STRING: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setString(this.fieldName, this.getStringFromField(obj, fieldObject));
                    break;
                }
                case BYTES: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setBytes(this.fieldName, (byte[])fieldObject);
                    break;
                }
                case INLINED_BOOLEAN: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setBoolean(this.fieldName, (Boolean)fieldObject);
                    break;
                }
                case INLINED_INT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, (Integer)fieldObject);
                    break;
                }
                case INLINED_SHORT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, ((Short)fieldObject).intValue());
                    break;
                }
                case INLINED_BYTE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, ((Byte)fieldObject).intValue());
                    break;
                }
                case INLINED_CHAR: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setInt(this.fieldName, ((Character)fieldObject).charValue());
                    break;
                }
                case INLINED_LONG: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setLong(this.fieldName, (Long)fieldObject);
                    break;
                }
                case INLINED_DOUBLE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setDouble(this.fieldName, (Double)fieldObject);
                    break;
                }
                case INLINED_FLOAT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setFloat(this.fieldName, ((Float)fieldObject).floatValue());
                    break;
                }
                case INLINED_STRING: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setString(this.fieldName, (String)fieldObject);
                    break;
                }
                case NULLABLE_PRIMITIVE_BOOLEAN: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    rec.setBoolean(this.fieldName, ((NullablePrimitiveBoolean)((Object)fieldObject)).getBooleanValue());
                    break;
                }
                case DATE_TIME: {
                    rec.setLong(this.fieldName, ((Date)obj).getTime());
                    break;
                }
                case ENUM_NAME: {
                    rec.setString(this.fieldName, ((Enum)obj).name());
                    break;
                }
                case REFERENCE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    if (fieldObject == null) break;
                    if (flatRecordWriter == null) {
                        rec.setReference(this.fieldName, this.subTypeMapper.write(fieldObject));
                        break;
                    }
                    rec.setReference(this.fieldName, this.subTypeMapper.writeFlat(fieldObject, flatRecordWriter));
                }
            }
        }

        public Object retrieveFieldValue(Object obj, int[] fieldPathIdx, int idx) {
            if (idx < fieldPathIdx.length - 1) {
                if (this.fieldType != MappedFieldType.REFERENCE) {
                    throw new IllegalArgumentException("Expected REFERENCE mapped field type but found " + (Object)((Object)this.fieldType));
                }
                Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                if (fieldObject == null) {
                    return null;
                }
                return ((HollowObjectTypeMapper)this.subTypeMapper).retrieveFieldValue(fieldObject, fieldPathIdx, idx + 1);
            }
            switch (this.fieldType) {
                case BOOLEAN: {
                    return unsafe.getBoolean(obj, this.fieldOffset);
                }
                case INT: {
                    return unsafe.getInt(obj, this.fieldOffset);
                }
                case SHORT: {
                    return (int)unsafe.getShort(obj, this.fieldOffset);
                }
                case BYTE: {
                    return (int)unsafe.getByte(obj, this.fieldOffset);
                }
                case CHAR: {
                    return (int)unsafe.getChar(obj, this.fieldOffset);
                }
                case LONG: {
                    return unsafe.getLong(obj, this.fieldOffset);
                }
                case DOUBLE: {
                    double d = unsafe.getDouble(obj, this.fieldOffset);
                    if (Double.isNaN(d)) {
                        return null;
                    }
                    return d;
                }
                case FLOAT: {
                    float f = unsafe.getFloat(obj, this.fieldOffset);
                    if (Float.isNaN(f)) {
                        return null;
                    }
                    return Float.valueOf(f);
                }
                case STRING: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : this.getStringFromField(obj, fieldObject);
                }
                case BYTES: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : (byte[])fieldObject;
                }
                case INLINED_BOOLEAN: 
                case INLINED_INT: 
                case INLINED_LONG: 
                case INLINED_DOUBLE: 
                case INLINED_FLOAT: 
                case INLINED_STRING: {
                    return unsafe.getObject(obj, this.fieldOffset);
                }
                case INLINED_SHORT: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Integer.valueOf(((Short)fieldObject).shortValue());
                }
                case INLINED_BYTE: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Integer.valueOf(((Byte)fieldObject).byteValue());
                }
                case INLINED_CHAR: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Integer.valueOf(((Character)fieldObject).charValue());
                }
                case NULLABLE_PRIMITIVE_BOOLEAN: {
                    Object fieldObject = unsafe.getObject(obj, this.fieldOffset);
                    return fieldObject == null ? null : Boolean.valueOf(((NullablePrimitiveBoolean)((Object)fieldObject)).getBooleanValue());
                }
                case DATE_TIME: {
                    return ((Date)obj).getTime();
                }
                case ENUM_NAME: {
                    return String.valueOf(((Enum)obj).name());
                }
            }
            throw new IllegalArgumentException("Cannot extract POJO primary key from a " + (Object)((Object)this.fieldType) + " mapped field type");
        }

        private String getStringFromField(Object obj, Object fieldObject) {
            if (obj instanceof String) {
                return (String)obj;
            }
            if (fieldObject instanceof char[]) {
                return new String((char[])fieldObject);
            }
            throw new IllegalArgumentException("Expected char[] or String value container for STRING.");
        }
    }
}

