/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write.objectmapper;

import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.objectmapper.HollowListTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowMapTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowObjectTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowSetTypeMapper;
import com.netflix.hollow.core.write.objectmapper.HollowTypeMapper;
import com.netflix.hollow.core.write.objectmapper.RecordPrimaryKey;
import com.netflix.hollow.core.write.objectmapper.flatrecords.FlatRecordWriter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class HollowObjectMapper {
    private final HollowWriteStateEngine stateEngine;
    private final ConcurrentHashMap<Type, String> typeNameMappers;
    private final ConcurrentHashMap<String, HollowTypeMapper> typeMappers;
    private AtomicInteger unassignedTypeCounter = new AtomicInteger(0);
    private boolean ignoreListOrdering = false;
    private boolean useDefaultHashKeys = true;

    public HollowObjectMapper(HollowWriteStateEngine stateEngine) {
        this.stateEngine = stateEngine;
        this.typeNameMappers = new ConcurrentHashMap();
        this.typeMappers = new ConcurrentHashMap();
    }

    public void ignoreListOrdering() {
        this.ignoreListOrdering = true;
    }

    public void useDefaultHashKeys() {
        this.useDefaultHashKeys = true;
    }

    public void doNotUseDefaultHashKeys() {
        this.useDefaultHashKeys = false;
    }

    public int add(Object o) {
        HollowTypeMapper typeMapper = this.getTypeMapper(o.getClass(), null, null);
        return typeMapper.write(o);
    }

    @Deprecated
    public void writeFlat(Object o, FlatRecordWriter flatRecordWriter) {
        HollowTypeMapper typeMapper = this.getTypeMapper(o.getClass(), null, null);
        typeMapper.writeFlat(o, flatRecordWriter);
    }

    public RecordPrimaryKey extractPrimaryKey(Object o) {
        HollowObjectTypeMapper typeMapper = (HollowObjectTypeMapper)this.getTypeMapper(o.getClass(), null, null);
        return new RecordPrimaryKey(typeMapper.getTypeName(), typeMapper.extractPrimaryKey(o));
    }

    @Deprecated
    public int addObject(Object o) {
        return this.add(o);
    }

    public void initializeTypeState(Class<?> clazz) {
        Objects.requireNonNull(clazz);
        this.getTypeMapper(clazz, null, null);
    }

    HollowTypeMapper getTypeMapper(Type type, String declaredName, String[] hashKeyFieldPaths) {
        return this.getTypeMapper(type, declaredName, hashKeyFieldPaths, -1, null);
    }

    HollowTypeMapper getTypeMapper(Type type, String declaredName, String[] hashKeyFieldPaths, int numShards, Set<Type> visited) {
        String typeName = declaredName != null ? declaredName : this.findTypeName(type);
        HollowTypeMapper typeMapper = this.typeMappers.get(typeName);
        if (typeMapper == null) {
            ParameterizedType parameterizedType;
            Class clazz;
            if (visited == null) {
                visited = new HashSet<Type>();
            }
            typeMapper = type instanceof ParameterizedType ? (List.class.isAssignableFrom(clazz = (Class)(parameterizedType = (ParameterizedType)type).getRawType()) ? new HollowListTypeMapper(this, parameterizedType, typeName, numShards, this.ignoreListOrdering, visited) : (Set.class.isAssignableFrom(clazz) ? new HollowSetTypeMapper(this, parameterizedType, typeName, hashKeyFieldPaths, numShards, this.stateEngine, this.useDefaultHashKeys, visited) : (Map.class.isAssignableFrom(clazz) ? new HollowMapTypeMapper(this, parameterizedType, typeName, hashKeyFieldPaths, numShards, this.stateEngine, this.useDefaultHashKeys, visited) : new HollowObjectTypeMapper(this, clazz, typeName, visited)))) : new HollowObjectTypeMapper(this, (Class)type, typeName, visited);
            HollowTypeMapper existing = this.typeMappers.putIfAbsent(typeName, typeMapper);
            if (existing != null) {
                typeMapper = existing;
            } else {
                typeMapper.addTypeState(this.stateEngine);
            }
        }
        return typeMapper;
    }

    private String findTypeName(Type type) {
        String typeName = this.typeNameMappers.get(type);
        if (typeName == null) {
            typeName = HollowObjectTypeMapper.getDefaultTypeName(type);
            this.typeNameMappers.putIfAbsent(type, typeName);
        }
        return typeName;
    }

    int nextUnassignedTypeId() {
        return this.unassignedTypeCounter.getAndIncrement();
    }

    public HollowWriteStateEngine getStateEngine() {
        return this.stateEngine;
    }
}

