/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.util.LongList;
import com.netflix.hollow.core.write.HollowHashableWriteRecord;

public class HollowSetWriteRecord
implements HollowHashableWriteRecord {
    private final LongList elementsAndHashes = new LongList();
    private final HollowHashableWriteRecord.HashBehavior defaultHashBehavior;

    public HollowSetWriteRecord() {
        this(HollowHashableWriteRecord.HashBehavior.MIXED_HASHES);
    }

    public HollowSetWriteRecord(HollowHashableWriteRecord.HashBehavior defaultHashBehavior) {
        this.defaultHashBehavior = defaultHashBehavior;
    }

    public void addElement(int ordinal) {
        this.addElement(ordinal, ordinal);
    }

    public void addElement(int ordinal, int hashCode) {
        long elementAndHash = (long)ordinal << 32 | (long)hashCode & 0xFFFFFFFFL;
        this.elementsAndHashes.add(elementAndHash);
    }

    @Override
    public void writeDataTo(ByteDataArray buf) {
        this.writeDataTo(buf, this.defaultHashBehavior);
    }

    @Override
    public void writeDataTo(ByteDataArray buf, HollowHashableWriteRecord.HashBehavior hashBehavior) {
        this.elementsAndHashes.sort();
        int hashTableSize = HashCodes.hashTableSize(this.elementsAndHashes.size());
        int bucketMask = hashTableSize - 1;
        VarInt.writeVInt(buf, this.elementsAndHashes.size());
        int previousOrdinal = 0;
        for (int i = 0; i < this.elementsAndHashes.size(); ++i) {
            int ordinal = (int)(this.elementsAndHashes.get(i) >>> 32);
            VarInt.writeVInt(buf, ordinal - previousOrdinal);
            if (hashBehavior != HollowHashableWriteRecord.HashBehavior.IGNORED_HASHES) {
                int hashCode = (int)this.elementsAndHashes.get(i);
                if (hashBehavior == HollowHashableWriteRecord.HashBehavior.MIXED_HASHES) {
                    hashCode = HashCodes.hashInt(hashCode);
                }
                int bucketToHashTo = hashCode & bucketMask;
                VarInt.writeVInt(buf, bucketToHashTo);
            }
            previousOrdinal = ordinal;
        }
    }

    @Override
    public void reset() {
        this.elementsAndHashes.clear();
    }
}

