/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEnginePrimaryKeyHasher;
import java.io.DataOutputStream;
import java.io.IOException;

public class HollowSetTypeWriteState
extends HollowTypeWriteState {
    private int bitsPerSetPointer;
    private int bitsPerElement;
    private int bitsPerSetSizeValue;
    private long[] totalOfSetBuckets;
    private int maxOrdinal;
    private int[] maxShardOrdinal;
    private FixedLengthElementArray[] setPointersAndSizesArray;
    private FixedLengthElementArray[] elementArray;
    private int[] numSetsInDelta;
    private long[] numBucketsInDelta;
    private ByteDataArray[] deltaAddedOrdinals;
    private ByteDataArray[] deltaRemovedOrdinals;

    public HollowSetTypeWriteState(HollowSetSchema schema) {
        this(schema, -1);
    }

    public HollowSetTypeWriteState(HollowSetSchema schema, int numShards) {
        super(schema, numShards);
    }

    @Override
    public HollowSetSchema getSchema() {
        return (HollowSetSchema)this.schema;
    }

    @Override
    public void prepareForWrite() {
        super.prepareForWrite();
        this.gatherStatistics();
    }

    private void gatherStatistics() {
        if (this.numShards == -1) {
            this.calculateNumShards();
        }
        int maxElementOrdinal = 0;
        int maxOrdinal = this.ordinalMap.maxOrdinal();
        this.maxShardOrdinal = new int[this.numShards];
        int minRecordLocationsPerShard = (maxOrdinal + 1) / this.numShards;
        for (int i = 0; i < this.numShards; ++i) {
            this.maxShardOrdinal[i] = i < (maxOrdinal + 1 & this.numShards - 1) ? minRecordLocationsPerShard : minRecordLocationsPerShard - 1;
        }
        int maxSetSize = 0;
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        this.totalOfSetBuckets = new long[this.numShards];
        for (int i = 0; i <= maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i) && !this.previousCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            int numBuckets = HashCodes.hashTableSize(size);
            if (size > maxSetSize) {
                maxSetSize = size;
            }
            pointer += (long)VarInt.sizeOfVInt(size);
            int elementOrdinal = 0;
            for (int j = 0; j < size; ++j) {
                int elementOrdinalDelta = VarInt.readVInt(data, pointer);
                if ((elementOrdinal += elementOrdinalDelta) > maxElementOrdinal) {
                    maxElementOrdinal = elementOrdinal;
                }
                pointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta);
                pointer += (long)VarInt.nextVLongSize(data, pointer);
            }
            int n = i & this.numShards - 1;
            this.totalOfSetBuckets[n] = this.totalOfSetBuckets[n] + (long)numBuckets;
        }
        long maxShardTotalOfSetBuckets = 0L;
        for (int i = 0; i < this.numShards; ++i) {
            if (this.totalOfSetBuckets[i] <= maxShardTotalOfSetBuckets) continue;
            maxShardTotalOfSetBuckets = this.totalOfSetBuckets[i];
        }
        this.bitsPerElement = 64 - Long.numberOfLeadingZeros(maxElementOrdinal + 1);
        this.bitsPerSetSizeValue = 64 - Long.numberOfLeadingZeros(maxSetSize);
        this.bitsPerSetPointer = 64 - Long.numberOfLeadingZeros(maxShardTotalOfSetBuckets);
    }

    private void calculateNumShards() {
        int maxOrdinal = this.ordinalMap.maxOrdinal();
        int maxSetSize = 0;
        int maxElementOrdinal = 0;
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        long totalOfSetBuckets = 0L;
        for (int i = 0; i <= maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            int numBuckets = HashCodes.hashTableSize(size);
            if (size > maxSetSize) {
                maxSetSize = size;
            }
            pointer += (long)VarInt.sizeOfVInt(size);
            int elementOrdinal = 0;
            for (int j = 0; j < size; ++j) {
                int elementOrdinalDelta = VarInt.readVInt(data, pointer);
                if ((elementOrdinal += elementOrdinalDelta) > maxElementOrdinal) {
                    maxElementOrdinal = elementOrdinal;
                }
                pointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta);
                pointer += (long)VarInt.nextVLongSize(data, pointer);
            }
            totalOfSetBuckets += (long)numBuckets;
        }
        long bitsPerElement = 64 - Long.numberOfLeadingZeros(maxElementOrdinal + 1);
        long bitsPerSetSizeValue = 64 - Long.numberOfLeadingZeros(maxSetSize);
        long bitsPerSetPointer = 64 - Long.numberOfLeadingZeros(totalOfSetBuckets);
        long projectedSizeOfType = (bitsPerSetSizeValue + bitsPerSetPointer) * (long)(maxOrdinal + 1) / 8L;
        projectedSizeOfType += bitsPerElement * totalOfSetBuckets / 8L;
        this.numShards = 1;
        while (this.stateEngine.getTargetMaxTypeShardSize() * (long)this.numShards < projectedSizeOfType) {
            this.numShards *= 2;
        }
    }

    @Override
    public void calculateSnapshot() {
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + this.bitsPerSetPointer;
        this.setPointersAndSizesArray = new FixedLengthElementArray[this.numShards];
        this.elementArray = new FixedLengthElementArray[this.numShards];
        for (int i = 0; i < this.numShards; ++i) {
            this.setPointersAndSizesArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)bitsPerSetFixedLengthPortion * (long)(this.maxShardOrdinal[i] + 1));
            this.elementArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.bitsPerElement * this.totalOfSetBuckets[i]);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        int[] bucketCounter = new int[this.numShards];
        int shardMask = this.numShards - 1;
        HollowWriteStateEnginePrimaryKeyHasher primaryKeyHasher = null;
        if (this.getSchema().getHashKey() != null) {
            primaryKeyHasher = new HollowWriteStateEnginePrimaryKeyHasher(this.getSchema().getHashKey(), this.getStateEngine());
        }
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            int shardOrdinal = ordinal / this.numShards;
            if (this.currentCyclePopulated.get(ordinal)) {
                int j;
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                int numBuckets = HashCodes.hashTableSize(size);
                this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)shardOrdinal + (long)this.bitsPerSetPointer, this.bitsPerSetSizeValue, size);
                int elementOrdinal = 0;
                for (j = 0; j < numBuckets; ++j) {
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + j), this.bitsPerElement, (1L << this.bitsPerElement) - 1L);
                }
                for (j = 0; j < size; ++j) {
                    int elementOrdinalDelta = VarInt.readVInt(data, readPointer);
                    int hashedBucket = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta));
                    readPointer += (long)VarInt.sizeOfVInt(hashedBucket);
                    elementOrdinal += elementOrdinalDelta;
                    if (primaryKeyHasher != null) {
                        hashedBucket = primaryKeyHasher.getRecordHash(elementOrdinal) & numBuckets - 1;
                    }
                    while (this.elementArray[shardNumber].getElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + hashedBucket), this.bitsPerElement) != (1L << this.bitsPerElement) - 1L) {
                        ++hashedBucket;
                        hashedBucket &= numBuckets - 1;
                    }
                    this.elementArray[shardNumber].clearElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + hashedBucket), this.bitsPerElement);
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (long)(bucketCounter[shardNumber] + hashedBucket), this.bitsPerElement, elementOrdinal);
                }
                int n = shardNumber;
                bucketCounter[n] = bucketCounter[n] + numBuckets;
            }
            this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)shardOrdinal, this.bitsPerSetPointer, bucketCounter[shardNumber]);
        }
    }

    @Override
    public void writeSnapshot(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeSnapshotShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeSnapshotShard(os, i);
            }
        }
        this.currentCyclePopulated.serializeBitsTo(os);
        this.setPointersAndSizesArray = null;
        this.elementArray = null;
    }

    private void writeSnapshotShard(DataOutputStream os, int shardNumber) throws IOException {
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + this.bitsPerSetPointer;
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        VarInt.writeVInt(os, this.bitsPerSetPointer);
        VarInt.writeVInt(os, this.bitsPerSetSizeValue);
        VarInt.writeVInt(os, this.bitsPerElement);
        VarInt.writeVLong(os, this.totalOfSetBuckets[shardNumber]);
        int numSetFixedLengthLongs = this.maxShardOrdinal[shardNumber] == -1 ? 0 : (int)(((long)(this.maxShardOrdinal[shardNumber] + 1) * (long)bitsPerSetFixedLengthPortion - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numSetFixedLengthLongs);
        for (int i = 0; i < numSetFixedLengthLongs; ++i) {
            os.writeLong(this.setPointersAndSizesArray[shardNumber].get(i));
        }
        int numElementLongs = this.totalOfSetBuckets[shardNumber] == 0L ? 0 : (int)((this.totalOfSetBuckets[shardNumber] * (long)this.bitsPerElement - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.elementArray[shardNumber].get(i));
        }
    }

    @Override
    public void calculateDelta() {
        this.calculateDelta(this.previousCyclePopulated, this.currentCyclePopulated);
    }

    @Override
    public void writeDelta(DataOutputStream dos) throws IOException {
        this.writeCalculatedDelta(dos);
    }

    @Override
    public void calculateReverseDelta() {
        this.calculateDelta(this.currentCyclePopulated, this.previousCyclePopulated);
    }

    @Override
    public void writeReverseDelta(DataOutputStream dos) throws IOException {
        this.writeCalculatedDelta(dos);
    }

    public void calculateDelta(ThreadSafeBitSet fromCyclePopulated, ThreadSafeBitSet toCyclePopulated) {
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + this.bitsPerSetPointer;
        this.numSetsInDelta = new int[this.numShards];
        this.numBucketsInDelta = new long[this.numShards];
        this.setPointersAndSizesArray = new FixedLengthElementArray[this.numShards];
        this.elementArray = new FixedLengthElementArray[this.numShards];
        this.deltaAddedOrdinals = new ByteDataArray[this.numShards];
        this.deltaRemovedOrdinals = new ByteDataArray[this.numShards];
        ThreadSafeBitSet deltaAdditions = toCyclePopulated.andNot(fromCyclePopulated);
        int shardMask = this.numShards - 1;
        int addedOrdinal = deltaAdditions.nextSetBit(0);
        while (addedOrdinal != -1) {
            int n = addedOrdinal & shardMask;
            this.numSetsInDelta[n] = this.numSetsInDelta[n] + 1;
            long readPointer = this.ordinalMap.getPointerForData(addedOrdinal);
            int size = VarInt.readVInt(this.ordinalMap.getByteData().getUnderlyingArray(), readPointer);
            int n2 = addedOrdinal & shardMask;
            this.numBucketsInDelta[n2] = this.numBucketsInDelta[n2] + (long)HashCodes.hashTableSize(size);
            addedOrdinal = deltaAdditions.nextSetBit(addedOrdinal + 1);
        }
        for (int i = 0; i < this.numShards; ++i) {
            this.setPointersAndSizesArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.numSetsInDelta[i] * (long)bitsPerSetFixedLengthPortion);
            this.elementArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, this.numBucketsInDelta[i] * (long)this.bitsPerElement);
            this.deltaAddedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            this.deltaRemovedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        int[] setCounter = new int[this.numShards];
        long[] bucketCounter = new long[this.numShards];
        int[] previousRemovedOrdinal = new int[this.numShards];
        int[] previousAddedOrdinal = new int[this.numShards];
        HollowWriteStateEnginePrimaryKeyHasher primaryKeyHasher = null;
        if (this.getSchema().getHashKey() != null) {
            primaryKeyHasher = new HollowWriteStateEnginePrimaryKeyHasher(this.getSchema().getHashKey(), this.getStateEngine());
        }
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            if (deltaAdditions.get(ordinal)) {
                int j;
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                int numBuckets = HashCodes.hashTableSize(size);
                long endBucketPosition = bucketCounter[shardNumber] + (long)numBuckets;
                this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)setCounter[shardNumber], this.bitsPerSetPointer, endBucketPosition);
                this.setPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerSetFixedLengthPortion * (long)setCounter[shardNumber] + (long)this.bitsPerSetPointer, this.bitsPerSetSizeValue, size);
                int elementOrdinal = 0;
                for (j = 0; j < numBuckets; ++j) {
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)j), this.bitsPerElement, (1L << this.bitsPerElement) - 1L);
                }
                for (j = 0; j < size; ++j) {
                    int elementOrdinalDelta = VarInt.readVInt(data, readPointer);
                    int hashedBucket = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(elementOrdinalDelta));
                    readPointer += (long)VarInt.sizeOfVInt(hashedBucket);
                    elementOrdinal += elementOrdinalDelta;
                    if (primaryKeyHasher != null) {
                        hashedBucket = primaryKeyHasher.getRecordHash(elementOrdinal) & numBuckets - 1;
                    }
                    while (this.elementArray[shardNumber].getElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)hashedBucket), this.bitsPerElement) != (1L << this.bitsPerElement) - 1L) {
                        ++hashedBucket;
                        hashedBucket &= numBuckets - 1;
                    }
                    this.elementArray[shardNumber].clearElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)hashedBucket), this.bitsPerElement);
                    this.elementArray[shardNumber].setElementValue((long)this.bitsPerElement * (bucketCounter[shardNumber] + (long)hashedBucket), this.bitsPerElement, elementOrdinal);
                }
                int n = shardNumber;
                bucketCounter[n] = bucketCounter[n] + (long)numBuckets;
                int n3 = shardNumber;
                setCounter[n3] = setCounter[n3] + 1;
                int shardOrdinal = ordinal / this.numShards;
                VarInt.writeVInt(this.deltaAddedOrdinals[shardNumber], shardOrdinal - previousAddedOrdinal[shardNumber]);
                previousAddedOrdinal[shardNumber] = shardOrdinal;
                continue;
            }
            if (!fromCyclePopulated.get(ordinal) || toCyclePopulated.get(ordinal)) continue;
            int shardOrdinal = ordinal / this.numShards;
            VarInt.writeVInt(this.deltaRemovedOrdinals[shardNumber], shardOrdinal - previousRemovedOrdinal[shardNumber]);
            previousRemovedOrdinal[shardNumber] = shardOrdinal;
        }
    }

    private void writeCalculatedDelta(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeCalculatedDeltaShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeCalculatedDeltaShard(os, i);
            }
        }
        this.setPointersAndSizesArray = null;
        this.elementArray = null;
        this.deltaAddedOrdinals = null;
        this.deltaRemovedOrdinals = null;
    }

    private void writeCalculatedDeltaShard(DataOutputStream os, int shardNumber) throws IOException {
        int bitsPerSetFixedLengthPortion = this.bitsPerSetSizeValue + this.bitsPerSetPointer;
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        VarInt.writeVLong(os, this.deltaRemovedOrdinals[shardNumber].length());
        this.deltaRemovedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaRemovedOrdinals[shardNumber].length());
        VarInt.writeVLong(os, this.deltaAddedOrdinals[shardNumber].length());
        this.deltaAddedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaAddedOrdinals[shardNumber].length());
        VarInt.writeVInt(os, this.bitsPerSetPointer);
        VarInt.writeVInt(os, this.bitsPerSetSizeValue);
        VarInt.writeVInt(os, this.bitsPerElement);
        VarInt.writeVLong(os, this.totalOfSetBuckets[shardNumber]);
        int numSetFixedLengthLongs = this.numSetsInDelta[shardNumber] == 0 ? 0 : (int)(((long)this.numSetsInDelta[shardNumber] * (long)bitsPerSetFixedLengthPortion - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numSetFixedLengthLongs);
        for (int i = 0; i < numSetFixedLengthLongs; ++i) {
            os.writeLong(this.setPointersAndSizesArray[shardNumber].get(i));
        }
        int numElementLongs = this.numBucketsInDelta[shardNumber] == 0L ? 0 : (int)((this.numBucketsInDelta[shardNumber] * (long)this.bitsPerElement - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.elementArray[shardNumber].get(i));
        }
    }
}

