/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteData;
import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.write.FieldStatistics;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import java.io.DataOutputStream;
import java.io.IOException;

public class HollowObjectTypeWriteState
extends HollowTypeWriteState {
    private FieldStatistics fieldStats;
    private int maxOrdinal;
    private int[] maxShardOrdinal;
    private FixedLengthElementArray[] fixedLengthLongArray;
    private ByteDataArray[][] varLengthByteArrays;
    private long[] recordBitOffset;
    private ByteDataArray[] deltaAddedOrdinals;
    private ByteDataArray[] deltaRemovedOrdinals;

    public HollowObjectTypeWriteState(HollowObjectSchema schema) {
        this(schema, -1);
    }

    public HollowObjectTypeWriteState(HollowObjectSchema schema, int numShards) {
        super(schema, numShards);
    }

    @Override
    public HollowObjectSchema getSchema() {
        return (HollowObjectSchema)this.schema;
    }

    @Override
    public void prepareForWrite() {
        super.prepareForWrite();
        this.fieldStats = new FieldStatistics(this.getSchema());
        int maxOrdinal = this.ordinalMap.maxOrdinal();
        for (int i = 0; i <= maxOrdinal; ++i) {
            this.discoverObjectFieldStatisticsForRecord(this.fieldStats, i);
        }
        this.fieldStats.completeCalculations();
        if (this.numShards == -1) {
            long projectedSizeOfType = (long)this.fieldStats.getNumBitsPerRecord() * (long)(maxOrdinal + 1) / 8L;
            projectedSizeOfType += this.fieldStats.getTotalSizeOfAllVarLengthData();
            this.numShards = 1;
            while (this.stateEngine.getTargetMaxTypeShardSize() * (long)this.numShards < projectedSizeOfType) {
                this.numShards *= 2;
            }
        }
        this.maxShardOrdinal = new int[this.numShards];
        int minRecordLocationsPerShard = (maxOrdinal + 1) / this.numShards;
        for (int i = 0; i < this.numShards; ++i) {
            this.maxShardOrdinal[i] = i < (maxOrdinal + 1 & this.numShards - 1) ? minRecordLocationsPerShard : minRecordLocationsPerShard - 1;
        }
    }

    private void discoverObjectFieldStatisticsForRecord(FieldStatistics fieldStats, int ordinal) {
        if (this.currentCyclePopulated.get(ordinal) || this.previousCyclePopulated.get(ordinal)) {
            long pointer = this.ordinalMap.getPointerForData(ordinal);
            for (int fieldIndex = 0; fieldIndex < ((HollowObjectSchema)this.schema).numFields(); ++fieldIndex) {
                pointer = this.discoverObjectFieldStatisticsForField(fieldStats, pointer, fieldIndex);
            }
        }
    }

    private long discoverObjectFieldStatisticsForField(FieldStatistics fieldStats, long pointer, int fieldIndex) {
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        switch (this.getSchema().getFieldType(fieldIndex)) {
            case BOOLEAN: {
                this.addFixedLengthFieldRequiredBits(fieldStats, fieldIndex, 2);
                ++pointer;
                break;
            }
            case FLOAT: {
                this.addFixedLengthFieldRequiredBits(fieldStats, fieldIndex, 32);
                pointer += 4L;
                break;
            }
            case DOUBLE: {
                this.addFixedLengthFieldRequiredBits(fieldStats, fieldIndex, 64);
                pointer += 8L;
                break;
            }
            case LONG: 
            case INT: 
            case REFERENCE: {
                if (VarInt.readVNull(data, pointer)) {
                    this.addFixedLengthFieldRequiredBits(fieldStats, fieldIndex, 1);
                    ++pointer;
                    break;
                }
                long vLong = VarInt.readVLong(data, pointer);
                int requiredBitsForFieldValue = 64 - Long.numberOfLeadingZeros(vLong + 1L);
                this.addFixedLengthFieldRequiredBits(fieldStats, fieldIndex, requiredBitsForFieldValue);
                pointer += (long)VarInt.sizeOfVLong(vLong);
                break;
            }
            case BYTES: 
            case STRING: {
                if (VarInt.readVNull(data, pointer)) {
                    this.addFixedLengthFieldRequiredBits(fieldStats, fieldIndex, 1);
                    ++pointer;
                    break;
                }
                int length = VarInt.readVInt(data, pointer);
                this.addVarLengthFieldSizeInBytes(fieldStats, fieldIndex, length);
                pointer += (long)(length + VarInt.sizeOfVInt(length));
            }
        }
        return pointer;
    }

    private void addFixedLengthFieldRequiredBits(FieldStatistics fieldStats, int fieldIndex, int numBits) {
        fieldStats.addFixedLengthFieldRequiredBits(fieldIndex, numBits);
    }

    private void addVarLengthFieldSizeInBytes(FieldStatistics fieldStats, int fieldIndex, int numBytes) {
        fieldStats.addVarLengthFieldSize(fieldIndex, numBytes);
    }

    @Override
    public void prepareForNextCycle() {
        super.prepareForNextCycle();
        this.fieldStats = null;
    }

    @Override
    public void calculateSnapshot() {
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        int numBitsPerRecord = this.fieldStats.getNumBitsPerRecord();
        this.fixedLengthLongArray = new FixedLengthElementArray[this.numShards];
        this.varLengthByteArrays = new ByteDataArray[this.numShards][];
        this.recordBitOffset = new long[this.numShards];
        for (int i = 0; i < this.numShards; ++i) {
            this.fixedLengthLongArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)numBitsPerRecord * (long)(this.maxShardOrdinal[i] + 1));
            this.varLengthByteArrays[i] = new ByteDataArray[this.getSchema().numFields()];
        }
        int shardMask = this.numShards - 1;
        for (int i = 0; i <= this.maxOrdinal; ++i) {
            int shardNumber = i & shardMask;
            if (this.currentCyclePopulated.get(i)) {
                this.addRecord(i, this.recordBitOffset[shardNumber], this.fixedLengthLongArray[shardNumber], this.varLengthByteArrays[shardNumber]);
            } else {
                this.addNullRecord(i, this.recordBitOffset[shardNumber], this.fixedLengthLongArray[shardNumber], this.varLengthByteArrays[shardNumber]);
            }
            int n = shardNumber;
            this.recordBitOffset[n] = this.recordBitOffset[n] + (long)numBitsPerRecord;
        }
    }

    @Override
    public void writeSnapshot(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeSnapshotShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeSnapshotShard(os, i);
            }
        }
        this.currentCyclePopulated.serializeBitsTo(os);
        this.fixedLengthLongArray = null;
        this.varLengthByteArrays = null;
        this.recordBitOffset = null;
    }

    private void writeSnapshotShard(DataOutputStream os, int shardNumber) throws IOException {
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        for (int i = 0; i < this.getSchema().numFields(); ++i) {
            VarInt.writeVInt(os, this.fieldStats.getMaxBitsForField(i));
        }
        long numBitsRequired = this.recordBitOffset[shardNumber];
        long numLongsRequired = this.recordBitOffset[shardNumber] == 0L ? 0L : (numBitsRequired - 1L) / 64L + 1L;
        this.fixedLengthLongArray[shardNumber].writeTo(os, numLongsRequired);
        for (int i = 0; i < this.varLengthByteArrays[shardNumber].length; ++i) {
            if (this.varLengthByteArrays[shardNumber][i] == null) {
                VarInt.writeVLong(os, 0L);
                continue;
            }
            VarInt.writeVLong(os, this.varLengthByteArrays[shardNumber][i].length());
            this.varLengthByteArrays[shardNumber][i].getUnderlyingArray().writeTo(os, 0L, this.varLengthByteArrays[shardNumber][i].length());
        }
    }

    @Override
    public void calculateDelta() {
        this.calculateDelta(this.previousCyclePopulated, this.currentCyclePopulated);
    }

    @Override
    public void writeDelta(DataOutputStream dos) throws IOException {
        this.writeCalculatedDelta(dos);
    }

    @Override
    public void calculateReverseDelta() {
        this.calculateDelta(this.currentCyclePopulated, this.previousCyclePopulated);
    }

    @Override
    public void writeReverseDelta(DataOutputStream dos) throws IOException {
        this.writeCalculatedDelta(dos);
    }

    private void calculateDelta(ThreadSafeBitSet fromCyclePopulated, ThreadSafeBitSet toCyclePopulated) {
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        int numBitsPerRecord = this.fieldStats.getNumBitsPerRecord();
        ThreadSafeBitSet deltaAdditions = toCyclePopulated.andNot(fromCyclePopulated);
        this.fixedLengthLongArray = new FixedLengthElementArray[this.numShards];
        this.deltaAddedOrdinals = new ByteDataArray[this.numShards];
        this.deltaRemovedOrdinals = new ByteDataArray[this.numShards];
        this.varLengthByteArrays = new ByteDataArray[this.numShards][];
        this.recordBitOffset = new long[this.numShards];
        int[] numAddedRecordsInShard = new int[this.numShards];
        int shardMask = this.numShards - 1;
        int addedOrdinal = deltaAdditions.nextSetBit(0);
        while (addedOrdinal != -1) {
            int n = addedOrdinal & shardMask;
            numAddedRecordsInShard[n] = numAddedRecordsInShard[n] + 1;
            addedOrdinal = deltaAdditions.nextSetBit(addedOrdinal + 1);
        }
        for (int i = 0; i < this.numShards; ++i) {
            this.fixedLengthLongArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)numAddedRecordsInShard[i] * (long)numBitsPerRecord);
            this.deltaAddedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            this.deltaRemovedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            this.varLengthByteArrays[i] = new ByteDataArray[this.getSchema().numFields()];
        }
        int[] previousRemovedOrdinal = new int[this.numShards];
        int[] previousAddedOrdinal = new int[this.numShards];
        for (int i = 0; i <= this.maxOrdinal; ++i) {
            int shardOrdinal;
            int shardNumber = i & shardMask;
            if (deltaAdditions.get(i)) {
                this.addRecord(i, this.recordBitOffset[shardNumber], this.fixedLengthLongArray[shardNumber], this.varLengthByteArrays[shardNumber]);
                int n = shardNumber;
                this.recordBitOffset[n] = this.recordBitOffset[n] + (long)numBitsPerRecord;
                shardOrdinal = i / this.numShards;
                VarInt.writeVInt(this.deltaAddedOrdinals[shardNumber], shardOrdinal - previousAddedOrdinal[shardNumber]);
                previousAddedOrdinal[shardNumber] = shardOrdinal;
                continue;
            }
            if (!fromCyclePopulated.get(i) || toCyclePopulated.get(i)) continue;
            shardOrdinal = i / this.numShards;
            VarInt.writeVInt(this.deltaRemovedOrdinals[shardNumber], shardOrdinal - previousRemovedOrdinal[shardNumber]);
            previousRemovedOrdinal[shardNumber] = shardOrdinal;
        }
    }

    private void writeCalculatedDelta(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeCalculatedDeltaShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeCalculatedDeltaShard(os, i);
            }
        }
        this.fixedLengthLongArray = null;
        this.varLengthByteArrays = null;
        this.deltaAddedOrdinals = null;
        this.deltaRemovedOrdinals = null;
        this.recordBitOffset = null;
    }

    private void writeCalculatedDeltaShard(DataOutputStream os, int shardNumber) throws IOException {
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        VarInt.writeVLong(os, this.deltaRemovedOrdinals[shardNumber].length());
        this.deltaRemovedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaRemovedOrdinals[shardNumber].length());
        VarInt.writeVLong(os, this.deltaAddedOrdinals[shardNumber].length());
        this.deltaAddedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaAddedOrdinals[shardNumber].length());
        for (int i = 0; i < this.getSchema().numFields(); ++i) {
            VarInt.writeVInt(os, this.fieldStats.getMaxBitsForField(i));
        }
        long numBitsRequired = this.recordBitOffset[shardNumber];
        long numLongsRequired = numBitsRequired == 0L ? 0L : (numBitsRequired - 1L) / 64L + 1L;
        this.fixedLengthLongArray[shardNumber].writeTo(os, numLongsRequired);
        for (int i = 0; i < this.varLengthByteArrays[shardNumber].length; ++i) {
            if (this.varLengthByteArrays[shardNumber][i] == null) {
                VarInt.writeVLong(os, 0L);
                continue;
            }
            VarInt.writeVLong(os, this.varLengthByteArrays[shardNumber][i].length());
            this.varLengthByteArrays[shardNumber][i].getUnderlyingArray().writeTo(os, 0L, this.varLengthByteArrays[shardNumber][i].length());
        }
    }

    private void addNullRecord(int ordinal, long recordBitOffset, FixedLengthElementArray fixedLengthLongArray, ByteDataArray[] varLengthByteArrays) {
        for (int fieldIndex = 0; fieldIndex < this.getSchema().numFields(); ++fieldIndex) {
            if (this.getSchema().getFieldType(fieldIndex) != HollowObjectSchema.FieldType.STRING && this.getSchema().getFieldType(fieldIndex) != HollowObjectSchema.FieldType.BYTES) continue;
            long fieldBitOffset = recordBitOffset + (long)this.fieldStats.getFieldBitOffset(fieldIndex);
            int bitsPerElement = this.fieldStats.getMaxBitsForField(fieldIndex);
            long currentPointer = varLengthByteArrays[fieldIndex] == null ? 0L : varLengthByteArrays[fieldIndex].length();
            fixedLengthLongArray.setElementValue(fieldBitOffset, bitsPerElement, currentPointer);
        }
    }

    private void addRecord(int ordinal, long recordBitOffset, FixedLengthElementArray fixedLengthLongArray, ByteDataArray[] varLengthByteArrays) {
        long pointer = this.ordinalMap.getPointerForData(ordinal);
        for (int fieldIndex = 0; fieldIndex < this.getSchema().numFields(); ++fieldIndex) {
            pointer = this.addRecordField(pointer, recordBitOffset, fieldIndex, fixedLengthLongArray, varLengthByteArrays);
        }
    }

    private long addRecordField(long readPointer, long recordBitOffset, int fieldIndex, FixedLengthElementArray fixedLengthLongArray, ByteDataArray[] varLengthByteArrays) {
        HollowObjectSchema.FieldType fieldType = this.getSchema().getFieldType(fieldIndex);
        long fieldBitOffset = recordBitOffset + (long)this.fieldStats.getFieldBitOffset(fieldIndex);
        int bitsPerElement = this.fieldStats.getMaxBitsForField(fieldIndex);
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        switch (fieldType) {
            case BOOLEAN: {
                if (VarInt.readVNull(data, readPointer)) {
                    fixedLengthLongArray.setElementValue(fieldBitOffset, 2, 3L);
                } else {
                    fixedLengthLongArray.setElementValue(fieldBitOffset, 2, data.get(readPointer));
                }
                ++readPointer;
                break;
            }
            case FLOAT: {
                long intValue = (long)data.readIntBits(readPointer) & 0xFFFFFFFFL;
                fixedLengthLongArray.setElementValue(fieldBitOffset, 32, intValue);
                readPointer += 4L;
                break;
            }
            case DOUBLE: {
                long longValue = data.readLongBits(readPointer);
                fixedLengthLongArray.setElementValue(fieldBitOffset, 64, longValue);
                readPointer += 8L;
                break;
            }
            case LONG: 
            case INT: 
            case REFERENCE: {
                if (VarInt.readVNull(data, readPointer)) {
                    fixedLengthLongArray.setElementValue(fieldBitOffset, bitsPerElement, this.fieldStats.getNullValueForField(fieldIndex));
                    ++readPointer;
                    break;
                }
                long vLong = VarInt.readVLong(data, readPointer);
                fixedLengthLongArray.setElementValue(fieldBitOffset, bitsPerElement, vLong);
                readPointer += (long)VarInt.sizeOfVLong(vLong);
                break;
            }
            case BYTES: 
            case STRING: {
                ByteDataArray varLengthBuf = this.getByteArray(varLengthByteArrays, fieldIndex);
                if (VarInt.readVNull(data, readPointer)) {
                    long offset = varLengthBuf.length();
                    fixedLengthLongArray.setElementValue(fieldBitOffset, bitsPerElement, offset | 1L << bitsPerElement - 1);
                    ++readPointer;
                    break;
                }
                int length = VarInt.readVInt(data, readPointer);
                varLengthBuf.copyFrom((ByteData)data, readPointer += (long)VarInt.sizeOfVInt(length), length);
                long offset = varLengthBuf.length();
                fixedLengthLongArray.setElementValue(fieldBitOffset, bitsPerElement, offset);
                readPointer += (long)length;
            }
        }
        return readPointer;
    }

    private ByteDataArray getByteArray(ByteDataArray[] buffers, int index) {
        if (buffers[index] == null) {
            buffers[index] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
        }
        return buffers[index];
    }
}

