/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.memory.ByteDataArray;
import com.netflix.hollow.core.memory.SegmentedByteArray;
import com.netflix.hollow.core.memory.ThreadSafeBitSet;
import com.netflix.hollow.core.memory.encoding.FixedLengthElementArray;
import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.memory.pool.WastefulRecycler;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEnginePrimaryKeyHasher;
import java.io.DataOutputStream;
import java.io.IOException;

public class HollowMapTypeWriteState
extends HollowTypeWriteState {
    private int bitsPerMapPointer;
    private int bitsPerMapSizeValue;
    private int bitsPerKeyElement;
    private int bitsPerValueElement;
    private long[] totalOfMapBuckets;
    private int maxOrdinal;
    private int[] maxShardOrdinal;
    private FixedLengthElementArray[] mapPointersAndSizesArray;
    private FixedLengthElementArray[] entryData;
    private int[] numMapsInDelta;
    private long[] numBucketsInDelta;
    private ByteDataArray[] deltaAddedOrdinals;
    private ByteDataArray[] deltaRemovedOrdinals;

    public HollowMapTypeWriteState(HollowMapSchema schema) {
        this(schema, -1);
    }

    public HollowMapTypeWriteState(HollowMapSchema schema, int numShards) {
        super(schema, numShards);
    }

    @Override
    public HollowMapSchema getSchema() {
        return (HollowMapSchema)this.schema;
    }

    @Override
    public void prepareForWrite() {
        super.prepareForWrite();
        this.gatherStatistics();
    }

    private void gatherStatistics() {
        if (this.numShards == -1) {
            this.calculateNumShards();
        }
        int maxKeyOrdinal = 0;
        int maxValueOrdinal = 0;
        int maxOrdinal = this.ordinalMap.maxOrdinal();
        this.maxShardOrdinal = new int[this.numShards];
        int minRecordLocationsPerShard = (maxOrdinal + 1) / this.numShards;
        for (int i = 0; i < this.numShards; ++i) {
            this.maxShardOrdinal[i] = i < (maxOrdinal + 1 & this.numShards - 1) ? minRecordLocationsPerShard : minRecordLocationsPerShard - 1;
        }
        int maxMapSize = 0;
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        this.totalOfMapBuckets = new long[this.numShards];
        for (int i = 0; i <= maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i) && !this.previousCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            int numBuckets = HashCodes.hashTableSize(size);
            if (size > maxMapSize) {
                maxMapSize = size;
            }
            pointer += (long)VarInt.sizeOfVInt(size);
            int keyOrdinal = 0;
            for (int j = 0; j < size; ++j) {
                int keyOrdinalDelta = VarInt.readVInt(data, pointer);
                int valueOrdinal = VarInt.readVInt(data, pointer += (long)VarInt.sizeOfVInt(keyOrdinalDelta));
                pointer += (long)VarInt.sizeOfVInt(valueOrdinal);
                if ((keyOrdinal += keyOrdinalDelta) > maxKeyOrdinal) {
                    maxKeyOrdinal = keyOrdinal;
                }
                if (valueOrdinal > maxValueOrdinal) {
                    maxValueOrdinal = valueOrdinal;
                }
                pointer += (long)VarInt.nextVLongSize(data, pointer);
            }
            int n = i & this.numShards - 1;
            this.totalOfMapBuckets[n] = this.totalOfMapBuckets[n] + (long)numBuckets;
        }
        long maxShardTotalOfMapBuckets = 0L;
        for (int i = 0; i < this.numShards; ++i) {
            if (this.totalOfMapBuckets[i] <= maxShardTotalOfMapBuckets) continue;
            maxShardTotalOfMapBuckets = this.totalOfMapBuckets[i];
        }
        this.bitsPerKeyElement = 64 - Long.numberOfLeadingZeros(maxKeyOrdinal + 1);
        this.bitsPerValueElement = 64 - Long.numberOfLeadingZeros(maxValueOrdinal);
        this.bitsPerMapSizeValue = 64 - Long.numberOfLeadingZeros(maxMapSize);
        this.bitsPerMapPointer = 64 - Long.numberOfLeadingZeros(maxShardTotalOfMapBuckets);
    }

    private void calculateNumShards() {
        int maxKeyOrdinal = 0;
        int maxValueOrdinal = 0;
        int maxOrdinal = this.ordinalMap.maxOrdinal();
        int maxMapSize = 0;
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        long totalOfMapBuckets = 0L;
        for (int i = 0; i <= maxOrdinal; ++i) {
            if (!this.currentCyclePopulated.get(i)) continue;
            long pointer = this.ordinalMap.getPointerForData(i);
            int size = VarInt.readVInt(data, pointer);
            int numBuckets = HashCodes.hashTableSize(size);
            if (size > maxMapSize) {
                maxMapSize = size;
            }
            pointer += (long)VarInt.sizeOfVInt(size);
            int keyOrdinal = 0;
            for (int j = 0; j < size; ++j) {
                int keyOrdinalDelta = VarInt.readVInt(data, pointer);
                int valueOrdinal = VarInt.readVInt(data, pointer += (long)VarInt.sizeOfVInt(keyOrdinalDelta));
                pointer += (long)VarInt.sizeOfVInt(valueOrdinal);
                if ((keyOrdinal += keyOrdinalDelta) > maxKeyOrdinal) {
                    maxKeyOrdinal = keyOrdinal;
                }
                if (valueOrdinal > maxValueOrdinal) {
                    maxValueOrdinal = valueOrdinal;
                }
                pointer += (long)VarInt.nextVLongSize(data, pointer);
            }
            totalOfMapBuckets += (long)numBuckets;
        }
        long bitsPerKeyElement = 64 - Long.numberOfLeadingZeros(maxKeyOrdinal + 1);
        long bitsPerValueElement = 64 - Long.numberOfLeadingZeros(maxValueOrdinal);
        long bitsPerMapSizeValue = 64 - Long.numberOfLeadingZeros(maxMapSize);
        long bitsPerMapPointer = 64 - Long.numberOfLeadingZeros(totalOfMapBuckets);
        long projectedSizeOfType = (bitsPerMapSizeValue + bitsPerMapPointer) * (long)(maxOrdinal + 1) / 8L;
        projectedSizeOfType += (bitsPerKeyElement + bitsPerValueElement) * totalOfMapBuckets / 8L;
        this.numShards = 1;
        while (this.stateEngine.getTargetMaxTypeShardSize() * (long)this.numShards < projectedSizeOfType) {
            this.numShards *= 2;
        }
    }

    @Override
    public void calculateSnapshot() {
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        int bitsPerMapFixedLengthPortion = this.bitsPerMapSizeValue + this.bitsPerMapPointer;
        int bitsPerMapEntry = this.bitsPerKeyElement + this.bitsPerValueElement;
        this.mapPointersAndSizesArray = new FixedLengthElementArray[this.numShards];
        this.entryData = new FixedLengthElementArray[this.numShards];
        for (int i = 0; i < this.numShards; ++i) {
            this.mapPointersAndSizesArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)bitsPerMapFixedLengthPortion * (long)(this.maxShardOrdinal[i] + 1));
            this.entryData[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)bitsPerMapEntry * this.totalOfMapBuckets[i]);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        int[] bucketCounter = new int[this.numShards];
        int shardMask = this.numShards - 1;
        HollowWriteStateEnginePrimaryKeyHasher primaryKeyHasher = null;
        if (this.getSchema().getHashKey() != null) {
            primaryKeyHasher = new HollowWriteStateEnginePrimaryKeyHasher(this.getSchema().getHashKey(), this.getStateEngine());
        }
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            int shardOrdinal = ordinal / this.numShards;
            if (this.currentCyclePopulated.get(ordinal)) {
                int j;
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                int numBuckets = HashCodes.hashTableSize(size);
                this.mapPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerMapFixedLengthPortion * (long)shardOrdinal + (long)this.bitsPerMapPointer, this.bitsPerMapSizeValue, size);
                int keyElementOrdinal = 0;
                for (j = 0; j < numBuckets; ++j) {
                    this.entryData[shardNumber].setElementValue((long)bitsPerMapEntry * (long)(bucketCounter[shardNumber] + j), this.bitsPerKeyElement, (1L << this.bitsPerKeyElement) - 1L);
                }
                for (j = 0; j < size; ++j) {
                    int keyElementOrdinalDelta = VarInt.readVInt(data, readPointer);
                    int valueElementOrdinal = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(keyElementOrdinalDelta));
                    int hashedBucket = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(valueElementOrdinal));
                    readPointer += (long)VarInt.sizeOfVInt(hashedBucket);
                    keyElementOrdinal += keyElementOrdinalDelta;
                    if (primaryKeyHasher != null) {
                        hashedBucket = primaryKeyHasher.getRecordHash(keyElementOrdinal) & numBuckets - 1;
                    }
                    while (this.entryData[shardNumber].getElementValue((long)bitsPerMapEntry * (long)(bucketCounter[shardNumber] + hashedBucket), this.bitsPerKeyElement) != (1L << this.bitsPerKeyElement) - 1L) {
                        ++hashedBucket;
                        hashedBucket &= numBuckets - 1;
                    }
                    long mapEntryBitOffset = (long)bitsPerMapEntry * (long)(bucketCounter[shardNumber] + hashedBucket);
                    this.entryData[shardNumber].clearElementValue(mapEntryBitOffset, bitsPerMapEntry);
                    this.entryData[shardNumber].setElementValue(mapEntryBitOffset, this.bitsPerKeyElement, keyElementOrdinal);
                    this.entryData[shardNumber].setElementValue(mapEntryBitOffset + (long)this.bitsPerKeyElement, this.bitsPerValueElement, valueElementOrdinal);
                }
                int n = shardNumber;
                bucketCounter[n] = bucketCounter[n] + numBuckets;
            }
            this.mapPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerMapFixedLengthPortion * (long)shardOrdinal, this.bitsPerMapPointer, bucketCounter[shardNumber]);
        }
    }

    @Override
    public void writeSnapshot(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeSnapshotShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeSnapshotShard(os, i);
            }
        }
        this.currentCyclePopulated.serializeBitsTo(os);
        this.mapPointersAndSizesArray = null;
        this.entryData = null;
    }

    private void writeSnapshotShard(DataOutputStream os, int shardNumber) throws IOException {
        int bitsPerMapFixedLengthPortion = this.bitsPerMapSizeValue + this.bitsPerMapPointer;
        int bitsPerMapEntry = this.bitsPerKeyElement + this.bitsPerValueElement;
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        VarInt.writeVInt(os, this.bitsPerMapPointer);
        VarInt.writeVInt(os, this.bitsPerMapSizeValue);
        VarInt.writeVInt(os, this.bitsPerKeyElement);
        VarInt.writeVInt(os, this.bitsPerValueElement);
        VarInt.writeVLong(os, this.totalOfMapBuckets[shardNumber]);
        int numMapFixedLengthLongs = this.maxShardOrdinal[shardNumber] == -1 ? 0 : (int)(((long)(this.maxShardOrdinal[shardNumber] + 1) * (long)bitsPerMapFixedLengthPortion - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numMapFixedLengthLongs);
        for (int i = 0; i < numMapFixedLengthLongs; ++i) {
            os.writeLong(this.mapPointersAndSizesArray[shardNumber].get(i));
        }
        int numElementLongs = this.totalOfMapBuckets[shardNumber] == 0L ? 0 : (int)((this.totalOfMapBuckets[shardNumber] * (long)bitsPerMapEntry - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.entryData[shardNumber].get(i));
        }
    }

    @Override
    public void calculateDelta() {
        this.calculateDelta(this.previousCyclePopulated, this.currentCyclePopulated);
    }

    @Override
    public void writeDelta(DataOutputStream dos) throws IOException {
        this.writeCalculatedDelta(dos);
    }

    @Override
    public void calculateReverseDelta() {
        this.calculateDelta(this.currentCyclePopulated, this.previousCyclePopulated);
    }

    @Override
    public void writeReverseDelta(DataOutputStream dos) throws IOException {
        this.writeCalculatedDelta(dos);
    }

    private void calculateDelta(ThreadSafeBitSet fromCyclePopulated, ThreadSafeBitSet toCyclePopulated) {
        this.maxOrdinal = this.ordinalMap.maxOrdinal();
        int bitsPerMapFixedLengthPortion = this.bitsPerMapSizeValue + this.bitsPerMapPointer;
        int bitsPerMapEntry = this.bitsPerKeyElement + this.bitsPerValueElement;
        this.numMapsInDelta = new int[this.numShards];
        this.numBucketsInDelta = new long[this.numShards];
        this.mapPointersAndSizesArray = new FixedLengthElementArray[this.numShards];
        this.entryData = new FixedLengthElementArray[this.numShards];
        this.deltaAddedOrdinals = new ByteDataArray[this.numShards];
        this.deltaRemovedOrdinals = new ByteDataArray[this.numShards];
        ThreadSafeBitSet deltaAdditions = toCyclePopulated.andNot(fromCyclePopulated);
        int shardMask = this.numShards - 1;
        int addedOrdinal = deltaAdditions.nextSetBit(0);
        while (addedOrdinal != -1) {
            int n = addedOrdinal & shardMask;
            this.numMapsInDelta[n] = this.numMapsInDelta[n] + 1;
            long readPointer = this.ordinalMap.getPointerForData(addedOrdinal);
            int size = VarInt.readVInt(this.ordinalMap.getByteData().getUnderlyingArray(), readPointer);
            int n2 = addedOrdinal & shardMask;
            this.numBucketsInDelta[n2] = this.numBucketsInDelta[n2] + (long)HashCodes.hashTableSize(size);
            addedOrdinal = deltaAdditions.nextSetBit(addedOrdinal + 1);
        }
        for (int i = 0; i < this.numShards; ++i) {
            this.mapPointersAndSizesArray[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, (long)this.numMapsInDelta[i] * (long)bitsPerMapFixedLengthPortion);
            this.entryData[i] = new FixedLengthElementArray(WastefulRecycler.DEFAULT_INSTANCE, this.numBucketsInDelta[i] * (long)bitsPerMapEntry);
            this.deltaAddedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
            this.deltaRemovedOrdinals[i] = new ByteDataArray(WastefulRecycler.DEFAULT_INSTANCE);
        }
        SegmentedByteArray data = this.ordinalMap.getByteData().getUnderlyingArray();
        int[] mapCounter = new int[this.numShards];
        long[] bucketCounter = new long[this.numShards];
        int[] previousRemovedOrdinal = new int[this.numShards];
        int[] previousAddedOrdinal = new int[this.numShards];
        HollowWriteStateEnginePrimaryKeyHasher primaryKeyHasher = null;
        if (this.getSchema().getHashKey() != null) {
            primaryKeyHasher = new HollowWriteStateEnginePrimaryKeyHasher(this.getSchema().getHashKey(), this.getStateEngine());
        }
        for (int ordinal = 0; ordinal <= this.maxOrdinal; ++ordinal) {
            int shardNumber = ordinal & shardMask;
            if (deltaAdditions.get(ordinal)) {
                int j;
                long readPointer = this.ordinalMap.getPointerForData(ordinal);
                int size = VarInt.readVInt(data, readPointer);
                readPointer += (long)VarInt.sizeOfVInt(size);
                int numBuckets = HashCodes.hashTableSize(size);
                long endBucketPosition = bucketCounter[shardNumber] + (long)numBuckets;
                this.mapPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerMapFixedLengthPortion * (long)mapCounter[shardNumber], this.bitsPerMapPointer, endBucketPosition);
                this.mapPointersAndSizesArray[shardNumber].setElementValue((long)bitsPerMapFixedLengthPortion * (long)mapCounter[shardNumber] + (long)this.bitsPerMapPointer, this.bitsPerMapSizeValue, size);
                int keyElementOrdinal = 0;
                for (j = 0; j < numBuckets; ++j) {
                    this.entryData[shardNumber].setElementValue((long)bitsPerMapEntry * (bucketCounter[shardNumber] + (long)j), this.bitsPerKeyElement, (1L << this.bitsPerKeyElement) - 1L);
                }
                for (j = 0; j < size; ++j) {
                    int keyElementOrdinalDelta = VarInt.readVInt(data, readPointer);
                    int valueElementOrdinal = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(keyElementOrdinalDelta));
                    int hashedBucket = VarInt.readVInt(data, readPointer += (long)VarInt.sizeOfVInt(valueElementOrdinal));
                    readPointer += (long)VarInt.sizeOfVInt(hashedBucket);
                    keyElementOrdinal += keyElementOrdinalDelta;
                    if (primaryKeyHasher != null) {
                        hashedBucket = primaryKeyHasher.getRecordHash(keyElementOrdinal) & numBuckets - 1;
                    }
                    while (this.entryData[shardNumber].getElementValue((long)bitsPerMapEntry * (bucketCounter[shardNumber] + (long)hashedBucket), this.bitsPerKeyElement) != (1L << this.bitsPerKeyElement) - 1L) {
                        ++hashedBucket;
                        hashedBucket &= numBuckets - 1;
                    }
                    long mapEntryBitOffset = (long)bitsPerMapEntry * (bucketCounter[shardNumber] + (long)hashedBucket);
                    this.entryData[shardNumber].clearElementValue(mapEntryBitOffset, bitsPerMapEntry);
                    this.entryData[shardNumber].setElementValue(mapEntryBitOffset, this.bitsPerKeyElement, keyElementOrdinal);
                    this.entryData[shardNumber].setElementValue(mapEntryBitOffset + (long)this.bitsPerKeyElement, this.bitsPerValueElement, valueElementOrdinal);
                }
                int n = shardNumber;
                bucketCounter[n] = bucketCounter[n] + (long)numBuckets;
                int n3 = shardNumber;
                mapCounter[n3] = mapCounter[n3] + 1;
                int shardOrdinal = ordinal / this.numShards;
                VarInt.writeVInt(this.deltaAddedOrdinals[shardNumber], shardOrdinal - previousAddedOrdinal[shardNumber]);
                previousAddedOrdinal[shardNumber] = shardOrdinal;
                continue;
            }
            if (!fromCyclePopulated.get(ordinal) || toCyclePopulated.get(ordinal)) continue;
            int shardOrdinal = ordinal / this.numShards;
            VarInt.writeVInt(this.deltaRemovedOrdinals[shardNumber], shardOrdinal - previousRemovedOrdinal[shardNumber]);
            previousRemovedOrdinal[shardNumber] = shardOrdinal;
        }
    }

    private void writeCalculatedDelta(DataOutputStream os) throws IOException {
        if (this.numShards == 1) {
            this.writeCalculatedDeltaShard(os, 0);
        } else {
            VarInt.writeVInt(os, this.maxOrdinal);
            for (int i = 0; i < this.numShards; ++i) {
                this.writeCalculatedDeltaShard(os, i);
            }
        }
        this.mapPointersAndSizesArray = null;
        this.entryData = null;
        this.deltaAddedOrdinals = null;
        this.deltaRemovedOrdinals = null;
    }

    private void writeCalculatedDeltaShard(DataOutputStream os, int shardNumber) throws IOException {
        int bitsPerMapFixedLengthPortion = this.bitsPerMapSizeValue + this.bitsPerMapPointer;
        int bitsPerMapEntry = this.bitsPerKeyElement + this.bitsPerValueElement;
        VarInt.writeVInt(os, this.maxShardOrdinal[shardNumber]);
        VarInt.writeVLong(os, this.deltaRemovedOrdinals[shardNumber].length());
        this.deltaRemovedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaRemovedOrdinals[shardNumber].length());
        VarInt.writeVLong(os, this.deltaAddedOrdinals[shardNumber].length());
        this.deltaAddedOrdinals[shardNumber].getUnderlyingArray().writeTo(os, 0L, this.deltaAddedOrdinals[shardNumber].length());
        VarInt.writeVInt(os, this.bitsPerMapPointer);
        VarInt.writeVInt(os, this.bitsPerMapSizeValue);
        VarInt.writeVInt(os, this.bitsPerKeyElement);
        VarInt.writeVInt(os, this.bitsPerValueElement);
        VarInt.writeVLong(os, this.totalOfMapBuckets[shardNumber]);
        int numMapFixedLengthLongs = this.numMapsInDelta[shardNumber] == 0 ? 0 : (int)(((long)this.numMapsInDelta[shardNumber] * (long)bitsPerMapFixedLengthPortion - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numMapFixedLengthLongs);
        for (int i = 0; i < numMapFixedLengthLongs; ++i) {
            os.writeLong(this.mapPointersAndSizesArray[shardNumber].get(i));
        }
        int numElementLongs = this.numBucketsInDelta[shardNumber] == 0L ? 0 : (int)((this.numBucketsInDelta[shardNumber] * (long)bitsPerMapEntry - 1L) / 64L) + 1;
        VarInt.writeVInt(os, numElementLongs);
        for (int i = 0; i < numElementLongs; ++i) {
            os.writeLong(this.entryData[shardNumber].get(i));
        }
    }
}

