/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.api.producer.ProducerOptionalBlobPartConfig;
import com.netflix.hollow.core.HollowBlobHeader;
import com.netflix.hollow.core.HollowBlobOptionalPartHeader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowBlobHeaderWriter;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HollowBlobWriter {
    private final HollowWriteStateEngine stateEngine;
    private final HollowBlobHeaderWriter headerWriter;

    public HollowBlobWriter(HollowWriteStateEngine stateEngine) {
        this.stateEngine = stateEngine;
        this.headerWriter = new HollowBlobHeaderWriter();
    }

    public void writeSnapshot(OutputStream os) throws IOException {
        this.writeSnapshot(os, null);
    }

    public void writeSnapshot(OutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams) throws IOException {
        Map<Object, Object> partStreamsByType = Collections.emptyMap();
        if (partStreams != null) {
            partStreamsByType = partStreams.getStreamsByType();
        }
        this.stateEngine.prepareForWrite();
        DataOutputStream dos = new DataOutputStream(os);
        this.writeHeaders(dos, partStreams, this.stateEngine.getSchemas(), false);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "write-snapshot");
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    typeState.calculateSnapshot();
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            DataOutputStream partStream = (DataOutputStream)partStreamsByType.get(typeState.getSchema().getName());
            if (partStream == null) {
                partStream = dos;
            }
            HollowSchema schema = typeState.getSchema();
            schema.writeTo(partStream);
            this.writeNumShards(partStream, typeState.getNumShards());
            typeState.writeSnapshot(partStream);
        }
        os.flush();
        if (partStreams != null) {
            partStreams.flush();
        }
    }

    public void writeDelta(OutputStream os) throws IOException {
        this.writeDelta(os, null);
    }

    public void writeDelta(OutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams) throws IOException {
        Map<Object, Object> partStreamsByType = Collections.emptyMap();
        if (partStreams != null) {
            partStreamsByType = partStreams.getStreamsByType();
        }
        this.stateEngine.prepareForWrite();
        if (this.stateEngine.isRestored()) {
            this.stateEngine.ensureAllNecessaryStatesRestored();
        }
        List<HollowSchema> changedTypes = this.changedTypes();
        DataOutputStream dos = new DataOutputStream(os);
        this.writeHeaders(dos, partStreams, changedTypes, false);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "write-delta");
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (typeState.hasChangedSinceLastCycle()) {
                        typeState.calculateDelta();
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            if (!typeState.hasChangedSinceLastCycle()) continue;
            DataOutputStream partStream = (DataOutputStream)partStreamsByType.get(typeState.getSchema().getName());
            if (partStream == null) {
                partStream = dos;
            }
            HollowSchema schema = typeState.getSchema();
            schema.writeTo(partStream);
            this.writeNumShards(partStream, typeState.getNumShards());
            typeState.writeDelta(partStream);
        }
        os.flush();
        if (partStreams != null) {
            partStreams.flush();
        }
    }

    public void writeReverseDelta(OutputStream os) throws IOException {
        this.writeReverseDelta(os, null);
    }

    public void writeReverseDelta(OutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams) throws IOException {
        Map<Object, Object> partStreamsByType = Collections.emptyMap();
        if (partStreams != null) {
            partStreamsByType = partStreams.getStreamsByType();
        }
        this.stateEngine.prepareForWrite();
        if (this.stateEngine.isRestored()) {
            this.stateEngine.ensureAllNecessaryStatesRestored();
        }
        List<HollowSchema> changedTypes = this.changedTypes();
        DataOutputStream dos = new DataOutputStream(os);
        this.writeHeaders(dos, partStreams, changedTypes, true);
        SimultaneousExecutor executor = new SimultaneousExecutor(this.getClass(), "write-reverse-delta");
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (typeState.hasChangedSinceLastCycle()) {
                        typeState.calculateReverseDelta();
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (final HollowTypeWriteState typeState : this.stateEngine.getOrderedTypeStates()) {
            if (!typeState.hasChangedSinceLastCycle()) continue;
            DataOutputStream partStream = (DataOutputStream)partStreamsByType.get(typeState.getSchema().getName());
            if (partStream == null) {
                partStream = dos;
            }
            HollowSchema schema = typeState.getSchema();
            schema.writeTo(partStream);
            this.writeNumShards(partStream, typeState.getNumShards());
            typeState.writeReverseDelta(partStream);
        }
        os.flush();
        if (partStreams != null) {
            partStreams.flush();
        }
    }

    private List<HollowSchema> changedTypes() {
        ArrayList<HollowSchema> changedTypes = new ArrayList<HollowSchema>();
        List<HollowTypeWriteState> orderedTypeStates = this.stateEngine.getOrderedTypeStates();
        for (int i = 0; i < orderedTypeStates.size(); ++i) {
            HollowTypeWriteState writeState = orderedTypeStates.get(i);
            if (!writeState.hasChangedSinceLastCycle()) continue;
            changedTypes.add(writeState.getSchema());
        }
        return changedTypes;
    }

    private void writeNumShards(DataOutputStream dos, int numShards) throws IOException {
        VarInt.writeVInt(dos, 1 + VarInt.sizeOfVInt(numShards));
        VarInt.writeVInt(dos, 0);
        VarInt.writeVInt(dos, numShards);
    }

    private void writeHeaders(DataOutputStream os, ProducerOptionalBlobPartConfig.OptionalBlobPartOutputStreams partStreams, List<HollowSchema> schemasToInclude, boolean isReverseDelta) throws IOException {
        String partName;
        List<HollowSchema> mainSchemas = schemasToInclude;
        Map<String, List> schemasByPartName = Collections.emptyMap();
        if (partStreams != null) {
            mainSchemas = new ArrayList<HollowSchema>();
            Map<String, String> partNameByType = partStreams.getPartNameByType();
            schemasByPartName = new HashMap();
            for (HollowSchema hollowSchema : schemasToInclude) {
                partName = partNameByType.get(hollowSchema.getName());
                if (partName == null) {
                    mainSchemas.add(hollowSchema);
                    continue;
                }
                List partSchemas = schemasByPartName.computeIfAbsent(partName, n -> new ArrayList());
                partSchemas.add(hollowSchema);
            }
        }
        HollowBlobHeader header = new HollowBlobHeader();
        header.setHeaderTags(this.stateEngine.getHeaderTags());
        if (isReverseDelta) {
            header.setOriginRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
            header.setDestinationRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
        } else {
            header.setOriginRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
            header.setDestinationRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
        }
        header.setSchemas(mainSchemas);
        this.headerWriter.writeHeader(header, os);
        VarInt.writeVInt(os, mainSchemas.size());
        if (partStreams != null) {
            for (Map.Entry entry : partStreams.getPartStreams().entrySet()) {
                partName = (String)entry.getKey();
                HollowBlobOptionalPartHeader partHeader = new HollowBlobOptionalPartHeader(partName);
                if (isReverseDelta) {
                    partHeader.setOriginRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
                    partHeader.setDestinationRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
                } else {
                    partHeader.setOriginRandomizedTag(this.stateEngine.getPreviousStateRandomizedTag());
                    partHeader.setDestinationRandomizedTag(this.stateEngine.getNextStateRandomizedTag());
                }
                List<HollowSchema> partSchemas = (List<HollowSchema>)schemasByPartName.get(partName);
                if (partSchemas == null) {
                    partSchemas = Collections.emptyList();
                }
                partHeader.setSchemas(partSchemas);
                this.headerWriter.writePartHeader(partHeader, ((ProducerOptionalBlobPartConfig.ConfiguredOutputStream)entry.getValue()).getStream());
                VarInt.writeVInt(((ProducerOptionalBlobPartConfig.ConfiguredOutputStream)entry.getValue()).getStream(), partSchemas.size());
            }
        }
    }
}

