/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.write;

import com.netflix.hollow.core.HollowBlobHeader;
import com.netflix.hollow.core.HollowBlobOptionalPartHeader;
import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.schema.HollowSchema;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;

public class HollowBlobHeaderWriter {
    public void writeHeader(HollowBlobHeader header, DataOutputStream dos) throws IOException {
        dos.writeInt(1030);
        dos.writeLong(header.getOriginRandomizedTag());
        dos.writeLong(header.getDestinationRandomizedTag());
        ByteArrayOutputStream schemasStream = new ByteArrayOutputStream();
        VarInt.writeVInt(schemasStream, header.getSchemas().size());
        for (HollowSchema schema : header.getSchemas()) {
            schema.writeTo(schemasStream);
        }
        byte[] schemasData = schemasStream.toByteArray();
        VarInt.writeVInt(dos, schemasData.length + 1);
        dos.write(schemasData);
        VarInt.writeVInt(dos, 0);
        dos.writeShort(header.getHeaderTags().size());
        for (Map.Entry<String, String> headerTag : header.getHeaderTags().entrySet()) {
            dos.writeUTF(headerTag.getKey());
            dos.writeUTF(headerTag.getValue());
        }
    }

    public void writePartHeader(HollowBlobOptionalPartHeader header, DataOutputStream dos) throws IOException {
        dos.writeInt(1031);
        dos.writeUTF(header.getPartName());
        dos.writeLong(header.getOriginRandomizedTag());
        dos.writeLong(header.getDestinationRandomizedTag());
        VarInt.writeVInt(dos, header.getSchemas().size());
        for (HollowSchema schema : header.getSchemas()) {
            schema.writeTo(dos);
        }
        VarInt.writeVInt(dos, 0);
    }
}

