/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import com.netflix.hollow.core.util.Threads;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SimultaneousExecutor
extends ThreadPoolExecutor {
    private static final String DEFAULT_THREAD_NAME = "simultaneous-executor";
    private final List<Future<?>> futures = new ArrayList();

    public SimultaneousExecutor(Class<?> context, String description) {
        this(1.0, context, description);
    }

    @Deprecated
    public SimultaneousExecutor() {
        this(1.0, SimultaneousExecutor.class, DEFAULT_THREAD_NAME);
    }

    public SimultaneousExecutor(double threadsPerCpu, Class<?> context) {
        this(threadsPerCpu, context, DEFAULT_THREAD_NAME);
    }

    @Deprecated
    public SimultaneousExecutor(double threadsPerCpu) {
        this(threadsPerCpu, SimultaneousExecutor.class, DEFAULT_THREAD_NAME);
    }

    public SimultaneousExecutor(double threadsPerCpu, Class<?> context, String description) {
        this((int)((double)Runtime.getRuntime().availableProcessors() * threadsPerCpu), context, description);
    }

    @Deprecated
    public SimultaneousExecutor(double threadsPerCpu, String description) {
        this((int)((double)Runtime.getRuntime().availableProcessors() * threadsPerCpu), SimultaneousExecutor.class, description);
    }

    public SimultaneousExecutor(int numThreads, Class<?> context) {
        this(numThreads, context, DEFAULT_THREAD_NAME);
    }

    @Deprecated
    public SimultaneousExecutor(int numThreads) {
        this(numThreads, SimultaneousExecutor.class, DEFAULT_THREAD_NAME);
    }

    public SimultaneousExecutor(int numThreads, Class<?> context, String description) {
        this(numThreads, context, description, 5);
    }

    public SimultaneousExecutor(double threadsPerCpu, Class<?> context, String description, int threadPriority) {
        this((int)((double)Runtime.getRuntime().availableProcessors() * threadsPerCpu), context, description, threadPriority);
    }

    public SimultaneousExecutor(int numThreads, Class<?> context, String description, int threadPriority) {
        this(numThreads, (Runnable r) -> Threads.daemonThread(r, context, description, threadPriority));
    }

    protected SimultaneousExecutor(int numThreads, ThreadFactory threadFactory) {
        super(numThreads, numThreads, 100L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    @Deprecated
    public SimultaneousExecutor(int numThreads, String description) {
        this(numThreads, SimultaneousExecutor.class, description);
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof RunnableFuture) {
            super.execute(command);
        } else {
            super.execute(this.newTaskFor(command, Boolean.TRUE));
        }
    }

    public void awaitUninterruptibly() {
        this.shutdown();
        while (!this.isTerminated()) {
            try {
                this.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        RunnableFuture<T> task = super.newTaskFor(runnable, value);
        this.futures.add(task);
        return task;
    }

    @Override
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        RunnableFuture<T> task = super.newTaskFor(callable);
        this.futures.add(task);
        return task;
    }

    public void awaitSuccessfulCompletion() throws InterruptedException, ExecutionException {
        this.awaitUninterruptibly();
        for (Future<?> f : this.futures) {
            f.get();
        }
    }

    public void awaitSuccessfulCompletionOfCurrentTasks() throws InterruptedException, ExecutionException {
        for (Future<?> f : this.futures) {
            f.get();
        }
        this.futures.clear();
    }
}

