/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import java.util.Arrays;

public class LongList {
    private long[] values;
    private int size;

    public LongList() {
        this(12);
    }

    public LongList(int initialSize) {
        this.values = new long[initialSize];
    }

    public long get(int index) {
        return this.values[index];
    }

    public void add(long value) {
        if (this.values.length == this.size) {
            this.values = Arrays.copyOf(this.values, this.values.length * 3 / 2);
        }
        this.values[this.size++] = value;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.size);
    }

    public boolean equals(Object other) {
        if (other instanceof LongList) {
            LongList that = (LongList)other;
            if (this.size() == that.size()) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.get(i) == that.get(i)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = this.size;
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

