/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import com.netflix.hollow.core.read.engine.HollowReadStateEngine;
import com.netflix.hollow.core.read.engine.HollowTypeReadState;
import com.netflix.hollow.core.read.engine.PopulatedOrdinalListener;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSchema;
import com.netflix.hollow.core.schema.HollowSchemaParser;
import com.netflix.hollow.core.schema.HollowSetSchema;
import com.netflix.hollow.core.util.SimultaneousExecutor;
import com.netflix.hollow.core.write.HollowListTypeWriteState;
import com.netflix.hollow.core.write.HollowMapTypeWriteState;
import com.netflix.hollow.core.write.HollowObjectTypeWriteState;
import com.netflix.hollow.core.write.HollowSetTypeWriteState;
import com.netflix.hollow.core.write.HollowTypeWriteState;
import com.netflix.hollow.core.write.HollowWriteRecord;
import com.netflix.hollow.core.write.HollowWriteStateEngine;
import com.netflix.hollow.core.write.copy.HollowRecordCopier;
import com.netflix.hollow.tools.combine.IdentityOrdinalRemapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;

public class HollowWriteStateCreator {
    public static HollowWriteStateEngine createWithSchemas(Collection<HollowSchema> schemas) {
        HollowWriteStateEngine stateEngine = new HollowWriteStateEngine();
        HollowWriteStateCreator.populateStateEngineWithTypeWriteStates(stateEngine, schemas);
        return stateEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readSchemaFileIntoWriteState(String schemaFilePath, HollowWriteStateEngine engine) throws IOException {
        try (InputStream input = null;){
            input = HollowWriteStateCreator.class.getClassLoader().getResourceAsStream(schemaFilePath);
            List<HollowSchema> schemas = HollowSchemaParser.parseCollectionOfSchemas(new BufferedReader(new InputStreamReader(input)));
            HollowWriteStateCreator.populateStateEngineWithTypeWriteStates(engine, schemas);
        }
    }

    public static void populateStateEngineWithTypeWriteStates(HollowWriteStateEngine stateEngine, Collection<HollowSchema> schemas) {
        for (HollowSchema schema : schemas) {
            if (stateEngine.getTypeState(schema.getName()) != null) continue;
            switch (schema.getSchemaType()) {
                case OBJECT: {
                    stateEngine.addTypeState(new HollowObjectTypeWriteState((HollowObjectSchema)schema));
                    break;
                }
                case LIST: {
                    stateEngine.addTypeState(new HollowListTypeWriteState((HollowListSchema)schema));
                    break;
                }
                case SET: {
                    stateEngine.addTypeState(new HollowSetTypeWriteState((HollowSetSchema)schema));
                    break;
                }
                case MAP: {
                    stateEngine.addTypeState(new HollowMapTypeWriteState((HollowMapSchema)schema));
                }
            }
        }
    }

    public static HollowWriteStateEngine recreateAndPopulateUsingReadEngine(HollowReadStateEngine readEngine) {
        HollowWriteStateEngine writeEngine = new HollowWriteStateEngine();
        HollowWriteStateCreator.populateStateEngineWithTypeWriteStates(writeEngine, readEngine.getSchemas());
        HollowWriteStateCreator.populateUsingReadEngine(writeEngine, readEngine);
        return writeEngine;
    }

    public static void populateUsingReadEngine(HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine) {
        HollowWriteStateCreator.populateUsingReadEngine(writeEngine, readEngine, true);
    }

    public static void populateUsingReadEngine(final HollowWriteStateEngine writeEngine, HollowReadStateEngine readEngine, final boolean preserveHashPositions) {
        SimultaneousExecutor executor = new SimultaneousExecutor(HollowWriteStateCreator.class, "populate");
        for (HollowTypeWriteState writeState : writeEngine.getOrderedTypeStates()) {
            if (writeState.getPopulatedBitSet().cardinality() == 0 && writeState.getPreviousCyclePopulatedBitSet().cardinality() == 0) continue;
            throw new IllegalStateException("The supplied HollowWriteStateEngine is already populated!");
        }
        for (final HollowTypeReadState readState : readEngine.getTypeStates()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    HollowTypeWriteState writeState = writeEngine.getTypeState(readState.getSchema().getName());
                    if (writeState != null) {
                        writeState.setNumShards(readState.numShards());
                        HollowRecordCopier copier = HollowRecordCopier.createCopier(readState, writeState.getSchema(), IdentityOrdinalRemapper.INSTANCE, preserveHashPositions);
                        BitSet populatedOrdinals = readState.getListener(PopulatedOrdinalListener.class).getPopulatedOrdinals();
                        writeState.resizeOrdinalMap(populatedOrdinals.cardinality());
                        int ordinal = populatedOrdinals.nextSetBit(0);
                        while (ordinal != -1) {
                            HollowWriteRecord rec = copier.copy(ordinal);
                            writeState.mapOrdinal(rec, ordinal, false, true);
                            ordinal = populatedOrdinals.nextSetBit(ordinal + 1);
                        }
                        writeState.recalculateFreeOrdinals();
                    }
                }
            });
        }
        try {
            executor.awaitSuccessfulCompletion();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        writeEngine.addHeaderTags(readEngine.getHeaderTags());
        writeEngine.overrideNextStateRandomizedTag(readEngine.getCurrentRandomizedTag());
        writeEngine.prepareForWrite();
    }
}

