/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.util;

import java.util.BitSet;
import java.util.Iterator;

public class BitSetIterator
implements Iterator<Integer> {
    private final BitSet bitset;
    private final Integer limit;
    private int next = -1;
    private int count = 0;

    public BitSetIterator(BitSet bitSet) {
        this(bitSet, null, null);
    }

    public BitSetIterator(BitSet bitSet, Integer start, Integer limit) {
        this.bitset = bitSet;
        this.limit = limit == null ? Integer.MAX_VALUE : limit;
        if (start == null || start <= 1) {
            this.next = this.bitset.nextSetBit(0);
        } else {
            for (int i = 0; i < start; ++i) {
                this.next = this.bitset.nextSetBit(this.next + 1);
                if (this.next == -1) break;
            }
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != -1;
    }

    @Override
    public Integer next() {
        if (!this.hasNext()) {
            return null;
        }
        int returnValue = this.next;
        this.next = this.bitset.nextSetBit(this.next + 1);
        if (++this.count >= this.limit) {
            this.next = -1;
        }
        return returnValue;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

