/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.schema;

import com.netflix.hollow.core.memory.encoding.VarInt;
import com.netflix.hollow.core.read.HollowBlobInput;
import com.netflix.hollow.core.schema.HollowListSchema;
import com.netflix.hollow.core.schema.HollowMapSchema;
import com.netflix.hollow.core.schema.HollowObjectSchema;
import com.netflix.hollow.core.schema.HollowSetSchema;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class HollowSchema {
    private final String name;

    public HollowSchema(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Type name in Hollow Schema was " + (name == null ? "null" : "an empty string"));
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract SchemaType getSchemaType();

    public abstract void writeTo(OutputStream var1) throws IOException;

    public static HollowSchema withoutKeys(HollowSchema schema) {
        switch (schema.getSchemaType()) {
            case SET: {
                HollowSetSchema setSchema = (HollowSetSchema)schema;
                if (setSchema.getHashKey() != null) {
                    setSchema = new HollowSetSchema(setSchema.getName(), setSchema.getElementType(), new String[0]);
                }
                return setSchema;
            }
            case MAP: {
                HollowMapSchema mapSchema = (HollowMapSchema)schema;
                if (mapSchema.getHashKey() != null) {
                    mapSchema = new HollowMapSchema(mapSchema.getName(), mapSchema.getKeyType(), mapSchema.getValueType(), new String[0]);
                }
                return mapSchema;
            }
        }
        return schema;
    }

    public static HollowSchema readFrom(InputStream is) throws IOException {
        HollowBlobInput hbi = HollowBlobInput.serial(is);
        return HollowSchema.readFrom(hbi);
    }

    public static HollowSchema readFrom(HollowBlobInput in) throws IOException {
        int schemaTypeId = in.read();
        String schemaName = in.readUTF();
        switch (SchemaType.fromTypeId(schemaTypeId)) {
            case OBJECT: {
                return HollowSchema.readObjectSchemaFrom(in, schemaName, SchemaType.hasKey(schemaTypeId));
            }
            case LIST: {
                return HollowSchema.readListSchemaFrom(in, schemaName);
            }
            case SET: {
                return HollowSchema.readSetSchemaFrom(in, schemaName, SchemaType.hasKey(schemaTypeId));
            }
            case MAP: {
                return HollowSchema.readMapSchemaFrom(in, schemaName, SchemaType.hasKey(schemaTypeId));
            }
        }
        throw new IOException();
    }

    private static HollowObjectSchema readObjectSchemaFrom(HollowBlobInput in, String schemaName, boolean hasPrimaryKey) throws IOException {
        int numFields;
        String[] keyFieldPaths = null;
        if (hasPrimaryKey) {
            numFields = VarInt.readVInt(in);
            keyFieldPaths = new String[numFields];
            for (int i = 0; i < numFields; ++i) {
                keyFieldPaths[i] = in.readUTF();
            }
        }
        numFields = in.readShort();
        HollowObjectSchema schema = new HollowObjectSchema(schemaName, numFields, keyFieldPaths);
        for (int i = 0; i < numFields; ++i) {
            String fieldName = in.readUTF();
            HollowObjectSchema.FieldType fieldType = HollowObjectSchema.FieldType.valueOf(in.readUTF());
            String referencedType = fieldType == HollowObjectSchema.FieldType.REFERENCE ? in.readUTF() : null;
            schema.addField(fieldName, fieldType, referencedType);
        }
        return schema;
    }

    private static HollowSetSchema readSetSchemaFrom(HollowBlobInput in, String schemaName, boolean hasHashKey) throws IOException {
        String elementType = in.readUTF();
        String[] hashKeyFields = null;
        if (hasHashKey) {
            int numFields = VarInt.readVInt(in);
            hashKeyFields = new String[numFields];
            for (int i = 0; i < numFields; ++i) {
                hashKeyFields[i] = in.readUTF();
            }
        }
        return new HollowSetSchema(schemaName, elementType, hashKeyFields);
    }

    private static HollowListSchema readListSchemaFrom(HollowBlobInput in, String schemaName) throws IOException {
        String elementType = in.readUTF();
        return new HollowListSchema(schemaName, elementType);
    }

    private static HollowMapSchema readMapSchemaFrom(HollowBlobInput in, String schemaName, boolean hasHashKey) throws IOException {
        String keyType = in.readUTF();
        String valueType = in.readUTF();
        String[] hashKeyFields = null;
        if (hasHashKey) {
            int numFields = VarInt.readVInt(in);
            hashKeyFields = new String[numFields];
            for (int i = 0; i < numFields; ++i) {
                hashKeyFields[i] = in.readUTF();
            }
        }
        return new HollowMapSchema(schemaName, keyType, valueType, hashKeyFields);
    }

    protected static <T> boolean isNullableObjectEquals(T o1, T o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        return o1 != null && o1.equals(o2);
    }

    public static enum SchemaType {
        OBJECT(0, 6),
        SET(1, 4),
        LIST(2, -1),
        MAP(3, 5);

        private final int typeId;
        private final int typeIdWithPrimaryKey;

        private SchemaType(int typeId, int typeIdWithPrimaryKey) {
            this.typeId = typeId;
            this.typeIdWithPrimaryKey = typeIdWithPrimaryKey;
        }

        public int getTypeId() {
            return this.typeId;
        }

        public int getTypeIdWithPrimaryKey() {
            return this.typeIdWithPrimaryKey;
        }

        public static SchemaType fromTypeId(int id) {
            switch (id) {
                case 0: 
                case 6: {
                    return OBJECT;
                }
                case 1: 
                case 4: {
                    return SET;
                }
                case 2: {
                    return LIST;
                }
                case 3: 
                case 5: {
                    return MAP;
                }
            }
            throw new IllegalArgumentException("Cannot recognize HollowSchema type id " + id);
        }

        public static boolean hasKey(int typeId) {
            return typeId == 4 || typeId == 5 || typeId == 6;
        }

        public static class UnrecognizedSchemaTypeException
        extends IllegalStateException {
            public UnrecognizedSchemaTypeException(String name, SchemaType type) {
                super("unrecognized schema type; name=" + name + " type=" + (Object)((Object)type));
            }
        }
    }
}

