/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.iterator;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowSetTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowOrdinalIterator;

public class HollowSetOrdinalIterator
implements HollowOrdinalIterator {
    private final int setOrdinal;
    private final HollowSetTypeDataAccess dataAccess;
    private final int numBuckets;
    private int currentBucket = -1;

    public HollowSetOrdinalIterator(int setOrdinal, HollowSetTypeDataAccess dataAccess) {
        this.setOrdinal = setOrdinal;
        this.dataAccess = dataAccess;
        this.numBuckets = HashCodes.hashTableSize(dataAccess.size(setOrdinal));
    }

    @Override
    public int next() {
        int bucketValue = -1;
        while (bucketValue == -1) {
            ++this.currentBucket;
            if (this.currentBucket >= this.numBuckets) {
                return Integer.MAX_VALUE;
            }
            bucketValue = this.dataAccess.relativeBucketValue(this.setOrdinal, this.currentBucket);
        }
        return bucketValue;
    }

    public int getCurrentBucket() {
        return this.currentBucket;
    }
}

