/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hollow.core.read.iterator;

import com.netflix.hollow.core.memory.encoding.HashCodes;
import com.netflix.hollow.core.read.dataaccess.HollowMapTypeDataAccess;
import com.netflix.hollow.core.read.iterator.HollowMapEntryOrdinalIterator;

public class HollowMapEntryOrdinalIteratorImpl
implements HollowMapEntryOrdinalIterator {
    private final int mapOrdinal;
    private final HollowMapTypeDataAccess dataAccess;
    private final int numBuckets;
    private int currentBucket = -1;
    private int key;
    private int value;

    public HollowMapEntryOrdinalIteratorImpl(int mapOrdinal, HollowMapTypeDataAccess dataAccess) {
        this.mapOrdinal = mapOrdinal;
        this.dataAccess = dataAccess;
        this.numBuckets = HashCodes.hashTableSize(dataAccess.size(mapOrdinal));
    }

    @Override
    public int getKey() {
        return this.key;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public int getCurrentBucket() {
        return this.currentBucket;
    }

    @Override
    public boolean next() {
        this.key = -1;
        while (this.key == -1) {
            ++this.currentBucket;
            if (this.currentBucket >= this.numBuckets) {
                return false;
            }
            long bucketVal = this.dataAccess.relativeBucket(this.mapOrdinal, this.currentBucket);
            this.key = (int)(bucketVal >>> 32);
            this.value = (int)bucketVal;
        }
        return true;
    }
}

